/*
  Copyright (C) 2003  Taiga Yonekura, taiga@col.hi-ho.ne.jp

  For more information about this appliation please look at:
   http://www.pat.hi-ho.ne.jp/kyonekura

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/
#include <qpixmap.h>

#include "levelSelector.h"
#include "config.h"
#include "./images/levelBtn.c"

CLevelSelector::CLevelSelector()
{

  // set Images
  m_SelectorImg[0].loadFromData(HARDBTN_IMG_DATA, sizeof (HARDBTN_IMG_DATA));
  m_SelectorImg[1].loadFromData(HARDBTNOFF_IMG_DATA, sizeof (HARDBTNOFF_IMG_DATA));
  m_SelectorImg[2].loadFromData(EASYBTN_IMG_DATA, sizeof (EASYBTN_IMG_DATA));
  m_SelectorImg[3].loadFromData(EASYBTNOFF_IMG_DATA, sizeof (EASYBTNOFF_IMG_DATA));

  //set easy
  m_bHLevel = false;

  // create button
  m_pButton[0] = new CButton( &m_SelectorImg[1], HARDBTN_POSX, HARDBTN_POSY );
  m_pButton[1] = new CButton( &m_SelectorImg[2], EASYBTN_POSX, EASYBTN_POSY );

}
//
// check level label clicked.
//
bool CLevelSelector::ClickLevel(int x, int y)
{

  if( m_pButton[0]->isOn( x, y ) ){

    if( m_bHLevel ){
      // fix hard
      return true;
    } else {
      changeLevel();
    }

  } else if( m_pButton[1]->isOn( x, y ) ){

    if( !m_bHLevel ){
      // fix easy
      return true;
    } else {
      changeLevel();
    }

  }

  return false;

}
//
// Draw selector button
//
void CLevelSelector::Draw(QPainter *paint)
{
  m_pButton[0]->draw( paint );
  m_pButton[1]->draw( paint );
}
void CLevelSelector::changeLevel()
{

  if( m_bHLevel ){

    // current level hard -> easy
    m_pButton[0]->SetImage( &m_SelectorImg[1] );
    m_pButton[1]->SetImage( &m_SelectorImg[2] );
    m_bHLevel = false;

  } else {

    // current level easy -> hard
    m_pButton[0]->SetImage( &m_SelectorImg[0] );
    m_pButton[1]->SetImage( &m_SelectorImg[3] );    
    m_bHLevel = true;

  }

}
//
//
//
bool CLevelSelector::IsHardSelected()
{
  return m_bHLevel;
}
