/*
  Copyright (C) 2003  Taiga Yonekura, taiga@col.hi-ho.ne.jp

  For more information about this appliation please look at:
   http://www.pat.hi-ho.ne.jp/kyonekura

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/
#ifndef STRINGDISPLAY_H
#define STRINGDISPLAY_H

#include <qpixmap.h>
#include <qpainter.h>
#include <qstring.h>

class CStringDisplay
{
 
 public:

  CStringDisplay();
  void Draw(QPainter *paint, QString *str, int x, int y);
  void Draw(QPainter *paint, int type, int x, int y);
  QPixmap* GetImage(QChar ch);
  QPixmap* GetImage(int ch);
  QChar GetImageCh(QPixmap *img);

  enum CTRL{
    MOV_LEFT,
    MOV_RIGHT,
    DELETE,
    CTRL_COUNT
  };

 private:
  void loadImage();
  int getImageIndex(QChar ch);
  enum ALPHA{
    CHAR_A,
    CHAR_B,
    CHAR_C, 
    CHAR_D,
    CHAR_E,
    CHAR_F,
    CHAR_G,
    CHAR_H, 
    CHAR_I,
    CHAR_J,
    CHAR_K,
    CHAR_L,
    CHAR_M, 
    CHAR_N,
    CHAR_O,
    CHAR_P,
    CHAR_Q,
    CHAR_R, 
    CHAR_S,
    CHAR_T,
    CHAR_U,
    CHAR_V, 
    CHAR_W,
    CHAR_X,
    CHAR_Y, 
    CHAR_Z,
    CHAR_DOT,
    CHAR_MINUS
  };

  QPixmap m_charBMP[CHAR_MINUS+1];  //Images
  QChar   m_strTable[CHAR_MINUS+1]; 

  QPixmap m_ctrlBMP[CTRL_COUNT]; 

};

#endif
