/*
  Copyright (C) 2003  Taiga Yonekura, taiga@col.hi-ho.ne.jp

  For more information about this appliation please look at:
   http://www.pat.hi-ho.ne.jp/kyonekura

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/
#include "StringDisplay.h"
#include "./images/alpha.c"


CStringDisplay::CStringDisplay()
{
  loadImage();
}
void CStringDisplay::loadImage()
{

  m_charBMP[CHAR_A].loadFromData( A_data_, sizeof (A_data_) );
  m_charBMP[CHAR_B].loadFromData( B_data_, sizeof (B_data_) );
  m_charBMP[CHAR_C].loadFromData( C_data_, sizeof (C_data_) );
  m_charBMP[CHAR_D].loadFromData( D_data_, sizeof (D_data_) );
  m_charBMP[CHAR_E].loadFromData( E_data_, sizeof (E_data_) );
  m_charBMP[CHAR_F].loadFromData( F_data_, sizeof (F_data_) );
  m_charBMP[CHAR_G].loadFromData( G_data_, sizeof (G_data_) );
  m_charBMP[CHAR_H].loadFromData( H_data_, sizeof (H_data_) );
  m_charBMP[CHAR_I].loadFromData( I_data_, sizeof (I_data_) );
  m_charBMP[CHAR_J].loadFromData( J_data_, sizeof (J_data_) );
  m_charBMP[CHAR_K].loadFromData( K_data_, sizeof (K_data_) );
  m_charBMP[CHAR_L].loadFromData( L_data_, sizeof (L_data_) );
  m_charBMP[CHAR_M].loadFromData( M_data_, sizeof (M_data_) );
  m_charBMP[CHAR_N].loadFromData( N_data_, sizeof (N_data_) );
  m_charBMP[CHAR_O].loadFromData( O_data_, sizeof (O_data_) );
  m_charBMP[CHAR_P].loadFromData( P_data_, sizeof (P_data_) );
  m_charBMP[CHAR_Q].loadFromData( Q_data_, sizeof (Q_data_) );
  m_charBMP[CHAR_R].loadFromData( R_data_, sizeof (R_data_) );
  m_charBMP[CHAR_S].loadFromData( S_data_, sizeof (S_data_) );
  m_charBMP[CHAR_T].loadFromData( T_data_, sizeof (T_data_) );
  m_charBMP[CHAR_U].loadFromData( U_data_, sizeof (U_data_) );
  m_charBMP[CHAR_V].loadFromData( V_data_, sizeof (V_data_) );
  m_charBMP[CHAR_W].loadFromData( W_data_, sizeof (W_data_) );
  m_charBMP[CHAR_X].loadFromData( X_data_, sizeof (X_data_) );
  m_charBMP[CHAR_Y].loadFromData( Y_data_, sizeof (Y_data_) );
  m_charBMP[CHAR_Z].loadFromData( Z_data_, sizeof (Z_data_) );

  m_charBMP[CHAR_DOT].loadFromData( dot_data_, sizeof (dot_data_) );
  m_charBMP[CHAR_MINUS].loadFromData( Hihun_data_, sizeof (Hihun_data_) );

  /* init table */
  m_strTable[CHAR_A] = QChar('A');
  m_strTable[CHAR_B] = QChar('B');
  m_strTable[CHAR_C] = QChar('C');
  m_strTable[CHAR_D] = QChar('D');
  m_strTable[CHAR_E] = QChar('E');
  m_strTable[CHAR_F] = QChar('F');
  m_strTable[CHAR_G] = QChar('G');
  m_strTable[CHAR_H] = QChar('H');
  m_strTable[CHAR_I] = QChar('I');
  m_strTable[CHAR_J] = QChar('J');
  m_strTable[CHAR_K] = QChar('K');
  m_strTable[CHAR_L] = QChar('L');
  m_strTable[CHAR_M] = QChar('M');
  m_strTable[CHAR_N] = QChar('N');
  m_strTable[CHAR_O] = QChar('O');
  m_strTable[CHAR_P] = QChar('P');
  m_strTable[CHAR_Q] = QChar('Q');
  m_strTable[CHAR_R] = QChar('R');
  m_strTable[CHAR_S] = QChar('S');
  m_strTable[CHAR_T] = QChar('T');
  m_strTable[CHAR_U] = QChar('U');
  m_strTable[CHAR_V] = QChar('V');
  m_strTable[CHAR_W] = QChar('W');
  m_strTable[CHAR_X] = QChar('X');
  m_strTable[CHAR_Y] = QChar('Y');
  m_strTable[CHAR_Z] = QChar('Z');
  m_strTable[CHAR_DOT] = QChar('.');
  m_strTable[CHAR_MINUS] = QChar('-');

  // for control
  m_ctrlBMP[MOV_LEFT].loadFromData( arrow2_data_, sizeof (arrow2_data_) );
  m_ctrlBMP[MOV_RIGHT].loadFromData( arrow1_data_, sizeof (arrow1_data_) );
  m_ctrlBMP[DELETE].loadFromData( del_data_, sizeof (del_data_) );



}
int CStringDisplay::getImageIndex(QChar ch)
{

  for(int i= CHAR_A; i < CHAR_MINUS + 1; i++ ){

    if( m_strTable[i] == ch ){
      return i;
    }

  }
  
  return -1; 
}
//
// Draw String Imgae
//
void CStringDisplay::Draw(QPainter *paint, QString *str, int x, int y)
{
  uint length;
  int idx;
  int current;
  int chrWidth = m_charBMP[0].width();
  current = x;
  
  length = str->length();

  for(uint i = 0; i < length ; i++){

    QChar chr = str->at(i);
    idx = getImageIndex(chr);
    if( idx != -1 ){
      paint->drawPixmap( current, y, m_charBMP[idx] );
    }

    current+=chrWidth;

  }

}
//
// Draw Control Image 
//
void CStringDisplay::Draw(QPainter *paint, int type, int x, int y)
{

  if( ( -1 <= type ) && ( type < CTRL_COUNT ) ){
      paint->drawPixmap( x, y, m_ctrlBMP[ type ] );
  }

}
//
// Get String Image
//
QPixmap* CStringDisplay::GetImage(QChar ch)
{

  QPixmap* RetImg = NULL;
  int idx;

  idx = getImageIndex(ch);
  if( idx != -1 ){
    RetImg = &m_charBMP[idx];
  }

  return RetImg;
  
}
//
// Get Control Image
//
QPixmap* CStringDisplay::GetImage(int type)
{
  return &m_ctrlBMP[ type ]; 
}
//
//
//
QChar CStringDisplay::GetImageCh(QPixmap *img)
{

  for(int i= CHAR_A; i < CHAR_MINUS + 1; i++ ){

    if( &m_charBMP[i] == img ){
      return m_strTable[i];
    }

  }

  return QChar(' ');

}
