/*
  Copyright (C) 2003  Taiga Yonekura, taiga@col.hi-ho.ne.jp

  For more information about this appliation please look at:
   http://www.pat.hi-ho.ne.jp/kyonekura

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/

#include "HitArea.h"
CHitArea::CHitArea()
{
  m_offset_x = 0;
  m_offset_y = 0;

  m_width = 0;
  m_height = 0; 

  m_basepos_x = 0;
  m_basepos_y = 0;
}
CHitArea::CHitArea( int offset_x, int offset_y, int width, int hegiht )
{

  m_offset_x = offset_x;
  m_offset_y = offset_y;

  m_width = width;
  m_height = hegiht;

}
void CHitArea:: SetBasePos( int x, int y )
{
  m_basepos_x = x;
  m_basepos_y = y;  
}
int CHitArea:: GetWidth()
{
  return m_width;
} 
int CHitArea::GetHeight()
{
  return m_height;
} 
int CHitArea::GetPosX()
{
  return  m_basepos_x + m_offset_x;
}
int CHitArea::GetPosY()
{
  return m_basepos_y + m_offset_y;
}
//
// note: the arg(area) must be bigger than self.
//
int CHitArea::Compare( CHitArea* area )
{

  int target_x = area->GetPosX();
  int target_y = area->GetPosY();
  int target_width = area->GetWidth();
  int target_height = area->GetHeight();
  bool inUpLeft = false,inBottomRight = false;

  if( (target_x <= GetPosX() && GetPosX() <=  target_x + target_width ) &&
      (target_y <= GetPosY() && GetPosY() <=  target_y + target_height ) ){

    inUpLeft = true;

  }

  if( (target_x <= GetPosX() + m_width  && GetPosX() + m_width  <=  target_x + target_width ) &&
      (target_y <= GetPosY() + m_height && GetPosY() + m_height <=  target_y + target_height ) ){

    inBottomRight = true;

  }

  if( inUpLeft && inBottomRight ){
    // included
    return AREA_INCLUDED;
  }

  if( inUpLeft || inBottomRight ){
    // conflict
    return AREA_CONFLICT;
  }

  return AREA_NO_CONFLICT;
}
CHitArea& CHitArea::operator=(const CHitArea& src)
{

  m_basepos_x = src.m_basepos_x;
  m_basepos_y = src.m_basepos_y;
  
  m_offset_x = src.m_offset_x;
  m_offset_y = src.m_offset_y;

  m_width = src.m_width;
  m_height = src.m_height;
  m_basepos_x = src.m_basepos_x;

  return *this;
}
