/*
  Copyright (C) 2003  Taiga Yonekura, taiga@col.hi-ho.ne.jp

  For more information about this appliation please look at:
   http://www.pat.hi-ho.ne.jp/kyonekura

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/
#ifndef HISCOREREG_H
#define HISCOREREG_H

#include <qpainter.h>
#include <qstring.h>

#include "StringDisplay.h"
#include "StringBtn.h"

#define HINAME_MAX 6

class CHiScoreReg
{

 public:

  CHiScoreReg( CStringDisplay* pStrDisp );
  void DrawRegistView(QPainter *paint, int width, int height);
  bool OnTap( int x, int y );
  QString GetName();

 private:

  CStringBtn* m_pStrBtn[32];
  CStringBtn* m_pName[HINAME_MAX];

  QPixmap *m_pBrankImg;

  int m_inputedCnt;
  int m_blinkInterval;
  bool m_blink;
  void clearNameFiled();

  enum BTNTYPE{
    SINGLECH_BTN,
    OK_BTN,
    DEL_BTN,
    ARROWLEFT_BTN,
    ARROWRIGHT_BTN
  };

};

#endif
 
