/*
  Copyright (C) 2003  Taiga Yonekura, taiga@col.hi-ho.ne.jp

  For more information about this appliation please look at:
   http://www.pat.hi-ho.ne.jp/kyonekura

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/

#include "Display.h"
#include "StringDisplay.h"
#include "stopwatch.h"
#include "config.h"

#include "images/data.c"
#include "images/fish2.c"
#include "images/kingyo.c"
#include "images/numImg.c"
#include "images/timeImg.c"


#define BOOT_LOGOSTRING "PRESENTS"
#define COPYRIGHT   "(C)1997-2004 TAIGA YONEKURA ALL RIGHTS RESERVED"
#define CLEAR_STR    "Clear Time is "
#define CLEARMSG_STR "CONGRATURATION !!"
#define TIMEH_STR    " h : "
#define TIMEM_STR    " m : "
#define TIMES_STR    " s : "

CDisplay::CDisplay()
{
  
  /* load image datas */
  m_fishBMP0[0].loadFromData(MIXFISH1_IMG_DATA, sizeof (MIXFISH1_IMG_DATA));
  m_fishBMP0[1].loadFromData(MIXFISH2_IMG_DATA, sizeof (MIXFISH2_IMG_DATA));
  m_fishBMP0[2].loadFromData(MIXFISH3_IMG_DATA, sizeof (MIXFISH3_IMG_DATA));
  m_fishBMP0[3].loadFromData(MIXFISH4_IMG_DATA, sizeof (MIXFISH4_IMG_DATA));
  m_fishBMP0[4].loadFromData(MIXFISH5_IMG_DATA, sizeof (MIXFISH5_IMG_DATA));
  m_fishBMP0[5].loadFromData(MIXFISH6_IMG_DATA, sizeof (MIXFISH6_IMG_DATA));
  m_fishBMP0[6].loadFromData(MIXFISH7_IMG_DATA, sizeof (MIXFISH7_IMG_DATA));
  m_fishBMP0[7].loadFromData(MIXFISH8_IMG_DATA, sizeof (MIXFISH8_IMG_DATA));

  m_fishBMP1[0].loadFromData(BLACKFISH1_IMG_DATA, sizeof (BLACKFISH1_IMG_DATA));
  m_fishBMP1[1].loadFromData(BLACKFISH2_IMG_DATA, sizeof (BLACKFISH2_IMG_DATA));
  m_fishBMP1[2].loadFromData(BLACKFISH3_IMG_DATA, sizeof (BLACKFISH3_IMG_DATA));
  m_fishBMP1[3].loadFromData(BLACKFISH4_IMG_DATA, sizeof (BLACKFISH4_IMG_DATA));
  m_fishBMP1[4].loadFromData(BLACKFISH5_IMG_DATA, sizeof (BLACKFISH5_IMG_DATA));
  m_fishBMP1[5].loadFromData(BLACKFISH6_IMG_DATA, sizeof (BLACKFISH6_IMG_DATA));
  m_fishBMP1[6].loadFromData(BLACKFISH7_IMG_DATA, sizeof (BLACKFISH7_IMG_DATA));
  m_fishBMP1[7].loadFromData(BLACKFISH8_IMG_DATA, sizeof (BLACKFISH8_IMG_DATA));

  m_titleBMP.loadFromData(TITLE_IMG_DATA, sizeof (TITLE_IMG_DATA));

  m_fishListBMP[0].loadFromData(FISHLIST1_IMG_DATA, sizeof (FISHLIST1_IMG_DATA));
  m_fishListBMP[1].loadFromData(FISHLIST2_IMG_DATA, sizeof (FISHLIST2_IMG_DATA));

  m_netBMP[0].loadFromData(NET1_IMG_DATA, sizeof (NET1_IMG_DATA));
  m_netBMP[1].loadFromData(NET2_IMG_DATA, sizeof (NET2_IMG_DATA));
  m_netBMP[2].loadFromData(NET3_IMG_DATA, sizeof (NET3_IMG_DATA));

  m_logoBMP.loadFromData(TLOGO_IMG_DATA, sizeof (TLOGO_IMG_DATA));
  m_titleNumBMP.loadFromData(VERLOGO_IMG_DATA, sizeof (VERLOGO_IMG_DATA));

  //m_text.loadFromData(text_data_, sizeof (text_data_));

  // NumberImages
  m_numBMP[0].loadFromData(NUM0_IMG_DATA, sizeof (NUM0_IMG_DATA));
  m_numBMP[1].loadFromData(NUM1_IMG_DATA, sizeof (NUM1_IMG_DATA));
  m_numBMP[2].loadFromData(NUM2_IMG_DATA, sizeof (NUM2_IMG_DATA));
  m_numBMP[3].loadFromData(NUM3_IMG_DATA, sizeof (NUM3_IMG_DATA));
  m_numBMP[4].loadFromData(NUM4_IMG_DATA, sizeof (NUM4_IMG_DATA));
  m_numBMP[5].loadFromData(NUM5_IMG_DATA, sizeof (NUM5_IMG_DATA));
  m_numBMP[6].loadFromData(NUM6_IMG_DATA, sizeof (NUM6_IMG_DATA));
  m_numBMP[7].loadFromData(NUM7_IMG_DATA, sizeof (NUM7_IMG_DATA));
  m_numBMP[8].loadFromData(NUM8_IMG_DATA, sizeof (NUM8_IMG_DATA));
  m_numBMP[9].loadFromData(NUM9_IMG_DATA, sizeof (NUM9_IMG_DATA));

  // Time Images
  m_timeBMP[0].loadFromData(HOUR_IMG_DATA, sizeof (HOUR_IMG_DATA));
  m_timeBMP[1].loadFromData(MIN_IMG_DATA, sizeof (MIN_IMG_DATA));
  m_timeBMP[2].loadFromData(SEC_IMG_DATA, sizeof (SEC_IMG_DATA));

  m_startBtnBMP.loadFromData(STARTLOGO_IMG_DATA, sizeof (STARTLOGO_IMG_DATA));

  // Boot Logo
  m_BootLogBMP.loadFromData(BOOTLOGO_IMG_DATA, sizeof (BOOTLOGO_IMG_DATA));

}
//
// Draw BackGround
//
void CDisplay::setBackGround( QPainter *paint, int width, int height )
{
  
  QColor water(160, 192, 255);

  paint->fillRect(0, 0, width, height, water);

}
//
// Draw Title Image
//
void CDisplay::setTitle( QPainter *paint )
{
  QColor black(0,0,0);
  paint->drawPixmap( LOGO_MOBILE_X, LOGO_MOBILE_Y, m_logoBMP );
  paint->drawPixmap( LOGO_TITLE_X,  LOGO_TITLE_Y,  m_titleBMP );
  paint->drawPixmap( LOGO_NUMBER_X, LOGO_NUMBER_Y, m_titleNumBMP );

  paint->setPen( black );
  paint->drawText( COPYRIGHT_X, COPYRIGHT_Y, COPYRIGHT );

}
//
// Draw Fish List
//
void CDisplay::drawFishList( QPainter *paint, int total, int catched )
{

  int i;
  int x;

  for(i = 0, x = FISH_LIST_X; i < total; i++ ,x+=FISH_LIST_SPACE){

    if( catched ){
      /* draw fihs */
     catched --;
      paint->drawPixmap(x, FISH_LIST_Y, m_fishListBMP[0]);
    } else {
      /* draw empty fish */
      paint->drawPixmap(x, FISH_LIST_Y, m_fishListBMP[1]);
    }
  }

}
//
// Draw Clear Time
//
void CDisplay::drawClearTime( QPainter *paint, int hour, int min, int sec )
{

  QColor white( 255, 255, 255 );
  QString str = CLEAR_STR;
  QString numStr;

  numStr.setNum( hour, 10 );
  str += numStr + TIMEH_STR;
  numStr.setNum( min, 10 );
  str += numStr + TIMEM_STR;
  numStr.setNum( sec, 10 );
  str += numStr + TIMES_STR;

  paint->setPen( white );
  paint->drawText( CLEAR_TIME_POSX, CLEAR_TIME_POSY, str);
  paint->drawText( CLEAR_MSG_POSX, CLEAR_MSG_POSY, CLEARMSG_STR);

}
//
// Draw Number
//
void CDisplay::drawNumber(QPainter *paint, int num, int startx, int starty)
{
	int i;
	int numtype;
	int pos;
	int imgwidth = 15;

	for(i = 0, pos = startx; ; i++,pos -= imgwidth){

	  if((i != 0) && (num == 0)){
	    break;
	  }

	  numtype = num % 10;

	  /* select number image and draw */
	  switch(numtype){
	  case 0:
	    paint->drawPixmap(pos, starty, m_numBMP[0]);
	    break;
	  case 1:
	    paint->drawPixmap(pos, starty, m_numBMP[1]);
	    break;
	  case 2:
	    paint->drawPixmap(pos, starty, m_numBMP[2]);
	    break;
	  case 3:
	    paint->drawPixmap(pos, starty, m_numBMP[3]);
	    break;
	  case 4:
	    paint->drawPixmap(pos, starty, m_numBMP[4]);
	    break;
	  case 5:
	    paint->drawPixmap(pos, starty, m_numBMP[5]);
	    break;
	  case 6:
	    paint->drawPixmap(pos, starty, m_numBMP[6]);
	    break;
	  case 7:
	    paint->drawPixmap(pos, starty, m_numBMP[7]);    //display damage bar
	    break;
	  case 8:
	    paint->drawPixmap(pos, starty, m_numBMP[8]);
	    break;
	  case 9:
	    paint->drawPixmap(pos, starty, m_numBMP[9]);
	    break;
	  }
      num = num / 10; /* next */

      }
}
//
// Draw Score List
//
void CDisplay::DrawHiScoreList(QPainter *paint, CScoreMng *scrMng,QString &Title)
{

  QString str;
  int score;
  int scoreTime[3]; // h,m,s

  str = Title;
  // Draw Title
  m_StringDisplay.Draw( paint, &str, HISCORE_TITLEPOSX, HISCORE_TITLEPOSY );

  for( int i = 1; i <=  REGIST_MAX; i++ ){

    scrMng->GetHiScore( i, &str, &score );
    scoreTime[2] = GET_SEC(score);
    scoreTime[1] = GET_MIN(score);
    scoreTime[0] = GET_HOUR(score);

    m_StringDisplay.Draw( paint, &str, HISCORE_LISTPOSX, 
			  HISCORE_LISTPOSY + HISCORE_LIST_HEIGHT_DISTANCE * i  );

    for( int j = 0; j < 3; j++){

      drawNumber( paint, scoreTime[j],
		  HISCORE_LISTPOSX + HISCORE_TIMEOFFSET_X + HISCORE_TIMESPACE*j, 
		  HISCORE_LISTPOSY + HISCORE_LIST_HEIGHT_DISTANCE * i + HISCORE_TIMENUM_OFFSET);

      paint->drawPixmap( HISCORE_LISTPOSX + HISCORE_TIMEOFFSET_X + HISCORE_TIMESPACE*j + 20, 
			 HISCORE_LISTPOSY + HISCORE_LIST_HEIGHT_DISTANCE * i + HISCORE_TIMELABEL_OFFSET, 
			 m_timeBMP[j] );
    }

  }

}
//
// Get NetImage Array
//
QPixmap* CDisplay::GetNetImages()
{
  return m_netBMP;
}
//
// Get FishImage Array
//
QPixmap* CDisplay::GetFishImages( int type )
{

  switch(type){

  case 0:
    return m_fishBMP0;
    break;

  case 1:
    return m_fishBMP1;
    break;

  }

  return m_fishBMP0;

}
//
// Get FishSize
//
int CDisplay::GetFishWidth( int type )
{
  int size = 0;

  switch(type){

  case 0:
    size = m_fishBMP0[2].width();
    break;

  case 1:
    size = m_fishBMP1[2].width();
    break;

  }

  return size;
}
int CDisplay::GetFishHeight( int type )
{

  int size = 0;

  switch(type){

  case 0:
    size = m_fishBMP0[0].height();
    break;

  case 1:
    size = m_fishBMP1[0].height();
    break;

  }

  return size;
}
QPixmap* CDisplay::GetStartBtnImages()
{
  return &m_startBtnBMP;
}
//
// Draw Boot Logo
//
void CDisplay::DrawBootLogo( QPainter *paint, int width, int height )
{

 QColor white( 255, 255, 255 );
 QColor black(0,0,0);

 paint->fillRect( 0, 0, width, height, white );
 paint->drawPixmap( BOOT_LOGO_X, BOOT_LOGO_Y, m_BootLogBMP );

 paint->setPen( black );
 paint->drawText( BOOT_LOGOSTRING_X, BOOT_LOGOSTRING_Y, BOOT_LOGOSTRING ); 
}
