<?php
/*
  iSlideManager.php

  iSlideMaker
    http://sourceforge.jp/projects/islidemaker/simple/

  Copyright(c) 2010, Isao Hara, isao-hara@users.sourceforge.jp

  All rights reserved. This program is made available under the terms of the
  Eclipse Public License v1.0 which accompanies this distribution, and is
  available at http://www.eclipse.org/legal/epl-v10.html

  Contributors:  Isao Hara.

*/
$name = $_POST['name'];
$cmd = $_POST['cmd'];
$filetype = $_POST['filetype'];
$content = $_POST['datalob'];

$path = dirname($_SERVER['DOCUMENT_ROOT'].$_SERVER['PHP_SELF']);

if(!$name){
  echo "Filename required";
  exit;
}
if($filetype == "svg"){
  $dirname = $path."/SVG/";
  $fname = $name.".svg";
}else{
  $dirname = $path."/Slide/";
  $fname = $name.".txt";
}

if( $cmd=='get'){
  $res = file_get_contents($dirname.$fname);
  echo $res;
}else if($cmd=='list'){
  $res = getFileList($dirname);
  echo implode(',',$res);
}else if($cmd=='upload'){
  $res = save_content($dirname.$fname, $content);
  if($res){
   echo "Finish to upload.";
  }else{
   echo "Fail to upload.";
  }
}else if($cmd=='download'){
  download_file($dirname.$fname, $fname, $filetype);
  exit();
}else {
  echo "No such command: $cmd.<br>";
  echo "name: $name.<br>";
  echo "filetype: $filetype.<br>";
print_r($_POST);
}

function save_content($filename, $content){
  $res = false;
  $fp = fopen($filename, "w+");
  if(! $fp){ return $res; }
  if(flock($fp, LOCK_EX)){
     $res = fwrite($fp, $content);
     flock($fp,LOCK_UN);
  }
  fclose($fp);
  return $res;
}

function getFileList($dir){
  $handle = opendir($dir);

  $filenames=array();
  while(false !== ($file = readdir($handle))){
    if( $file != "." && $file != ".." && !is_dir($dir."/".$file)){
      array_push($filenames, $file);
   }
  }
  closedir($handle);
  return $filenames;
}

///////////////////////////////////////
//  download file
function download_file($file, $fname, $ftype){
  if(!file_exists($file)) return 0;
  if(!($fp = fopen($file,"r"))) return 0;
  fclose($fp);

  if(($content_len = filesize($file)) == 0) return 0;


  header("Pragma: private");
  header("Cache-control: private, must-revalidate");

  $k_code="UTF-8";

  if(chkBrowser() == "windows"){
   $k_code="SJIS";
  }else{
   $k_code="UTF-8";
  }

  if(chkBrowser() == "safari"){
    header("Content-Disposition: attachment; filename=\"\"");
  }else if(chkBrowser() == "osx"){
    header("Content-Disposition: attachment; filename=\"".mb_convert_encoding($fname,$k_code,"UTF-8,EUC-JP,SJIS")."\"");
  }else{
    header("Content-Disposition: attachment; filename=\"".mb_convert_encoding($fname,$k_code,"SJIS,UTF-8,EUC-JP")."\"");
  }
  header("Content-Type: applicaion/octet-stream");

  if($ftype == "svg"){
    $content = file_get_contents($file);

    $contents =<<<_XML
<?xml version="1.0" ?>
<svg:svg width="100%" height="100%" 
     xmlns:svg="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">
$content
</svg:svg>
_XML;

    $content_len = strlen($contents);
    header("Content-Length: ".$content_len);

    print $contents;

  }else if($ftype = "slide_html"){

    header("Content-Length: ".$content_len);
    if(! readfile($file)) return 0;
  }else{
    header("Content-Length: ".$content_len);
    if(! readfile($file)) return 0;
  }

  return 1;
}

function chkBrowser(){
  if (preg_match("/^DoCoMo/",$_SERVER['HTTP_USER_AGENT'])){
    return "imode";
  }else if(preg_match("/NetFront/",$_SERVER['HTTP_USER_AGENT'])){
    return "netfront";
  }else if(preg_match("/Windows/",$_SERVER['HTTP_USER_AGENT'])){
    return "windows";
  }else if(preg_match("/Mac OS X/",$_SERVER['HTTP_USER_AGENT'])){
    return "osx";
  }else if(preg_match("/Safari/",$_SERVER['HTTP_USER_AGENT'])){
    return "safari";
  }else return "unix";
}


?>
