/*
  iSlideEditor.js

  iSlideMaker
    http://sourceforge.jp/projects/islidemaker/simple/

  Copyright(c) 2010, Isao Hara, isao-hara@users.sourceforge.jp

  All rights reserved. This program is made available under the terms of the
  Eclipse Public License v1.0 which accompanies this distribution, and is
  available at http://www.eclipse.org/legal/epl-v10.html

  Contributors:  Isao Hara.

 */

var systemDB;
var currentMode;
var currentPage=0;
var editarea_h=10;
var editarea_w=70;
var iSlide_content;
var MainTitle="iSlide Maker";

var iSlideMgr='iSlideManager.php';
var MgrPath="";

//
function initEditor(name, dispname, size){
  initDB(name, dispname, size);
  fileSelector();
  restoreValues();
}

function restoreValues(){
  if(typeof(localStorage) == 'undefined'){
    alert('local storage not suported');
  }
  MgrPath = localStorage.getItem('MgrPath') ? localStorage.getItem('MgrPath')  : "";
  window.onbeforeuload=function(){ return saveChanges(); } 
}

function clearAll(){
  localsStorage.clear();
  restoreValudes();
}

function saveChanges(){
  localStorage.setItem('MgrPath', MgrPath);
}

// initialize a database
function initDB(name, dispname, size){
  try {
    if (!window.openDatabase) {
        alert('not supported');
    } else {
        var version = '1.0';
        var myDB = openDatabase(name, version, dispname, size);
    }
  } catch(e) {
    if (e == INVALID_STATE_ERR) { // Version number mismatch.
      alert("Invalid database version.");
    } else {
      alert("Unknown error "+e+".");
    }
    return;
  }

  createTables(myDB);
  systemDB = myDB;
  return myDB;
}

function createTables(db){
  if (0) dropTables(db);

  db.transaction(
    function (transaction) {
        transaction.executeSql('CREATE TABLE IF NOT EXISTS files(id INTEGER NOT NULL PRIMARY KEY AUTOINCREMENT, name TEXT NOT NULL, filedata_id INTEGER NOT NULL, deleted INTEGER NOT NULL DEFAULT 0);', [], nullDataHandler, killTransaction);
        transaction.executeSql('CREATE TABLE IF NOT EXISTS filedata(id INTEGER NOT NULL PRIMARY KEY AUTOINCREMENT, datablob BLOB NOT NULL DEFAULT "");', [], nullDataHandler, errorHandler);
    }
  );
}

function dropTables(db){
   db.transaction(
     function (transaction) {
        transaction.executeSql('DROP TABLE files;');
        transaction.executeSql('DROP TABLE filedata;');
     }
   );
}

//// Delete File
function deleteUpdateResults(transaction, results){
  if (results.rowsAffected) { fileSelector(); }
}

function reallyDelete(id){
  var myDB = systemDB;

  myDB.transaction(
    new Function("transaction",
      "transaction.executeSql('UPDATE files set deleted=1 where id=?;', [ "+id+" ], null, errorHandler);"
      +"transaction.executeSql('DELETE FROM filedata where id=?;', [ "+id+" ], deleteUpdateResults, errorHandler);")
  );
}

function deleteFile(name){
  var myDB = systemDB;

  myDB.transaction(
    new Function("transaction", "transaction.executeSql('SELECT id,name from files where name=?;',['"+name+"'],"+
        "function (transaction, results) {"+
           "if (confirm('Really delete '+results.rows.item(0)['name']+'?')) {"+
               "reallyDelete(results.rows.item(0)['id']);"+
           "}"+
        "}, errorHandler);")
  );
}

function reallyDeleteAll(db){
  var myDB = db;
  if(!db) myDB = systemDB;

  myDB.transaction(
    new Function("transaction",
      "transaction.executeSql('DELETE FROM  files;',[],null, errorHandler);"
      +"transaction.executeSql('DELETE FROM filedata;',[],deleteUpdateResults, errorHandler);")
  );
}

function deleteAllFile(db){
  if (confirm('Really delete all file?')) { reallyDeleteAll(db); }
}

///// Rename
function reallyRenameFileAction(id, newname){
  var myDB = systemDB;

  myDB.transaction(
    function (transaction) {
      transaction.executeSql('UPDATE files set name=? where id=?;', [newname,id ], null, errorHandler);
    }
  );
  fileSelector();
}

function renameFileAction(){
  var myDB = systemDB;
  var new_name = document.getElementById('newFilename').value
  var id = document.getElementById('fileId').value

  if(new_name == "") {
    alert('Filename is required.');
    fileSelector();
    return;
  }

  myDB.transaction(
    new Function("transaction", "transaction.executeSql('SELECT id,name from files where name=?;',['"+new_name+"'],"+
        "function (transaction, results) {"+
           "if(results.rows.length == 0){"+
               "reallyRenameFileAction('"+id+"','"+new_name+"');"+
           "}else{"+
             "alert(results.rows.item(0)['name']+' already exist');"+
             "fileSelector();"+
           "}"+
        "}, errorHandler);")
  );
}

function renameFile(name, id){
  var myDB = systemDB;
  var menuDiv = document.getElementById('menuDiv');
  var string = "";

  string += "<H1 class='title'>Rename File</H1>\n";
  string += "<form action='javascript:renameFileAction()'>\n";

  string += "New Filename:<input id='newFilename' name='newname' value=\"\" />\n";
  string += "<input type='hidden' id='fileId' value=\""+id+"\" />\n";
  string += "<input type='submit' value='Rename' />\n";
  string += "</form>\n";
 
  menuDiv.innerHTML=string;
}

function docLink(row){
  var name = row['name'];
  var files_id = row['id'];

  var res =  "<tr class='filerow'>";
  res += "<td class='filenamecell'  onClick=\"showFile('"+name+"');\">"+name+"</td>";
  res += "<td class='filelinkcell'>";
  res += "<button class='blue' onClick=\"editFile('"+name+"');\">&nbsp;Edit&nbsp;</button> &nbsp;";
  res += "<button class='green' onClick=\"renameFile('"+name+"',"+files_id+");\">&nbsp;Rename&nbsp;</button> &nbsp;";
  res += "<button class='#ffdddd' onClick=\"uploadFile('"+name+"');\">&nbsp;Upload&nbsp;</button> &nbsp;";
  res += "<button class='red' onClick=\"deleteFile('"+name+"');\">Delete</button>";
  res += "</td></tr>\n";

  return res;
}

function fileSelector(){
  var myDB = systemDB;
 
  myDB.transaction(
    function (transaction){
      transaction.executeSql("SELECT * from files where deleted=0;", [ ], 
         function (transaction, results){
           var filelist = '';
           var menuDiv = document.getElementById('menuDiv');
           for(var i=0; i<results.rows.length; i++) {
             var row = results.rows.item(i);
             filelist = filelist + docLink(row);
           }
           if (filelist == "") {
             filelist = "No files.<br />\n";
           } else {
             filelist = "<center><table class='filetable'>"+filelist+"</table></center>";
           }
           menuDiv.innerHTML="<H1 class='title'>"+MainTitle+"</H1>"+createMenuBar()+filelist;
         }, errorHandler);
    }
  );
  setMode('List');
}

function fileSelectorOnServer(val){
  var filelist = '';
  var menuDiv = document.getElementById('menuDiv');
  var results = val.split(',');
  
  if(menuDiv){
    for(var i=0; i<results.length; i++) {
      var row = results[i];
      filelist = filelist + fileEntryOnServer(row);
    }
    if (filelist == "") {
     filelist = "<br />No files.<br />\n";
    } else {
     filelist = "<center><table class='filetable'>"+filelist+"</table></center>";
    }
    var Menu = "<button onClick=\"fileSelector();\">Local Storage</button>";
    Menu += "<button onClick=\"getRemoteFileList();\">List on Server</button>";
    menuDiv.innerHTML="<H1 class='title'>"+MainTitle+"</H1>"+Menu+filelist;
  }
  setMode('List');
}

function fileEntryOnServer(name){
  name = name.split('.')[0];
  if(!trim(name)) return "";

  var res =  "<tr class='filerow'>";
  res += "<td class='filenamecell'  onClick=\"getRemoteFile('"+name+"');\">"+name+"</td>";
  res += "<td class='filelinkcell'>";
  res += "<button class='green' onClick=\"showRemoteFile('"+name+"');\">View</button>";
  res += "<button onClick=\"downloaFile('"+name+"');\">Download to local storage</button>";
  res += "<button onClick=\"downloadToFile('"+name+"');\">Download as SVG File</button>";
  res += "</td></tr>\n";

  return res;
}

function createMenuBar(){
  var menu = "<ul id='menubar'>";
  menu += "<li><button onClick='createNewFile()'>Create New File</button></li>";
  menu += "<li><button onClick='deleteAllFile()'>Delete All</button></li>";
  menu += "<li><button onClick='getRemoteFileList()'>File List on a Server</button></li>";
  menu += "<li><button onClick='configServer()'>Server Configuration</button></li>";
  menu += "</ul><p class='cls'>";
  return menu;
}

//// Config
function setConfig(){
  var ele = document.getElementById('ServerURL');
  MgrPath=ele.value;
  saveChanges();
  alert("Done");
}

function configServer(){
  var popupDiv = document.getElementById('popup');
  var string = "";

  string += "<H1 class='title'>Server Configration</H1>\n";
  string += "<div class=\"input_form\">\n";
  string += "Filename:<input id='ServerURL' name='url' value=\""+MgrPath+"\" size=\"80\"/><br>\n";
  string += "<button onClick=\"setConfig();hideItemById('popup'); \">Done</button>\n";
  string += "<button onClick=\"hideItemById('popup'); \">Cancel</button>\n";
  string += "</div>\n";
 
  popupDiv.innerHTML=string;
  popupDiv.style.display='block';
}

function linkToCreateNewFile(){
  return "<p><button onClick='createNewFile()'>Create New File</button>";
}

/// new File
function reallyCreateNewFileAction(name){
  var myDB = systemDB;

  myDB.transaction(
    function (transaction) {
      var myfunc = new Function("transaction", "results", "transaction.executeSql('INSERT INTO files (name, filedata_id) VALUES (?, ?);', [ '"+name+"', results.insertId], nullDataHandler, killTransaction);");

       transaction.executeSql('INSERT INTO filedata (datablob) VALUES ("");', [], myfunc, errorHandler);
    }
  );

  fileSelector();
}

function createNewFileAction(){
  var myDB = systemDB;
  var name = document.getElementById('createFilename').value
  if(name == "") {
    if (confirm('Filename is required, try agein?')) { createNewFile(); }else{ fileSelector(); }
    return;
  }

  myDB.transaction(
    new Function("transaction", "transaction.executeSql('SELECT id,name from files where name=?;',['"+name+"'],"+
        "function (transaction, results) {"+
           "if(results.rows.length == 0){"+
               "reallyCreateNewFileAction('"+name+"');"+
           "}else{"+
             "if (confirm(results.rows.item(0)['name']+' already exist, try agein?')) {"+
               "createNewFile();"+
             "}else{"+
               "fileSelector();"+
             "}"+
           "}"+
        "}, errorHandler);")
  );

}

function createNewFile(){
  var myDB = systemDB;
  var menuDiv = document.getElementById('menuDiv');
  var string = "";

  string += "<H1 class='title'>Create New File</H1>\n";
  string += "<form action='javascript:createNewFileAction()'>\n";
  string += "Filename:<input id='createFilename' name='name' value=\"\" />\n";
  string += "<input type='submit' value='create' />\n";
  string += "</form>\n";
 
  menuDiv.innerHTML=string;
}

/// EditMenu
function insertStr(str, len){
  var editarea = document.getElementById('editarea');
  if(len < 0) len = str.length;

  if (editarea){
    if(str=='DQ') str='"';
    var strs = editarea.value;
    var cPos = editarea.selectionStart;
    var tmp = strs.substr(0,cPos);
    editarea.value = tmp +str+strs.substr(cPos, strs.length);
    cPos += len;
    editarea.setSelectionRange(cPos, cPos);
    editarea.focus();
  }
}

function insertTag(tag){
  var str;
  var len = -1;
  if (tag == "p"){
    str = "<p>  </p>";
    len = 4;
  }else if (tag == "ul"){
    str = "<ul class=\"  \"> \n\n</ul>";
    len = 17;
  }else if (tag == "li"){
    str = "<li>   </li>";
    len = 5;
  }else if (tag == "href"){
    str = "xlink:href=\"\"";
    len = 12;
  }else if (tag == "EQ"){
    str = "=\"\"";
    len = 2;
  }else if (tag == "SVG_obj"){
    str = "<object width=\"80%\" height=\"50%\" data=\"image.svg?name=\" type=\"image/svg+xml\">";
    len = 57;
  }
  insertStr(str, len);
}

function editMenuBar() {
  var str = "";
  str += "<button onClick=\"insertNewSlide();\">New Slide</button>\n";
  str += "<button onClick=\"insertStr('/',1);\">/</button>\n";
  str += "<button onClick=\"insertStr('DQ',1);\">\"</button>\n";
  str += "<button onClick=\"insertTag('EQ',1);\">=\"\"</button>\n";
  str += "<button onClick=\"insertTag('p');\">p</button>\n";
  str += "<button onClick=\"insertTag('href');\">href</button>\n";
  str += "<button onClick=\"insertTag('SVG_obj');\">SVG</button>\n";

  str += "<button onClick=\"chEditareaHeight();\">...</button>\n";
  return str;
}

function updateEditMenuSimple(){
  var menuDiv = document.getElementById('menuDiv');
  menuDiv.innerHTML="<h1 class='title'>" +document.title+"</h1>\n";
  menuDiv.innerHTML+= "<button onClick=\"saveFile();fileSelector();\"> Save </button>\n";
  menuDiv.innerHTML+= "<button onClick=\"fileSelector();\"> File List </button>\n";
  menuDiv.style.display='block';
}
  
/// Save File
function getContentSimple(){
  var editarea = document.getElementById('editarea');
  if(!editarea) return "";
  return editarea.value;
}

function getSlideContent(){
  var editarea = document.getElementById('editarea');
  var contents = "";

  if(editarea) iSlide_content[currentPage] = editarea.value;

  for(var i=0; i<iSlide_content.length ;i++ ){
    contents += iSlide_content[i] +"\n";
  }
  return contents;
}

function saveFile(){
  var myDB = systemDB;

  var contents =  getSlideContent();

  myDB.transaction(
    function (transaction) {
      var datadiv = document.getElementById('tempdata');
      var filedata_id = datadiv.getAttribute('lfdataid');

      transaction.executeSql("UPDATE filedata set datablob=? where id=?;",
        [ contents, filedata_id ], nullDataHandler, errorHandler);

      alert('Saved.');
    }
  );
}

//// Editor
function getEditSlideContent(data){
  var filter =  new iSlideFormatter();
  iSlide_content = filter.parse(data);
  return iSlide_content[currentPage];
}

function editFileData(transaction, results){
  var editDiv = document.getElementById('editDiv');
  var datadiv = document.getElementById('tempdata');
 
  var data = results.rows.item(0);
  var filename = data['name'];
  var filedata = data['datablob'];
  datadiv.setAttribute('lfdataid', parseInt(data['filedata_id']));

  var data = getEditSlideContent(filedata);

  var editcontent="<textarea id=\"editarea\" rows=\""+editarea_h+"\" cols=\""+editarea_w+"\">"+data+"</textarea>\n";
 
  document.title="EditFile: "+filename;
  updateEditMenu();
  editDiv.innerHTML = editMenuBar() +"<br>"+ editcontent;

  setMode('Edit');
}

function editFile(name){
  getFile(name, 'editFileData');
}

function editCurrentFile(){
  var datadiv = document.getElementById('tempdata');
  var name = datadiv.getAttribute('lfname');
  editFile(name);
}

//  Show File
function updateShowMenu(){
  var menuDiv = document.getElementById('menuDiv');
  menuDiv.innerHTML="<h1 class='title'>" +document.title+"</h1>\n";
  menuDiv.innerHTML+= "<button onClick=\"editCurrentFile();\"> Edit </button>\n";
  menuDiv.innerHTML+= "<button onClick=\"fileSelector();\"> File List </button>\n";
  menuDiv.style.display='block';
}

function showFileData(transaction, results){
  var data = results.rows.item(0);
  var filename = data['name'];
  var filedata = data['datablob'];

  var datadiv = document.getElementById('tempdata');
  datadiv.setAttribute('lfdataid', parseInt(data['filedata_id']));
  datadiv.setAttribute('lfname', filename);
 
  document.title=filename;

  currentPage = 0;
  getEditSlideContent(filedata)

  startPresentation();

  updateShowMenu();
  setMode('Presentation');
}

function showFile(name){
  getFile(name, 'showFileData');
}

function getFile(name, func){
  var myDB = systemDB;
  myDB.transaction(
    function (transaction) {
      transaction.executeSql('SELECT * from files, filedata where files.name=? and files.filedata_id = filedata.id;', [name], eval(func), errorHandler);
    }
  );
}
 
//  Error Handlers 
function killTransaction(transaction, error){ return true; }
 
function errorHandler(transaction, error){
  alert('Oops.  Error was '+error.message+' (Code '+error.code+')');
 
  var we_think_this_error_is_fatal = true;
  if (we_think_this_error_is_fatal) return true;
  return false;
}
 
function nullDataHandler(transaction, results){ }
 
function setMode(m){
  currentMode=m;
  switch(m){
    case 'List':
      hideItemById('editDiv');
      hideItemById('preview');
      showItemById('menuDiv');
      break;
    case 'Edit':
      hideItemById('preview');
      showItemById('editDiv');
      showItemById('menuDiv');
      break;
    case 'Preview':
      showItemById('preview');
      hideItemById('editDiv');
      showItemById('menuDiv');
      break;
    case 'Presentation':
      hideItemById('preview');
      hideItemById('editDiv');
      hideItemById('menuDiv');
      break;
    default:
      break;
  }
}

function hideItemById(id){
  var itm = document.getElementById(id);
  if(itm) itm.style.display='none';
}

function showItemById(id){
  var itm = document.getElementById(id);
  if(itm) itm.style.display='block';
}

function removeChildNodes(id){
  var itm = document.getElementById(id);
  if(!itm) return;

  var child = itm.firstChild;

  while(child){
    itm.removeChild(child);
    child = itm.firstChild;
  }
}

function chEditareaHeight(){
  var itm = document.getElementById('editarea');
  if(!itm) return;
  var cv = itm.getAttribute('rows');
  if(parseInt(cv) > editarea_h){
    itm.setAttribute('rows', editarea_h);
  }else{
    itm.setAttribute('rows', editarea_h * 2);
  }
}

function format_file(str){
  return "<pre>"+str+"</pre>";
}

function previewFile(id, data){
  var preview = document.getElementById(id);
  removeChildNodes(id);

  preview.style.display='block';
  preview.style.position='absolute';
  preview.style.top='180px';
  preview.style.width='80%';
  preview.style.height='80%';

  var ele = toSVGElement(data, '100%','100%');

  preview.appendChild(ele);
}

function toSVGElement(str, w, h){
  var xmlsvg = "xmlns:svg=\"http://www.w3.org/2000/svg\""
  var parser = new DOMParser();
  var header = "<svg:svg width=\""+w+"\" height=\""+h+"\" "+xmlsvg+">"
  var footer = "</svg:svg>";
  var xmlDoc = parser.parseFromString(header+str+footer, "text/xml");
  var xmlRoot = xmlDoc.documentElement;
  var ele =  document.importNode(xmlRoot,true);
  return ele;
}

///----------------- 
function insertNewSlide(){
  var len = iSlide_content.length;
  var editarea=document.getElementById('editarea');

  for(var i=len; i > currentPage+1;i--){
   iSlide_content[i]=iSlide_content[i-1];
  }
  currentPage += 1;
  iSlide_content[currentPage]="#slide\n\n----\n";
  if(editarea) editarea.value = iSlide_content[currentPage];

}

function prevPage(){
  var editarea=document.getElementById('editarea');
  if(editarea) iSlide_content[currentPage]=editarea.value;

  if(editarea && currentPage > 0){
    currentPage -= 1;
    editarea.value=iSlide_content[currentPage];
    updateEditMenu();
  }
}

function nextPage(){
  var editarea=document.getElementById('editarea');
  if(editarea) iSlide_content[currentPage]=editarea.value;

  if(editarea && iSlide_content.length-1 > currentPage){
    currentPage += 1;
    editarea.value=iSlide_content[currentPage];
    updateEditMenu();
  }
}

function previewSlide(){
  hideItemById('menuDiv');
  hideItemById('preview');
  hideItemById('editDiv');

  var editarea=document.getElementById('editarea');
  if(editarea) iSlide_content[currentPage]=editarea.value;

  var ele  = document.getElementById('presentation');

  var formatter =  new iSlideFormatter();
  ele.innerHTML = formatter.format(iSlide_content[currentPage]);

  iSlide_init();
  modeEditFile();

  ele.style.display = 'block';
  ele.style.top = 200;
}

function escapeHTML(text) {
    return text.replace( /[<>"&]/g,
        function (m) { return { '<': '&lt;', '>': '&gt;', '"': '&quot;', '&': '&amp;' }[m]; });
};

function previewCompileCode(){
  var formatter =  new iSlideFormatter();
  var preview =  document.getElementById("preview");
  var editarea=document.getElementById('editarea');
  if(editarea) iSlide_content[currentPage]=editarea.value;

  preview.innerHTML = "<pre>"+escapeHTML(formatter.format(iSlide_content[currentPage])) + "</pre>";
  preview.style.display = "block";
}

function updateEditMenu(){
  var menuDiv = document.getElementById('menuDiv');
  menuDiv.innerHTML="<h1 class='title'>" +document.title+"</h1>\n";
  menuDiv.innerHTML+= "<button onClick=\"saveFile();fileSelector();\"> Save </button>\n";
  menuDiv.innerHTML+= "<button onClick=\"fileSelector();\"> File List </button>\n";
  menuDiv.innerHTML+= "<button onClick=\"previewSlide();\"> Preview </button>\n";
  menuDiv.innerHTML+= "<button onClick=\"previewCompileCode();\"> toHTML </button>\n";
  menuDiv.innerHTML+= "<button onClick=\"prevPage();\"> < </button>\n";
  menuDiv.innerHTML+= currentPage+1;
  menuDiv.innerHTML+= "<button onClick=\"nextPage();\"> > </button>\n";
  menuDiv.innerHTML+= "<button onClick=\"startPresentation();\"> Presentation </button>\n";
  menuDiv.style.display='block';
}
  
function editSlideByIndex(idx){
  currentPage = idx;
  var datadiv = document.getElementById('tempdata');
  name = datadiv.getAttribute('lfname');
  editFile(name);
}

//  Show File
function startPresentation(){
  hideItemById('menuDiv');
  hideItemById('editDiv');

  var presentation = document.getElementById('presentation');
  var formatter =  new iSlideFormatter();

  var contents = "";
  for(var i=0; i<iSlide_content.length ;i++ ){
    contents += iSlide_content[i] +"\n";
  }

  presentation.innerHTML="";
  presentation.innerHTML+=formatter.format(contents);
  presentation.style.display='block';

  setMode('Presentation');
  iSlide_init();
  setSlideIndex(currentPage);
}

 
///// Formatter
//
var iSlideFormatter = function(){
  this.slideNo = 0;
  this.slideContent = null;
  this.mode=null;
  this.filters = new Array();
  this.initFilter();
}

iSlideFormatter.prototype.format = function(content){
  var lines = content.split('\n');
  var cont = "";
  var str="";

  this.mode='start';

  for(var l=0; l<lines.length ;l++){
    var line = lines[l];
    var prev_mode = this.mode;

    if(line == "") {
      this.mode=null;
    }else{
      for(var i=0; i<this.filters.length ;i++){
        var pat = this.filters[i][0];
        if(line.match(new RegExp(pat,"i"))){
          var func = this.filters[i][1];
          line = func.call(this, line, RegExp.lastMatch);
          break;
        }
      }
    }
    if( prev_mode == this.mode){
      if(line != ""){
        str += line + '\n';
      }
    }else{
      if( this.mode == 'title'){
        str += line +'\n';
        cont += str;
        str = "";
      }else{
        if(prev_mode == 'title'){
           if(trim(str)) str = "<h1>"+str+"</h1>\n";
        }else{
        }
        if(str != "")
          cont += str;
        str = line;
        if(line != "") str += '\n';
        this.mode='content';
      }
    }
  }

  cont += str;
  if(this.slideNo > 0) {
    if(this.slideContent != null) cont += "</div>\n";
    cont += "</div>\n";
  }
  return cont;
}

iSlideFormatter.prototype.parse = function(content){
  var lines = content.split('\n');
  var cont = new Array();

  var str = "";
  for(var l=0; l<lines.length ;l++){
    var line = lines[l];

    if(line.match(new RegExp("^#slide","i"))){
      if(str != "") cont.push(trim(str));
      str = line + "\n";
    }else{
      str += line + "\n";
    }
  }
  if(str != "") cont.push(trim(str));

  if(cont.length < currentPage || currentPage < 0) currentPage = 0 ;

  return cont;
}

iSlideFormatter.prototype.addPatternFilter = function(pat, func){
  this.filters.push(new Array(pat,func));
}

iSlideFormatter.prototype.initFilter = function(){
  this.addPatternFilter('^#slide', this.new_slide);
  this.addPatternFilter('^----', this.new_slidecontent);
  this.addPatternFilter('^!+', this.tagH);
  this.addPatternFilter('^\\.(ULi|OLi)\\s*', this.tagULi);
  this.addPatternFilter('^\\.canvas\\s*', this.tagCanvas);
  this.addPatternFilter('^\\.svg\\s*', this.tagSVG);
  this.addPatternFilter('^\\.\\w+/\\s*', this.tagSelfClosing);
  this.addPatternFilter('^\\.\\w+\\s*', this.tagHTML);
  this.addPatternFilter('^\\,\\w+\\s*', this.tagClosingHTML);
  this.addPatternFilter('^\\./\\w+', this.tagHTML);
}

iSlideFormatter.prototype.tagH = function(l,m){
  var n=m.length;
  return  "<h"+n+">"+l.substr(n)+"</h"+n+">";
}

iSlideFormatter.prototype.tagULi = function(l,m){
  var tag=trim(m.substr(1));
  tag=tag.substr(0,tag.length-1);
  this.mode =tag;

  return  "<"+tag+" class=\"incremental\">";
}

iSlideFormatter.prototype.tagHTML = function(l,m){
  var tag=trim(m.substr(1));
  this.mode =null;
  var ele = l.substr(m.length);
  var val = ele.split('//');
  if(val.length == 2) {
    return  "<"+tag+" "+val[0]+">"+val[1];
  }else{
    return  "<"+tag+">"+ele;
  }
}

iSlideFormatter.prototype.tagClosingHTML = function(l,m){
  var tag=trim(m.substr(1));
  this.mode =null;

  var ele = l.substr(m.length);
  var val = ele.split('//');
  if(val.length == 2) {
    return  "<"+tag+" "+val[0]+">"+val[1]+"</"+tag+">";
  }else{
    return  "<"+tag+">"+ele+ "</"+tag+">";
  }
}

iSlideFormatter.prototype.tagCanvas = function(l,m){
  var n=m.length;
  var ele = trim(l.substr(n));
  this.mode ='canvas';
  var wh = ele.split(',');
  if(wh.length == 2){
    return  "<canvas width=\""+wh[0]+"\" height=\""+wh[1]+"\">";
  }else if(wh.length == 4){
    return  "<canvas class=\"abs\" style=\"top:"+wh[0]+";left:"+wh[1]+";\" width=\""+wh[2]+"\" height=\""+wh[3]+"\">";
  }else{
    return  "<canvas "+ele+" >";
  }
}

iSlideFormatter.prototype.tagSVG = function(l,m){
  var n=m.length;
  var ele = trim(l.substr(n));

  this.mode ='svg_image';
  var args = ele.split(' ');

  var fname = args[0];
  var size = '800,600';

  if(args.length > 1){ size = args[1]; }
  var  wh = size.split(',');

  if(wh.length == 2){
    return  "<object data=\"image.svg?name="+fname+"\" width=\""+wh[0]+"\" height=\""+wh[1]+"\" type=\"image/svg+xml\" />";
  }else if(wh.length == 4){
    return  "<object data=\"image.svg?name="+fname+"\" width=\""+wh[0]+"\" height=\""+wh[1]+"\" type=\"image/svg+xml\" />";
  }else{
    return  "<object data=\"image.svg?name="+fname+"\" type=\"image/svg+xml\" />";
  }
}

iSlideFormatter.prototype.tagSelfClosing = function(l,m){
  var tag=m.substr(1, m.indexOf('/')-1);
  this.mode =tag;

  return  "<"+tag+" "+trim(l.substr(m.length))+" />";
}

iSlideFormatter.prototype.new_slide = function(l,m){
  var res = l.replace("#slide", "<div class=\"slide");
  res += "\">";

  if(this.slideNo > 0){
    if(this.slideContent != null) res = "</div>\n"+res;
    res = "</div>\n"+res;
  }

  this.slideNo += 1;
  this.slideContent = null;
  this.mode = 'title';
  return res;
}

iSlideFormatter.prototype.new_slidecontent = function(l,m){
  this.slideContent = "";
  this.mode='content';
  return "<div class=\"slidecontent\">";
}

////////// Utils
function changeColor(item){
  item.style.background='green';
  item.style.color='white';
}

function hideItemById(id){
  var itm = document.getElementById(id);
  if(itm) itm.style.display='none';
}

function showItemById(id){
  var itm = document.getElementById(id);
  if(itm) itm.style.display='block';
}

function trim(str){
  return str.replace(/(^\s+)|(\s+$)/g, "");
}


//////// upload
function newXMLRequest(){
  if(this.XMLHttpRequest){
   return new XMLHttpRequest();
  }else {
   return new ActiveXObject("Microsoft.XMLHTTP");
 }
}

function createRequestData(data){
  var str="dummpy=0";
  for (var i in data){
    str = str +"&"+ i +"="+encodeURIComponent(data[i]);
  }
  return str;
}

function postRequest(url, data, func){

 var postData=createRequestData(data);
 var obj=newXMLRequest();

 obj.onreadystatechange = function(){
   if (obj.readyState == 4 && obj.status == 200){
     func(obj.responseText);
   }
 }

 obj.open("POST", url, true);
 obj.setRequestHeader("Content-Type","application/x-www-form-urlencoded");
 obj.send(postData);
}

function commnadFinishAlert(s){
  alert(s);
}

function uploadFileData(transaction, results){
  var data = results.rows.item(0);
  var updata = new Array(0);
  updata['name']= data['name'];
  updata['datalob'] = data['datablob'];
  updata['cmd'] = 'upload'

  postRequest(MgrPath+iSlideMgr, updata, commnadFinishAlert);
}

function uploadFile(name){
   getFile(name, 'uploadFileData');
}

function getRemoteFileList(){
  var data=new Array();
  data['name'] = "Slide";
  data['cmd'] = "list";
  postRequest(MgrPath+iSlideMgr, data, fileSelectorOnServer);
}

function previewRemoteFile(content){
  previewFile(content);
  setMode('Preview');
}
function getRemoteFile(name){

  var data=new Array();
  data['name'] = name;
  data['cmd'] = "get";
  postRequest(MgrPath+iSlideMgr, data, previewRemoteFile);
}

function downloadToFile(name){
  var downloadForm = "";
  downloadForm += "<form action=\"iSlideManager.php\" method=\"post\">";
  downloadForm += "<input type=\"hidden\" name=\"cmd\" value=\"download\">";
  downloadForm += "<input type=\"hidden\" name=\"name\" value=\""+name+"\">";
  downloadForm += "<input type=\"hidden\" name=\"filetype\" value=\"slide\">";
  downloadForm += "<input type=\"submit\">";
  downloadForm += "</form>";

  var cmdForm = document.getElementById('cmdForm');
  cmdForm.innerHTML = downloadForm;
  cmdForm.firstChild.submit();
}
