/*
  canvas.js: Canvas utilities
  
  iSlideMaker
    http://sourceforge.jp/projects/islidemaker/simple/

  Copyright(c) 2010, Isao Hara, isao-hara@users.sourceforge.jp

  All rights reserved. This program is made available under the terms of the
  Eclipse Public License v1.0 which accompanies this distribution, and is
  available at http://www.eclipse.org/legal/epl-v10.html

  Contributors:  Isao Hara.

*/
////////  SVG compatible canvas functions 
function drawString(){
  var x = document.getElementById('toString');
  var aa = document.getElementById('slide1');
  if(aa) x.innerHTML =  aa.toString(); 
}

function drawCanvas(element){
  var canvasEle = element.getElementsByTagName("canvas");
  for (var i = 0; i< canvasEle.length; i++) {
    draw(canvasEle[i]);
  }
}

function draw(canvas){
  if(!canvas.hasChildNodes()) return false;
  if(!canvas || !canvas.getContext){ return false; }
  var ctx = canvas.getContext('2d');
  var ele = canvas.childNodes; 
  drawAll(ctx, ele); 
}

function drawAll(ctx, ele){
  for(var i=0 ; i<ele.length; i++){
    var tName = ele[i].tagName;
    if(!tName) continue;

    var color = ele[i].getAttribute("stroke");
    var fill = ele[i].getAttribute("fill");
    var width = ele[i].getAttribute("stroke-width");

    switch(tName){
      case 'TEXT':
        var x = ele[i].getAttribute("x");
        var y = ele[i].getAttribute("y");
        var f_family = ele[i].getAttribute("font-family");
        var f_size = ele[i].getAttribute("font-size");
        var f_style = ele[i].getAttribute("font-style");
        var txt = ele[i].textContent;

        ctx.beginPath();
        if(!f_size) f_size = '12pt';
        if(!f_family) f_family = 'Helvetica';
        if(!f_style) f_style = '';

        ctx.fillStyle = color;
        ctx.font = f_style + " " + f_size+"pt" + " '"+f_family + "'";
        ctx.fillText( txt, x, y);
        ctx.closePath();

        break;
      case 'POLYLINE':
        var points = ele[i].getAttribute("points");
        polyline(ctx, points, color, fill, width, false);
        break;

      case 'POLYGON':
        var points = ele[i].getAttribute("points");
        polyline(ctx, points, color, fill, width, true);
        break;

      case 'LINE':
        var points = ele[i].getAttribute("x1");
        points += ',' + ele[i].getAttribute("y1");
        points += ' ' + ele[i].getAttribute("x2");
        points += ',' + ele[i].getAttribute("y2");
        polyline(ctx, points, color, 'none', width, false);
        break;

      case 'IMG':
        var iname = ele[i].getAttribute("xlink:href");
        var x = ele[i].getAttribute("x");
        var y = ele[i].getAttribute("y");
        var w = ele[i].getAttribute("width");
        var h = ele[i].getAttribute("height");
        if(!x) x=0;
        if(!y) y=0;
        if(!w) w=-1;
        if(!h) h=-1;
        svg_image(ctx, iname, x, y, w, h);
        break;

      case 'PATH':
        var d = ele[i].getAttribute("d");
        var path = d.split(' ');
        var cmd = path.shift();
        var pp;
        var p;

        ctx.beginPath();
        if(color)ctx.strokeStyle = color;
        if(width) ctx.lineWidth = width;

        while(path.length > 0){
          pp = path.shift();
          p=pp.split(',');

          if(p.length == 1){
             cmd=p[0];
             if(cmd == "Z" || cmd == "z"){
               ctx.stroke();
             }
             continue;
          }

          if(cmd == "Z" || cmd == "z"){
            ctx.stroke();
          }else if (cmd == "M"){
            ctx.moveTo(p[0], p[1]);
          }else if (cmd == "m"){
          }else if (cmd == "L"){
            ctx.lineTo(p[0], p[1]);
          }else if (cmd == "l"){

          }else if (cmd == "H"){

          }else if (cmd == "h"){

          }else if (cmd == "V"){

          }else if (cmd == "v"){

          }else if (cmd == "C"){
            var pp2 = path.shift();
            var p2=pp2.split(',');
            if(p2.length == 1){
                cmd=p2[0];
                continue;
            }

            var pp3 = path.shift();
            var p3=pp3.split(',');
            if(p3.length == 1){
                cmd=p3[0];
                continue;
            }
            ctx.bezierCurveTo(p[0], p[1], p2[0], p2[1], p3[0], p3[1]);

          }else if (cmd == "c"){
          }else if (cmd == "S"){
          }else if (cmd == "s"){
          }else if (cmd == "Q"){
            var pp2 = path.shift();
            var p2=pp2.split(',');
            if(p2.length == 1){
                cmd=p2[0];
                continue;
            }else{
             ctx.quadraticCurveTo(p[0], p[1], p2[0], p2[1]);
            }
          }else if (cmd == "q"){
          }else if (cmd == "T"){
          }else if (cmd == "t"){
          }else if (cmd == "A"){
          }else if (cmd == "a"){
          }else{
          }
        }

        ctx.stroke();
        ctx.closePath();
        break;

      case 'RECT':
        var px = ele[i].getAttribute("x");
        var py = ele[i].getAttribute("y");
        var w = ele[i].getAttribute("width");
        var h = ele[i].getAttribute("height");

        ctx.beginPath();
        ctx.setTransform(1, 0, 0, 1, 0, 0);
        if(color)ctx.strokeStyle = color;
        if(width) ctx.lineWidth = width;

        if(!fill || fill == 'none'){
          ctx.strokeRect(px, py, w, h);
        }else if( fill == 'clear'){
          ctx.clearRect(px, py, w, h);
        }else{
          ctx.fillStyle = fill;
          ctx.fillRect(px, py, w, h);
          if(color) ctx.strokeRect(px, py, w, h);
        }
        ctx.closePath();
        break;

      case 'CIRCLE':
        var cx = ele[i].getAttribute("cx");
        var cy = ele[i].getAttribute("cy");
        var r = ele[i].getAttribute("r");
        ctx.beginPath();
        ctx.setTransform(1, 0, 0, 1, 0, 0);
        circle(ctx, cx, cy, r, color, fill, width);
        ctx.closePath();
        break;

      case 'ELLIPSE':
        var cx = parseInt(ele[i].getAttribute("cx"));
        var cy = parseInt(ele[i].getAttribute("cy"));
        var rx = parseInt(ele[i].getAttribute("rx"));
        var ry = parseInt(ele[i].getAttribute("ry"));

        ctx.beginPath();
        ctx.setTransform(1, 0, 0, 1, 0, 0);
        ellipse(ctx, cx, cy, rx, ry, color, fill, width);
        ctx.closePath();
        break;

      defalut:
        break;
    }
    if(ele[i].hasChildNodes()){
      drawAll(ctx, ele[i].childNodes);
    }
  } 

}

function circle(ctx, cx, cy, r, color, fill, width){
  if(color)ctx.strokeStyle = color;
  if(width) ctx.lineWidth = width;
  if(!fill || fill == 'none'){
    ctx.arc(cx, cy, r, 0, Math.PI *2 ,true);
    ctx.stroke()
  }else{
    ctx.fillStyle = fill;
    ctx.arc(cx, cy, r, 0, Math.PI *2 ,true);
    ctx.fill()
    if(color){
       ctx.arc(cx, cy, r, 0, Math.PI *2 ,true);
       ctx.stroke()
    }
  }
}

function ellipse(ctx, cx, cy, rx, ry, color, fill, width) {
  if(color)ctx.strokeStyle = color;
  if(width) ctx.lineWidth = width;
  if(!fill || fill == 'none'){
    draw_ellipse(ctx, cx, cy, rx, ry, color, fill, width);
    ctx.stroke()
  }else{
    ctx.fillStyle = fill;
    draw_ellipse(ctx, cx, cy, rx, ry, color, fill, width);
    ctx.fill()
    if(color){
       draw_ellipse(ctx, cx, cy, rx, ry, color, fill, width);
       ctx.stroke()
    }
  }
}

function draw_ellipse(ctx, x, y, w, h) {
  var kappa = .5522848;
  ox = w  * kappa , // control point offset horizontal
  oy = h * kappa , // control point offset vertical
  xe = x + w*2,           // x-end
  ye = y + h*2,           // y-end
  xm = x + w ,       // x-middle
  ym = y + h ;       // y-middle

  ctx.moveTo(x-w, ym-h);
  ctx.bezierCurveTo(x-w, ym - oy-h, xm - ox-w, y-h, xm-w, y-h);
  ctx.bezierCurveTo(xm + ox-w, y-h, xe-w, ym - oy-h, xe-w, ym-h);
  ctx.bezierCurveTo(xe-w, ym + oy-h, xm + ox-w, ye-h, xm-w, ye-h);
  ctx.bezierCurveTo(xm - ox-w, ye-h, x-w, ym + oy-h, x-w, ym-h);
}

function polyline(ctx, pts, color, fill, width, isClose){
  var points = pts.split(' ');

  if(points.length < 2) return false;

  var tmp =  points.shift();

  var p = tmp.split(',');

  ctx.beginPath();
  ctx.setTransform(1, 0, 0, 1, 0, 0);
  ctx.strokeStyle=color;
  ctx.lineWidth=width;
  ctx.moveTo(p[0], p[1]);

  for(var i=0; i <points.length; i++){
    tmp = points[i];
    p = tmp.split(',');
    ctx.lineTo(p[0], p[1]);
  }

  if (isClose)  ctx.closePath();

  if (fill && fill != 'none'){
    ctx.fillStyle=fill;
    ctx.fill();
  }
  ctx.stroke();
}

function svg_image(ctx,iname, x, y, w, h){
  if (w == 0 || h == 0) return;

  var img = new Image();
  img.src = iname;

  img.onload = function (){
    if (w < 0 || h < 0){
      ctx.drawImage(img, x, y);
    }else{
      ctx.drawImage(img, x, y, w, h);
    }
  }
}
