############################################
# Database BOXINP Zope2.6.2 Products By Python 2.2.3
#
# Copy right 2003/12 All Rights Reserved
# This software license is the GPL.
# Copyright (c) 2003/12 yosiki.jp by kiyoharu ueno
# EMail kiyo@yosiki.jp
#
############################################
__doc__=" Database BOXINPUT Classes"
__version__="0.1.70b"

import string, os, sys, re
from Globals import Persistent, DTMLFile, InitializeClass, package_home,MessageDialog
from AccessControl.Role import RoleManager
from operator import truth
import Acquisition, sys, types, mimetools
import OFS.SimpleItem
from OFS.DTMLMethod import DTMLMethod
from OFS.Folder import Folder
import cStringIO
import StringIO
from AccessControl import ClassSecurityInfo, getSecurityManager
from DateTime import DateTime
from Products.ZSQLMethods.SQL import SQL
from ZPublisher import Client
from InpboxDBTemplates import Templates, Sqls, Scripts
from encodeconv import conv, get_string_part

manage_addInpboxDBForm=DTMLFile('dtml'+os.sep+
    'manage_addInpboxDBForm',globals())

package_path = package_home(globals())
DBCON_ID = 'conid'
DESTCON_ID ='destconid'

def createscript(ob,idst,param,body):
  """
  """
  ob.manage_addProduct['PythonScripts'].manage_addPythonScript(
      id=idst)
  ob[idst].ZPythonScript_edit(params=param,body=body)

def createsql(ob, idst, title, arguments, template):
  """
  """
  ob.manage_addProduct['ZSQLMethods'].manage_addZSQLMethod(
      id=idst,title=title,connection_id=DBCON_ID,
      arguments=arguments,template=template)


def manage_addInpboxDB( self, id, title='',selectdb='' ,
    dbhost='',dbusername='',dbpasswd='', dbname='',
    dbcharset='', REQUEST=None ):

    """ add  Database BoxInput into the system """
    ob = InpboxDB( id, title, selectdb,dbhost, dbusername,
         dbpasswd,dbname,dbcharset )
    self._setObject( id, ob )
    ob = self._getOb(id)

    if selectdb =='p':
      constr = "dbname=%s user=%s " % (dbname,dbusername)
      if dbpasswd != '':
        constr = constr + "password=%s " % dbpasswd
      if dbhost != '':
        constr = constr + "host=%s" % dbhost

      #constr = "dbname=%s user=%s password=%s host=%s" % (
      #    dbname,dbusername,dbpasswd,dbhost)
      ob.manage_addProduct['ZPsycopgDA'].manage_addZPsycopgConnection(
          DBCON_ID,'',constr)
    elif selectdb =='m':
      if dbhost != '':
        constr = "%s@%s %s %s" % (dbname,dbhost, dbusername,dbpasswd)
      else:
        constr = "%s %s %s" % (dbname, dbusername,dbpasswd)
      ob.manage_addProduct['ZMySQLDA'].manage_addZMySQLConnection(
          DBCON_ID,'',constr)
    else:
      utf8='UNICODE_FSS'
      euc='EUCJ_0208'
      sjis='SJIS_0208'
      unicodest=euc
      if dbcharset =='utf-8':
        unicodest=utf8
      elif dbcharset=='shift_jis':
        unicodest = sjis

      if dbhost != '':
        constr = "%s:%s %s %s %s" % (dbhost, dbname,
	     dbusername,dbpasswd,unicodest)
      else:
        constr = "%s %s %s %s" % (dbname, dbusername,dbpasswd,unicodest)
      ob.manage_addProduct['kInterbasdbDA'].manage_addKInterbaseConnection(
          DBCON_ID,'',constr)

    # dtmlMethod create module
    for (id, data) in Templates.items():
       ob.addDTMLMethod(id, file=conv(data,dbcharset))
    # ZSQLMethod create module
    for (id,arg) in Sqls.items():
       createsql(ob,id,'', arg[0], arg[1])
    # pythonScript create module
    for (id,arg) in Scripts.items():
       createscript(ob,id, arg[0], conv(arg[1],dbcharset))

    if REQUEST is not None:
        return self.manage_main(self, REQUEST, update_menu=1)

############################
class InpboxDB(Persistent, Folder):
    """
    """
    meta_type ="Input Box DB"

    #testForm=DTMLFile('dtml'+os.sep+'testForm',globals())
    #index_html=DTMLFile('dtml'+os.sep+'manageIndex',globals())
    _selectpgsql=DTMLFile('dtml'+os.sep+'selectpgsql',globals())
    _selectmysql=DTMLFile('dtml'+os.sep+'selectmysql',globals())
    _selectibsql=DTMLFile('dtml'+os.sep+'selectibsql',globals())
    showtblistForm=DTMLFile('dtml'+os.sep+'showtblist',globals())
    showtable=DTMLFile('dtml'+os.sep+'showtable',globals())
    showedittable=DTMLFile('dtml'+os.sep+'showedittable',globals())
    showconvForm=DTMLFile('dtml'+os.sep+'showconvForm',globals())
    dropOK=DTMLFile('dtml'+os.sep+'dropOK',globals())
    createsqlshowForm=DTMLFile('dtml'+os.sep+'createsql_show',globals())
    insertsqlshowForm=DTMLFile('dtml'+os.sep+'insertsql_show',globals())
    updatesqlshowForm=DTMLFile('dtml'+os.sep+'updatesql_show',globals())
    selectsqlshowForm=DTMLFile('dtml'+os.sep+'selectsql_show',globals())
    deletesqlshowForm=DTMLFile('dtml'+os.sep+'deletesql_show',globals())
    showSQL=DTMLFile('dtml'+os.sep+'showSQL',globals())
    manage_changeInpboxDBForm=DTMLFile('dtml'+os.sep+
    'manage_changeInpboxDBForm', globals())
    security = ClassSecurityInfo()
    manage_options= Folder.manage_options + (
      {"icon":"", "label":"Edit", "action":"manage_changeInpboxDBForm"},
    )
    _properties=(
        {'id':'title', 'type': 'string', 'mode':'w'},
	{'id':'dblimit', 'type': 'int', 'mode':'w'},
        )
    dblimit = 300000

    def _manage_createsql(self, methodid, title, arg, cmd):
        """
	"""
	setattr(self,  methodid,
	SQL(methodid, title, DBCON_ID, arg, cmd)
	)

    def _manage_createsql_main(self):
        """
	"""
	### getmydbname ###
	cmd = "SHOW DATABASES"
	arg = ""
	methodid ="_getmydbnamesSQL"
	self._manage_createsql(methodid, "", arg, cmd)

	### getpgdbname ###
	cmd = "SELECT datname FROM pg_database"
	arg = ""
	methodid ="_getpgdbnamesSQL"
	self._manage_createsql(methodid, "", arg, cmd)

	### getmytablename ###
	cmd = "SHOW TABLES"
	arg = ""
	methodid ="_getmytbnamesSQL"
	self._manage_createsql(methodid, "", arg, cmd)

	### getpgtablename ###
	cmd = """SELECT relname AS Tablenames FROM pg_class
	      where  relkind = 'r' AND relname !~'^pg_'"""
	arg = ""
	methodid ="_getpgtbnamesSQL"
	self._manage_createsql(methodid, "", arg, cmd)

	### getibtablename ###
	cmd = """SELECT RDB$RELATION_NAME AS TableName
	  FROM RDB$RELATIONS
	  where RDB$RELATION_NAME NOT LIKE 'RDB$%'
	  ORDER BY RDB$RELATION_NAME """

	arg = ""
	methodid ="_getibtbnamesSQL"
	self._manage_createsql(methodid, "", arg, cmd)

	### getindexInterbase ###
	cmd = """SELECT A.RDB$INDEX_NAME AS Name, RDB$RELATION_NAME AS Tbl, RDB$UNIQUE_FLAG AS Uni, RDB$INDEX_TYPE AS Srt, RDB$FIELD_NAME AS Fld FROM RDB$INDICES A LEFT JOIN RDB$INDEX_SEGMENTS B ON A.RDB$INDEX_NAME=B.RDB$INDEX_NAME where RDB$RELATION_NAME LIKE '<dtml-var "REQUEST.form['tbl']">%' """

	arg = ""
	methodid ="_getibindexSQL"
	self._manage_createsql(methodid, "", arg, cmd)

	### getindexPostgres ###
	cmd = """SELECT t1.relname AS name, t2.relname AS table, indisunique AS unique, indkey AS fields FROM pg_index AS i, pg_class AS t1, pg_class AS t2 where i.indexrelid=t1.oid AND i.indrelid=t2.oid AND t2.relname='<dtml-var "REQUEST.form['tbl']">' """

	arg = ""
	methodid ="_getpgindexSQL"
	self._manage_createsql(methodid, "", arg, cmd)

	### getColunsInterbase ###
	cmd = """SELECT A.RDB$FIELD_NAME AS Fld, C.RDB$TYPE_NAME AS Typ, B.RDB$FIELD_LENGTH AS Len,
      A.RDB$NULL_FLAG AS N_Nul, A.RDB$DEFAULT_SOURCE AS Def,
      B.RDB$FIELD_SCALE AS Scale
      FROM RDB$RELATION_FIELDS A LEFT JOIN RDB$FIELDS B
      ON A.RDB$FIELD_SOURCE=B.RDB$FIELD_NAME LEFT JOIN RDB$TYPES C
      ON B.RDB$FIELD_TYPE=C.RDB$TYPE where
      A.RDB$RELATION_NAME='<dtml-var "REQUEST.form['tbl']">'
      AND C.RDB$FIELD_NAME='RDB$FIELD_TYPE'
      ORDER BY RDB$FIELD_POSITION  """

	arg = ""
	methodid ="_getibColumnsSQL"
	self._manage_createsql(methodid, "", arg, cmd)

	### getColunsMysql ###
	cmd = """SHOW COLUMNS from <dtml-var "REQUEST.form['tbl']"> """

	arg = ""
	methodid ="_getmyColumnsSQL"
	self._manage_createsql(methodid, "", arg, cmd)

	### getColunsPostgresql ###
	cmd = """SELECT attname AS field,
      typname AS type, atttypmod-4 as length, NOT attnotnull AS null,
      adsrc AS def FROM pg_attribute, pg_class, pg_type, pg_attrdef where
      pg_class.oid=attrelid AND pg_type.oid=atttypid AND attnum>0
      AND pg_class.oid=adrelid AND adnum=attnum AND atthasdef='t'
      AND relname='<dtml-var "REQUEST.form['tbl']">'
      UNION SELECT attname AS field,
      typname AS type, atttypmod-4 as length, NOT attnotnull AS null,
      '' AS def FROM pg_attribute, pg_class, pg_type where
      pg_class.oid=attrelid AND pg_type.oid=atttypid AND attnum>0
      AND atthasdef='f' AND relname='<dtml-var "REQUEST.form['tbl']">'
      ORDER BY 4 """

	arg = ""
	methodid ="_getpgColumnsSQL"
	self._manage_createsql(methodid, "", arg, cmd)

	### Drop TableSQL ###
	cmd = """drop table <dtml-var "REQUEST.form['tb']">"""

	arg = ""
	methodid ="droptbSQL"
	self._manage_createsql(methodid, "", arg, cmd)

	### showTableSQL ###
	cmd = """select * from <dtml-var "REQUEST.form['tbl']">"""

	arg = ""
	methodid ="showtbSQL"
	self._manage_createsql(methodid, "", arg, cmd)

	### showTableSQL ###
	cmd = """drop table <dtml-var "REQUEST.form['tb']">"""

	arg = ""
	methodid ="droptbSQL"
	self._manage_createsql(methodid, "", arg, cmd)

	### showOneTableSQL ###
	cmd = """select * from <dtml-var "REQUEST.form['tbl']"> limit 1"""

	arg = ""
	methodid ="showOnesql"
	self._manage_createsql(methodid, "", arg, cmd)

    def __init__(self, id, title, selectdb,dbhost,
        dbusername, dbpasswd,dbname,dbcharset):
        """
	"""
	self.id = id
	self.manage_addFolder("SQL")
	self.manage_addFolder("CONV")
        self.manage_changeInpboxDB(title, selectdb,dbhost,
	dbusername, dbpasswd,dbname,dbcharset,chg=1)

    security.declareProtected( 'Change InpboxDB', 'manage_changeInpboxDB' )
    def manage_changeInpboxDB(self, title='', selectdb='',
    dbhost='', dbusername='', dbpasswd='', dbname='',
    dbcharset='', chg=None , REQUEST=None):
        """
	"""
	title = str(title)
	selectdb = str(selectdb)
	dbhost = str(dbhost)
	dbusername = str(dbusername)
	dbpasswd = str(dbpasswd)
	dbname = str(dbname)
	dbcharset = str(dbcharset)


        self.title = title
	self.selectdb = selectdb
	self.dbhost = dbhost
	self.dbusername = dbusername
	self.dbpasswd = dbpasswd
	self.dbname = dbname
	self.dbcharset = dbcharset


	if chg==None:
	   self.manage_delObjects(DBCON_ID)
           if selectdb =='p':
               self.manage_addProduct['ZPsycopgDA'].manage_addZPsycopgConnection(
	               DBCON_ID,'', self._connection_string())
           elif selectdb =='m':
	       self.manage_addProduct['ZMySQLDA'].manage_addZMySQLConnection(
	                DBCON_ID,'',self._connection_string())
           else:
	       self.manage_addProduct['kInterbasdbDA'].manage_addKInterbaseConnection(
          DBCON_ID,'',self._connection_string())

        self._manage_createsql_main()

        if REQUEST:
            message="InpboxDB %s connected." % self.id
            return self.manage_main(
	    self,REQUEST,manage_tabs_message=message)

    def getdbnamesSQL(self):
        """
        """
        if  self.selectdb =='m':
          return self._getmydbnamesSQL()
        elif self.selectdb =='p':
          return self._getpgdbnamesSQL()

    def selectdbForm(self):
         """
         """
         if self.selectdb =='i':
	   return self._selectibsql()
	 elif self.selectdb =='m':
	   return self._selectmysql()
	 elif self.selectdb =='p':
	   return self._selectpgsql()

    def gettbnamesSQL(self):
        """
        """
        if  self.selectdb =='m':
          return self._getmytbnamesSQL()
        elif self.selectdb =='p':
          return self._getpgtbnamesSQL()
        elif self.selectdb =='i':
          return self._getibtbnamesSQL()

    def getcolumnsSQL(self, tbl):
        """
        """
	self.REQUEST.form['tbl'] =tbl
        if  self.selectdb =='m':
          return self._getmyColumnsSQL()
        elif self.selectdb =='p':
          return self._getpgColumnsSQL()
        elif self.selectdb =='i':
          return self._getibColumnsSQL()

    def _getmyindexSQL(self, tbl):
          """
          """
	  self.REQUEST.form['tbl'] = tbl
	  results = self._getmyColumnsSQL()
	  names = results.names()
	  ret = []
	  for row in results:
	    for col in names:
	      if col == 'Key' and row[col]!='':
                ret.append(row['Field'])
	  return ret


    def getindexSQL(self, tbl):
          """
          """
	  self.REQUEST.form['tbl'] = tbl
	  if self.selectdb =='m':
	    return self._getmyindexSQL(tbl)
	  elif self.selectdb =='i':
	    return self._getibindexSQL(tbl)
	  elif self.selectdb =='p':
	    return self._getpgindexSQL(tbl)

    def getindexList(self, tbl):
        """
	"""
	indexlist=""

	if self.selectdb =="m":
	  indexlist = self._getmyindexSQL(tbl)
	elif self.selectdb =="p":
	  self.REQUEST.form['tbl'] = tbl
	  columns = self.showOnesql()
	  cols = columns.names()
	  results = self._getpgColumnsSQL()

	  indexs = self._getpgindexSQL()
	  idxf = ''
	  for idx in indexs:
	    if idx['unique'] == 1:
	       idxf = idxf + ' %s ' % idx['fields']
	  tmindexlist = ''
	  tmindexs=[]
	  if idxf != '':
	    tmindexlist = string.split(idxf)
	  cn = 0
	  for cname in cols:
            cn += 1
	    for row in results:
	      if tmindexlist != '':
	        if cname == row['field']:
		  for indexn in tmindexlist:
		    if int(indexn) == cn:
		      tmindexs.append(cname)
          if len(tmindexs) > 0:
	    indexlist = tmindexs
	elif self.selectdb =="i":
	  self.REQUEST.form['tbl'] = tbl
	  indexs = self._getibindexSQL()
	  indexlist = ""
	  lists = ""
	  for row in indexs:
	    lists = "%s "  % string.strip(string.lower(row['FLD']))
          if lists:
	    indexlist=string.split(lists)
	return indexlist

    def chkindex(self,tbl,fldname):
        """
	"""
	stlower = string.lower
	fldname=stlower(fldname)
	ret = None
	indexlist = self.getindexList(tbl)
	for ls in indexlist:
	  if stlower(ls) == fldname:
	    ret = 1
	    break
        return ret

    def _zopedbType(self, typ):
        """
	"""
	typ=string.lower(typ)
	tp="string"
        if string.find(typ,'blob') != -1 \
          or string.find(typ,'text') != -1 \
	  or string.find(typ,'char') != -1 \
          or string.find(typ,'varying') != -1:
          tp = 'string'
        elif string.find(typ,'int') != -1 \
          or string.find(typ,'long') != -1:
          tp = 'int'
        elif string.find(typ,'double') != -1 \
          or string.find(typ,'float') != -1:
          tp = 'float'
        elif string.find(typ,'time') != -1 \
          or string.find(typ,'date') != -1:
          tp = 'string'
	return tp


    def getcreateSQL(self, tbl="", destdb=None):
        """
        """
	if self.selectdb == 'p':
	  self.REQUEST.form['tbl'] = tbl
	  columns = self.showOnesql()
	  cols = columns.names()
	  indexs = self._getpgindexSQL()
	  idxf = ''
	  for idx in indexs:
	    if idx['unique'] == 1:
	       idxf = idxf + ' %s ' % idx['fields']
	  indexlist = ''
	  if idxf != '':
	    indexlist = string.split(idxf)
	  results = self._getpgColumnsSQL()
	  names = results.names()
	  createsqlst ='CREATE TABLE %s \n(\n' % tbl
	  prisqlst = 'PRIMARY KEY('
	  priflg = None
	  cn = 0
	  for cname in cols:
            cn += 1
	    for row in results:
	      if indexlist != '':
	        if cname == row['field']:
		  for indexn in indexlist:
		    if int(indexn) == cn:
		      priflg = 1
		      prisqlst = prisqlst + '%s,' % cname
	          for col in names:
		    if col == 'field':
		      createsqlst = createsqlst + '%s ' % row[col]
		    if col == 'null' and row[col]==0:
		      createsqlst = createsqlst[:-2] + ' NOT NULL, \n'
		    if col == 'type':
		      typest = row[col]
		      if string.find(typest,'int') != -1 \
		        or string.find(typest,'long') != -1:
		        typest = 'int'
                      elif string.find(typest,'double') != -1 \
		        or string.find(typest,'float') != -1:
		        typest = 'float'
		      #elif string.find(typest,'time') != -1 \
		      #  or string.find(typest,'date') != -1:
		      #  typest = 'string'
		      elif string.find(typest,'varchar') != -1:
		        typest = 'varchar(%s)' % (row['length'])
		      elif string.find(typest,'char') != -1:
		        typest = 'char(%s)' % (row['length'])
		      elif destdb=='i' and string.find(typest,'text') != -1:
		        typest = 'blob sub_type 0 segment size 80'
                      createsqlst = createsqlst + '%s,\n' % typest
	  if priflg:
	    prisqlst = prisqlst[:-1] + ')\n'
	    createsqlst = createsqlst + prisqlst + ')'
	  else:
	    createsqlst = createsqlst[:-2] + '\n)'
	  return createsqlst

	elif self.selectdb == 'm':
	  self.REQUEST.form['tbl'] = tbl
	  results = self._getmyColumnsSQL()
	  names = results.names()
	  createsqlst ='CREATE TABLE %s \n(\n' % tbl
	  prisqlst = 'PRIMARY KEY('
	  priflg = None
	  for row in results:

	    for col in names:
	      if col == 'Field':
	        createsqlst = createsqlst + '%s ' % row[col]
	      if col == 'Null' and row[col]=='':
	        createsqlst = createsqlst[:-2] + ' NOT NULL, \n'
	      if col == 'Type':
	        typest = row[col]
		if string.find(typest,'int') != -1 \
		  or string.find(typest,'long') != -1:
		  typest = 'int'
		elif string.find(typest,'double') != -1 \
		  or string.find(typest,'float') != -1:
		  typest = 'float'
		#elif string.find(typest,'time') != -1 \
		#  or string.find(typest,'date') != -1:
		#  typest = 'string'
		#elif (string.find(typest,'char') != -1:
		#  typest = 'char(%s)' % row['length']
		#elif string.find(typest,'varchar') != -1:
		#  typest = 'varchar(%s)' % row['length']
		#elif string.find(typest,'text') != -1:
		#  typest = 'text'
		elif destdb=='i' and string.find(typest,'text') != -1:
		    typest = 'blob sub_type 0 segment size 80'
		createsqlst = createsqlst + '%s,\n' % typest
	      if col == 'Key' and row[col]!='':
	        priflg = 1
		prisqlst = prisqlst + '%s,' %  row['Field']
	  if priflg:
	    prisqlst = prisqlst[:-1] + ')\n'
	    createsqlst = createsqlst + prisqlst + ')'
	  else:
	    createsqlst = createsqlst[:-2] +'\n)'
	  return createsqlst

	elif self.selectdb == 'i':
          tbl=string.strip(tbl)
	  self.REQUEST.form['tbl'] = string.upper(tbl)
	  results = self._getibColumnsSQL()
	  names = results.names()
	  createsqlst ='CREATE TABLE %s \n(\n' % tbl
	  prisqlst = 'PRIMARY KEY('
	  keytb = []
	  keyresult = self._getibindexSQL()
	  for ke in keyresult:
	    keytb.append(string.strip(string.lower(ke['FLD'])))

	  priflg = None
	  for row in results:
	    fld = string.lower(string.strip(row['FLD']))
	    null = row['N_NUL']
	    typ = string.lower(string.strip(row['TYP']))
	    if string.find(typ, "int") != -1 \
	      or string.find(typ, "long") != -1:
	      typ = "int"
	    elif string.find(typ, "double") != -1 \
	      or string.find(typ, "float") != -1:
	      typ = "float"
	    elif string.find(typ, "char") != -1 \
	      or string.find(typ, "varying") -1 \
	      or string.find(typ, "text") != -1:
	      typ = "varchar(%s)" % int(row['LEN'])
	    elif string.find(typ, "blob") != -1:
	      if destdb =='p' or destdb =='m':
	        typ = "text"
	      else:
	        typ = "blob sub_type 0 segment size 80"
            createsqlst = createsqlst + '%s %s,\n'  % (fld, typ)
	    if null == 1:
              createsqlst = createsqlst[:-2] + ' NOT NULL, \n'
	      for ke in keytb:
                 ke = string.lower(string.strip(ke))
		 if ke == fld:
		    priflg = 1
		    prisqlst = prisqlst + "%s," % ke
		    break

	  if priflg:
	    prisqlst = prisqlst[:-1] + ' )\n'
	    createsqlst = createsqlst + prisqlst + ')'
	  else:
	    createsqlst = createsqlst[:-2] +'\n)'
	  return createsqlst

    def _getmydbtype(self, tbl, fldname):
        """
        """
	typ = "i"
	fldname =string.strip(string.lower(fldname))
        self.REQUEST.form['tbl'] = tbl
        results = self._getmyColumnsSQL()
        for row in results:
	    fld = row['Field']
	    typ = row['Type']
	    if fld == fldname:
	      if string.find(typ,'text') != -1:
	        typ='t'
	      elif  string.find(typ,'char') != -1 \
		or string.find(typ,'varchar') != -1:
	        typ = 's'
	      elif string.find(typ,'int') != -1 \
	        or string.find(typ,'long') != -1:
	        typ = 'i'
	      elif string.find(typ,'double') != -1 \
	        or string.find(typ,'float') != -1:
	        typ = 'f'
	      elif string.find(typ,'time') != -1 \
	        or string.find(typ,'date') != -1:
	        typ = 'd'
	      break
	return typ

    def _getpgdbtype(self, tbl, fldname):
        """
	"""
	typ = "i"
	fldname =string.strip(string.lower(fldname))
        self.REQUEST.form['tbl'] = tbl
        columns = self.showOnesql()
	cols = columns.names()
	results = self._getpgColumnsSQL()
	names = results.names()
	for cname in cols:
	   for row in results:
	    fld = row['field']
	    if cname == fld and fld==fldname:
	      typ = row['type']
	      if string.find(typ,'text') != -1:
	        typ='t'
	      elif  string.find(typ,'char') != -1 \
		or string.find(typ,'varchar') != -1:
	          typ = 's'
	      elif string.find(typ,'int') != -1 \
	        or string.find(typ,'long') != -1:
	        typ = 'i'
	      elif string.find(typ,'double') != -1 \
	        or string.find(typ,'float') != -1:
	        typ = 'f'
	      elif string.find(typ,'time') != -1 \
	        or string.find(typ,'date') != -1:
	        typ = 'd'
	      break
	return typ


    def _getibdbtype(self, tbl, fldname):
        """
        """
	typ = "i"
	fldname =string.strip(string.lower(fldname))
        self.REQUEST.form['tbl'] = tbl
        results = self._getibColumnsSQL()
        for row in results:
	    fld = string.strip(string.lower(row['FLD']))
	    typ = string.strip(string.lower(row['TYP']))
	    if fld == fldname:
	      if string.find(typ,'blob') != -1:
	        typ='t'
	      elif  string.find(typ,'char') != -1 \
		or string.find(typ,'varying') != -1:
	        typ = 's'
	      elif string.find(typ,'int') != -1 \
	        or string.find(typ,'long') != -1:
	        typ = 'i'
	      elif string.find(typ,'double') != -1 \
	        or string.find(typ,'float') != -1:
	        typ = 'f'
	      elif string.find(typ,'time') != -1 \
	        or string.find(typ,'date') != -1:
	        typ = 'd'
	      break
	return typ

    def getdbtype(self, tbl, fldname):
        """
	"""
	if self.selectdb == "m":
	  return self._getmydbtype(tbl,fldname)
	elif self.selectdb == "p":
	  return self._getpgdbtype(tbl,fldname)
	elif self.selectdb == "i":
	  return self._getibdbtype(tbl,fldname)


    def getinsertSQL(self, tbl):
        """
	"""
	if self.selectdb == 'm':
	  self.REQUEST.form['tbl'] = tbl
	  results = self._getmyColumnsSQL()
	  names = results.names()
	  insertsqlst = "insert into %s values\n(\n" % tbl
	  arg = ""
	  for row in results:
	    fld = row['Field']
	    typ = self._zopedbType(row['Type'])
	    arg = arg + '%s\n' % fld
	    insertsqlst = insertsqlst + \
	      '<dtml-sqlvar %s type=%s>,\n' % (fld, typ)
	  arg = arg[:-1]
	  insertsqlst = insertsqlst[:-2] + '\n)'
	  ret = []
	  ret.append(arg)
	  ret.append(insertsqlst)
	  return ret

	elif self.selectdb == 'p':
	  self.REQUEST.form['tbl'] = tbl
	  columns = self.showOnesql()
	  cols = columns.names()
	  results = self._getpgColumnsSQL()
	  names = results.names()
	  insertsqlst = "insert into %s values\n(\n" % tbl
	  arg = ""
	  for cname in cols:
	   for row in results:
	    fld = row['field']
	    if cname == fld:
	      typ = self._zopedbType(row['type'])
	      arg = arg + '%s\n' % fld
	      insertsqlst = insertsqlst + \
	        """<dtml-sqlvar %s type=%s>,\n"""  % (fld, typ)
	  arg = arg[:-1]
	  insertsqlst = insertsqlst[:-2] + '\n)'
	  ret = []
	  ret.append(arg)
	  ret.append(insertsqlst)
	  return ret

	elif self.selectdb == 'i':
	  tbl = string.strip(tbl)
	  self.REQUEST.form['tbl'] = string.upper(tbl)
	  results = self._getibColumnsSQL()
	  names = results.names()
	  insertsqlst = "insert into %s values\n(\n" % tbl
	  arg = ""
	  for row in results:
	    fld = string.strip(string.lower(row['FLD']))
	    typ = self._zopedbType(string.strip(string.lower(row['TYP'])))
	    arg = arg + '%s\n' % fld
	    insertsqlst = insertsqlst + \
	      '<dtml-sqlvar %s type=%s>,\n' % (fld,typ)
	  arg = arg[:-1]
	  insertsqlst = insertsqlst[:-2] + '\n)'
	  ret = []
	  ret.append(arg)
	  ret.append(insertsqlst)
	  return ret

    def _keycheck(self, cn,indexlist):
        """
	"""
	ret = 0
	for lst in indexlist:
	  if cn == int(lst):
	    ret = 1
	return ret

    def getupdateSQL(self,tbl):
        """
	"""
	if self.selectdb == 'm':
	  self.REQUEST.form['tbl'] = tbl
	  results = self._getmyColumnsSQL()
	  #names = results.names()
	  updatesqlst = "update %s set\n" % tbl
	  arg = ""
	  wherest = ""
	  for row in results:
	    fld = row['Field']
            arg = arg + '%s\n' % fld
	    typ = self._zopedbType(row['Type'])
	    if row['Key'] == '':

	      updatesqlst = updatesqlst + \
	        """%s=<dtml-sqlvar %s type=%s>,\n"""  % (fld,fld,typ)
	    else:
	      if wherest == '':
	        wherest ="""where (%s=<dtml-sqlvar %s type=%s>)""" % (fld,fld,typ)
	      else:
	        wherest = wherest + \
		  """ and (%s=<dtml-sqlvar %s type=%s>)"""  % (fld,fld,typ)
	  updatesqlst = updatesqlst[:-2] + '\n'
	  ret = []
	  ret.append(arg)
	  ret.append(updatesqlst + wherest)
	  return ret

	elif self.selectdb == 'p':

	  self.REQUEST.form['tbl'] = tbl
	  columns = self.showOnesql()
	  cols = columns.names()
	  indexs = self._getpgindexSQL()
	  idxf = ""
	  for idx in indexs:
	    if idx['unique'] == 1:
	      idxf = idxf + ' %s ' % idx['fields']
	  indexlist = ""
	  if idxf != "":
	    indexlist = string.split(idxf)
	  results = self._getpgColumnsSQL()
	  names = results.names()
	  updatesqlst = "update %s set\n" % tbl
	  arg = ""
	  wherest = ""
	  cn = 0
	  for cname in cols:
	    cn += 1
	    for row in results:
	      fld = row['field']
	      if cname == fld:
	        arg = arg + '%s\n' % fld
		typ = self._zopedbType(row['type'])
		if indexlist != "":
		  if self._keycheck(cn, indexlist):
		    if wherest == '':
		      wherest = """where (%s=<dtml-sqlvar %s type=%s>)""" \
		        % (fld,fld,typ)
		    else:
		      wherest = wherest + \
		        """ and (%s=<dtml-sqlvar %s type=%s>)""" % (fld,fld,typ)
		  else:
		    updatesqlst = updatesqlst + \
		      """%s=<dtml-sqlvar %s type=%s>,\n""" % (fld,fld,typ)
		else:
		  updatesqlst = updatesqlst + \
		    """%s=<dtml-sqlvar %s type=%s>,\n""" % (fld,fld,typ)
	  updatesqlst = updatesqlst[:-2] + '\n'
	  ret = []
	  ret.append(arg)
	  ret.append(updatesqlst + wherest)
	  return ret

	elif self.selectdb == 'i':
	  tbl = string.strip(tbl)
	  self.REQUEST.form['tbl'] = string.upper(tbl)
	  results = self._getibColumnsSQL()
	  names = results.names()
	  keytb = []
	  keyresult = self._getibindexSQL()
	  for ke in keyresult:
	    keytb.append(string.strip(string.lower(ke['FLD'])))

	  updatesqlst = "update %s set\n" % string.lower(tbl)
	  arg = ""
	  wherest = ""
	  for row in results:
	    fld = string.strip(string.lower(row['FLD']))
	    arg = arg +'%s \n' % fld
	    typ = self._zopedbType(string.strip(string.lower(row['TYP'])))

	    keyflg = None
	    for ke in keytb:
	      if ke == fld and row['N_NUL']==1:
	        keyflg = 1

	    if keyflg == None:
	      updatesqlst = updatesqlst + \
	        """%s=<dtml-sqlvar %s type=%s>,\n""" % (fld,fld,typ)
	    else:
	      if wherest == '':
	        wherest = """where (%s=<dtml-sqlvar %s type=%s>)""" \
		  % (fld,fld,typ)
              else:
	        wherest = wherest + \
		  """ and (%s=<dtml-sqlvar %s type=%s>)""" % (fld,fld,typ)
	  updatesqlst = updatesqlst[:-2] + '\n'
	  ret = []
	  ret.append(arg)
	  ret.append(updatesqlst + wherest)
	  return ret

    def getdeleteSQL(self,tbl):
        """
	"""
	if self.selectdb == 'm':
	  self.REQUEST.form['tbl'] = tbl
	  results = self._getmyColumnsSQL()
	  names = results.names()
	  deletefirst = deletesqlst = "delete from %s\n" % tbl
	  arg = ""
	  wherearg=""
	  wherest = ""
	  for row in results:
	    fld = row['Field']
	    arg = arg + '%s\n' % fld
	    typ = self._zopedbType(row['Type'])
	    if row['Key'] == '':
	      deletesqlst = deletesqlst + \
	        '%s=<dtml-sqlvar %s type=%s>,\n' % (fld,fld,typ)
	    else:
	      wherearg = wherearg + '%s\n' % fld
	      if wherest == '':
	        wherest = """where (%s=<dtml-sqlvar %s type=%s>)""" \
		  % (fld,fld,typ)
	      else:
	        wherest = wherest + """ and (%s=<dtml-sqlvar %s type=%s>)""" \
		  % (fld,fld,typ)
	  deletesqlst = deletesqlst[:-2] + '\n'
	  ret = []
	  if wherest =="":
	    ret.append(arg)
	    ret.append(deletesqlst + wherest)
	    return ret
	  else:
	    ret.append(wherearg)
	    ret.append(deletefirst + wherest)
	    return ret


	elif self.selectdb == 'p':

	  self.REQUEST.form['tbl'] = tbl
	  columns = self.showOnesql()
	  cols = columns.names()
	  indexs = self._getpgindexSQL()
	  idxf = ""
	  for idx in indexs:
	    if idx['unique'] == 1:
	      idxf = idxf + ' %s ' % idx['fields']
	  indexlist = ""
	  if idxf != "":
	    indexlist = string.split(idxf)
	  results = self._getpgColumnsSQL()
	  names = results.names()
	  deletefirst = deletesqlst = "delete from %s\n" % tbl
	  arg = ""
	  wherearg = ""
	  wherest = ""
	  cn = 0
	  for cname in cols:
	    cn += 1
	    for row in results:
	      fld = row['field']
	      if cname == fld:
	        arg = arg + '%s\n' % fld
		typ = self._zopedbType(row['type'])
		if indexlist != "":
		  if self._keycheck(cn, indexlist):
		    wherearg = wherearg + '%s\n' % fld
		    if wherest == '':
		      wherest = """where (%s=<dtml-sqlvar %s type=%s>)""" \
		        % (fld,fld,typ)
		    else:
		      wherest = wherest + \
		        """ and (%s=<dtml-sqlvar %s type=%s>)""" % (fld,fld,typ)
		  else:
		    deletesqlst = deletesqlst + \
		      """%s=<dtml-sqlvar %s type=%s>,\n""" % (fld,fld,typ)
		else:
		  deletesqlst = deletesqlst + \
		    """%s=<dtml-sqlvar %s type=%s>,\n""" % (fld,fld,typ)
	  deletesqlst = deletesqlst[:-2] + '\n'
	  ret = []
	  if wherest =="":
	    ret.append(arg)
	    ret.append(deletesqlst + wherest)
	    return ret
	  else:
	    ret.append(wherearg)
	    ret.append(deletefirst + wherest)
	    return ret

	elif self.selectdb == 'i':
	  tbl = string.strip(tbl)
	  self.REQUEST.form['tbl'] = string.upper(tbl)
	  results = self._getibColumnsSQL()
	  names = results.names()
	  keytb = []
	  keyresult = self._getibindexSQL()
	  for ke in keyresult:
	    keytb.append(string.strip(string.lower(ke['FLD'])))

	  deletefirst = deletesqlst = "delete from %s\n" % string.lower(tbl)
	  arg = ""
	  wherearg=""
	  wherest = ""
	  for row in results:
	    fld = string.strip(string.lower(row['FLD']))
	    arg = arg +'%s \n' % fld
	    typ = self._zopedbType(string.strip(string.lower(row['TYP'])))

	    keyflg = None
	    for ke in keytb:
	      if ke == fld and row['N_NUL']==1:
	        keyflg = 1

	    if keyflg == None:
	      deletesqlst = deletesqlst + \
	        """%s=<dtml-sqlvar %s type=%s>,\n""" % (fld,fld,typ)
	    else:
	      wherearg = wherearg + '%s\n' % fld
	      if wherest == '':
	        wherest = """where (%s=<dtml-sqlvar %s type=%s>)""" \
		  % (fld,fld,typ)
              else:
	        wherest = wherest + \
		  """ and (%s=<dtml-sqlvar %s type=%s>)""" % (fld,fld,typ)
	  deletesqlst = deletesqlst[:-2] + '\n'
	  ret = []
	  if wherest =="":
	    ret.append(arg)
	    ret.append(deletesqlst + wherest)
	    return ret
	  else:
	    ret.append(wherearg)
	    ret.append(deletefirst + wherest)
	    return ret

    def getselectSQL(self,tbl):
        """
	"""
	return "select * from %s" % tbl


    def seteditdeleteSQL(self,tbl):
        """
	"""
	methodid = 'editDeleteSQL'
	cmds= self.getdeleteSQL(tbl)
	arg =cmds[0]
	cmd = cmds[1]
	self.changeMethod(idst=methodid, arg=arg, body=cmd)

	#self._manage_createsql(methodid, "", arg, cmd)
	#return methodid

    def seteditupdateSQL(self,tbl):
        """
	"""
	#methodid = 'editUpdate%sSQL' % tbl
	methodid = 'editUpdateSQL'

	cmds= self.getupdateSQL(tbl)
	arg =cmds[0]
	cmd = cmds[1]
        self.changeMethod(idst=methodid, arg=arg, body=cmd)


    def addconid(self, aq, conid, selectdb, dbhost, dbusername,
      dbpasswd, dbname, dbcharset):
        """
	"""
	if selectdb =='p':
               self[aq].manage_addProduct['ZPsycopgDA'].manage_addZPsycopgConnection(
	               conid,'',
		       self._connection_string(
		         selectdb,
			 dbname,
			 dbhost,
			 dbusername,
			 dbpasswd,
			 dbcharset,
			 None)
			 )
        elif selectdb =='m':
	       self[aq].manage_addProduct['ZMySQLDA'].manage_addZMySQLConnection(
	                conid,'',
			self._connection_string(
		         selectdb,
			 dbname,
			 dbhost,
			 dbusername,
			 dbpasswd,
			 dbcharset,
			 None)
			 )
        else:
	       self[aq].manage_addProduct['kInterbasdbDA'].manage_addKInterbaseConnection(
          conid,'',
	  self._connection_string(
	  	         selectdb,
			 dbname,
			 dbhost,
			 dbusername,
			 dbpasswd,
			 dbcharset,
			 None)
          )


    def _convcreatesql(self, tb, selectdb):
        """
	"""
	arg=""
	aq="CONV"
	idst = "%sCreateSQL" % tb
	body=self.getcreateSQL(tbl=tb, destdb=selectdb)
	self.addsqlmethod(aq=aq, idst=idst, conid=DESTCON_ID,
	  arg=arg, body=body, mes=None)

    def _convinsertsql(self, tb):
        """
	"""
	aq="CONV"
	idst = "%sinsertSQL" % tb
	sqlbody=self.getinsertSQL(tbl=tb)
	self.addsqlmethod(aq=aq, idst=idst, conid=DESTCON_ID,
	  arg=sqlbody[0], body=sqlbody[1], mes=None)

    def _convupdatesql(self, tb):
        """
	"""
	aq="CONV"
	idst = "%supdateSQL" % tb
	sqlbody=self.getupdateSQL(tbl=tb)
	self.addsqlmethod(aq=aq, idst=idst, conid=DESTCON_ID,
	  arg=sqlbody[0], body=sqlbody[1], mes=None)

    def _convselectsql(self, tb):
        """
	"""
	if self.selectdb =='m':
	  limitst = " limit %s" % self.dblimit
	else:
	  limitst =""

	aq="CONV"
	idst = "%sselectSQL" % tb
	sqlbody=self.getselectSQL(tbl=tb) + limitst
	self.addsqlmethod(aq=aq, idst=idst, conid=DBCON_ID,
	  arg="", body=sqlbody, mes=None)
        if self.selectdb=="i":
	  self.CONV[idst].manage_advanced(
	    max_rows=self.dblimit,
	    max_cache=100,
	    cache_time=0,
	    class_name='',
	    class_file='')
	elif self.selectdb == "m":
	  self.CONV[idst].manage_advanced(
	    max_rows=0,
	    max_cache=100,
	    cache_time=0,
	    class_name='',
	    class_file='')
	elif self.selectdb == "p":
	  self.CONV[idst].manage_advanced(
	    max_rows=self.dblimit,
	    max_cache=100,
	    cache_time=0,
	    class_name='',
	    class_file='')


    def _convscript(self, tb, charset):
        """
	"""

	pyid = "%srun" % tb
	cmds= self.getinsertSQL(tb)
	arg =string.split(cmds[0])
	self.REQUEST.form['tbl']=tb
	results = self.showtbSQL()
	sqlst = ""
	n = 0
	for name in results.names():
          sqlst = sqlst + "%s=retconv(gcol['%s'], '%s')," % \
	     (string.lower(arg[n]),string.lower(arg[n]), charset)
          n += 1
        sqlst = sqlst[:-1]

        body = 'request = container.REQUEST\n'
        body = body + 'RESPONSE =  request.RESPONSE\n\n'
	body = body + "Getdat = container.%sselectSQL()\n" % tb
	body = body + 'Insert = container.%sinsertSQL\n' % tb
	body = body + 'Update = container.%supdateSQL\n' % tb
	body = body + 'retconv = container.retconv\n\n'

        body = body + 'for gcol in Getdat:\n'
        body = body + '  try:\n'
        body = body + '    Insert(%s)\n' % sqlst
        body = body + '  except:\n'
        body = body + '    try:\n'
        body = body + '      Update(%s)\n' % sqlst
        body = body + '    except:\n'
        body = body + '      pass\n\n'

        body = body + 'print retconv("λޤ")\n'
        body = body + 'return printed\n'

	self.CONV.manage_addProduct['PythonScripts'].manage_addPythonScript(
	  id=pyid)
        self.CONV[pyid].ZPythonScript_edit(params='',body=body)

    def convgo(self, REQUEST=None):
        """
	"""
        try:
	  if not self.CONV.destconid.connected():
	    self.CONV.destconid.manage_open_connection(REQUEST)

	  # CreateSQL
	  for item in self.CONV.objectValues():
	    itemid = item.getId()
	    if string.find(itemid,"Create") != -1:
	      self.CONV[itemid]()

          # Script

	  for item in self.CONV.objectValues():
	    itemid = item.getId()
	    if string.find(itemid,"run") != -1:
	      self.CONV[itemid]()

	  mes = "Convert Copy Done!"
        except:
	  mes = "Error!! Can't Convert Copy"
        if REQUEST:
	    returl= "%s/%s" % (self.absolute_url(),"showTable_html")
	    return MessageDialog(
	      title='Database Convert',
	      message=mes,
	      action = returl)

    def encodingdb(self, tbl, selectdb, dbhost, dbusername,
      dbpasswd, dbname, dbcharset):
        """
	"""
	for item in self.CONV.objectValues():
	  self.CONV.manage_delObjects(item.getId())
	try:
	  self.addconid("CONV", DESTCON_ID,selectdb, dbhost, dbusername,
	     dbpasswd, dbname, dbcharset)

	  for tb in tbl:
	     tb=string.lower(string.strip(tb))
             # createsql
	     self._convcreatesql(tb=tb, selectdb=selectdb)
	     # insertsql
	     self._convinsertsql(tb=tb)
	     # updatesql
	     self._convupdatesql(tb=tb)
	     # select
	     self._convselectsql(tb=tb)
             # Script
	     self._convscript(tb=tb, charset=dbcharset)
	     # showConvertGOMessage
          url="%s/%s" % (self.absolute_url(), "showconvForm")
          self.REQUEST.RESPONSE.redirect(url)
	except:
	  mes = "Error!! Can't Encoding "
	  returl= "%s/%s" % (self.absolute_url(),"showTable_html")
          return MessageDialog(
	      title='Database Encoding',
	      message=mes,
	      action = returl)


    def addsqlmethod(self, aq="", idst="", conid="", arg="", body="", mes=1):
        """
	"""
	try:
	  self[aq].manage_addProduct['ZSQLMethods'].manage_addZSQLMethod(
	    id=idst,title='',connection_id=conid,arguments=arg,template=body)
	  message="Create OK! "
        except:
	  message="Error: Can'tCreate "
        if self.REQUEST and mes:
	    returl= "%s/%s" % (self.absolute_url(),"showTable_html")
	    return MessageDialog(
	      title='Database Selected',
	      message=message,
	      action = returl)

    def _connection_string(self, selectdb="", dbname="",
      dbhost="",dbusername="",dbpasswd="",dbcharset="",sw=1):
        """  """
	if sw:
	  selectdb=self.selectdb
	  dbhost=self.dbhost
	  dbname=self.dbname
	  dbusername=self.dbusername
	  dbpasswd = self.dbpasswd
	  dbcharset = self.dbcharset

	if selectdb =='m':
            if dbhost != '':
               constr = "%s@%s %s %s" % (
	       dbname, dbhost, dbusername, dbpasswd)
            else:
               constr = "%s %s %s" % (
	        dbname, dbusername, dbpasswd)
            return constr

	elif selectdb =='p':
            constr = "dbname=%s user=%s " % (dbname,dbusername)
	    if dbpasswd != '':
	      constr = constr + "password=%s " % dbpasswd
	    if dbhost != '':
	      constr = constr + "host=%s" % dbhost
            return constr
	else:
            utf8='UNICODE_FSS'
            euc='EUCJ_0208'
            sjis='SJIS_0208'
            unicodest=euc
            if dbcharset =='utf-8':
              unicodest=utf8
            elif dbcharset=='shift_jis':
              unicodest = sjis
            if dbhost != '':
               constr = "%s:%s %s %s %s" % (
	         dbhost, dbname, dbusername,
	         dbpasswd, unicodest)
            else:
               constr = "%s %s %s %s" % (
	         dbname, dbusername,
	         dbpasswd, unicodest)
            return constr


    def setdbname(self,dbl='', REQUEST=None):
        """
	"""
        self.manage_delObjects(DBCON_ID)
	self.dbname=str(dbl)
	if self.selectdb =='p':
               self.manage_addProduct['ZPsycopgDA'].manage_addZPsycopgConnection(
	               DBCON_ID,'', self._connection_string())
        elif self.selectdb =='m':
	       self.manage_addProduct['ZMySQLDA'].manage_addZMySQLConnection(
	                DBCON_ID,'',self._connection_string())
        else:
	       self.manage_addProduct['kInterbasdbDA'].manage_addKInterbaseConnection(
          DBCON_ID,'',self._connection_string())

        #self._manage_createsql_main()

        message="InpboxDB (%s) selectddatabase. conid click reopen " % self.dbname
        if REQUEST:
            returl= "%s/%s" % (self.absolute_url(),"selectdbForm_html")
	    return MessageDialog(
	      title='Database Selected',
	      message=message,
	      action = returl)


    def droptb(self, REQUEST=None):
        """
	"""
	RETHTML="%s/%s" % (self.absolute_url(),"showTable_html")
	tbl = REQUEST['tbl']
	if tbl:
	  tblist = string.split(tbl,',')
	  for tb in tblist:
	    tbs = ""
	    for s in tb:
	      if s != '[' and s != ']' and s != "'" and s != '"' and s != ' ':
	        tbs = tbs + s
	    REQUEST.form['tb'] = tbs
	    self.droptbSQL()
        REQUEST.RESPONSE.redirect(RETHTML)

    def retconv(self, st='', charset=None):
        """
	"""
	if charset == self.dbcharset:
	  return st
	if not charset:
          charset = self.dbcharset
	return conv(st, charset)

    def catjpstring(self, st, length):
        """
	"""
	return get_string_part(st, length, self.dbcharset)

