import com.nttdocomo.ui.*;

public class LowLevelEventTest extends IApplication {
    public void start() {
        Display.setCurrent(new TestCanvas());
    }
}

class TestCanvas extends Canvas {
    private Font font;
    private String mesg;

    public TestCanvas() {
        setBackground(Graphics.getColorOfName(Graphics.WHITE));
        setSoftLabel(SOFT_KEY_1, "Left");
        setSoftLabel(SOFT_KEY_2, "Rght");

        font = Font.getFont(Font.FACE_MONOSPACE |
                            Font.STYLE_BOLD | Font.SIZE_LARGE);
        mesg = " ";
    }

    public void paint(Graphics g) {
        int width = getWidth();
        int height = getHeight();

        g.clearRect(0, 0, width, height);

        g.setFont(font);
        g.setColor(Graphics.getColorOfName(Graphics.BLACK));
        g.drawString(mesg, width / 2, height / 2);

        g.setColor(Graphics.getColorOfName(Graphics.BLUE));
        int keypadState = getKeypadState();
        for (int i = 0; i < 32; i++) {
            g.drawRect(i * 3, height - 20, 2, 19);
            if ((keypadState & (1 << i)) != 0) {
                g.fillRect(i * 3, height - 20, 3, 20);
            }
        }
    }

    public void processEvent(int type, int param) {
        System.out.println("!!! Event occurred: type=" + type +
                           ",param=" + param);

        if (type == Display.KEY_PRESSED_EVENT) {
            switch (param) {
            case Display.KEY_0:         mesg = "0";  break;
            case Display.KEY_1:         mesg = "1";  break;
            case Display.KEY_2:         mesg = "2";  break;
            case Display.KEY_3:         mesg = "3";  break;
            case Display.KEY_4:         mesg = "4";  break;
            case Display.KEY_5:         mesg = "5";  break;
            case Display.KEY_6:         mesg = "6";  break;
            case Display.KEY_7:         mesg = "7";  break;
            case Display.KEY_8:         mesg = "8";  break;
            case Display.KEY_9:         mesg = "9";  break;
            case Display.KEY_ASTERISK:  mesg = "*";  break;
            case Display.KEY_POUND:     mesg = "#";  break;
            case Display.KEY_UP:        mesg = "^";  break;
            case Display.KEY_DOWN:      mesg = "v";  break;
            case Display.KEY_LEFT:      mesg = "<";  break;
            case Display.KEY_RIGHT:     mesg = ">";  break;
            case Display.KEY_SELECT:    mesg = "S";  break;
            case Display.KEY_SOFT1:     mesg = "S1";  break;
            case Display.KEY_SOFT2:     mesg = "S2";  break;
            default:                    mesg = Integer.toString(param, 16);
            }
            repaint();
        } else if (type == Display.KEY_RELEASED_EVENT) {
            mesg = " ";
            repaint();
        }
    }
}
