/*
 * $Id: RuntimeCompileOption.java,v 1.3 2002/05/19 13:56:41 ymakise Exp $
 */

/*
 * Copyright (c) 2002, MAKISE Yoshitaro
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above
 *    copyright notice, this list of conditions and the following
 *    disclaimer in the documentation and/or other materials provided
 *    with the distribution.
 *
 * 3. Neither the name of the iModoki nor the names of its
 *    contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE
 * COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 */

package jp.sourceforge.imodoki.converter;

import java.util.Iterator;
import java.util.Map;
import java.util.HashMap;
import java.util.Set;
import java.util.Collections;


/**
 * 󥿥饤֥Υѥ륪ץ
 */
public class RuntimeCompileOption {
    /** ץͤưŪ˷ꤵ륪ץ͡ */
    public static final Object AUTO = null;

    /** ץIDɽʸ */
    public static final String STRICTER_ERROR_CHECKING =
                                   "STRICTER_ERROR_CHECKING";
    public static final String DOUBLE_BUFFERING =
                                   "DOUBLE_BUFFERING";
    public static final String FILLPOLYGON_ACTUALLY_FILL =
                                   "FILLPOLYGON_ACTUALLY_FILL";
    public static final String USE_SCRATCHPAD_CONNECTION =
                                   "USE_SCRATCHPAD_CONNECTION";
    public static final String USE_HTTP_CONNECTION =
                                   "USE_HTTP_CONNECTION";

    private Map m_options = new HashMap();

    public RuntimeCompileOption() {
        initialize();
    }

    public void initialize() {
        m_options.put(STRICTER_ERROR_CHECKING,   Boolean.FALSE);
        m_options.put(DOUBLE_BUFFERING,          Boolean.FALSE);
        m_options.put(FILLPOLYGON_ACTUALLY_FILL, Boolean.TRUE);
        m_options.put(USE_SCRATCHPAD_CONNECTION, AUTO);
        m_options.put(USE_HTTP_CONNECTION,       AUTO);
    }

    /**
     * iץ jam ե jar եξ󤫤
     * ץͤꤹ롣
     *
     * @param  jamContent   jam եƤɽ֥ȡ
     * @param  jarInspector JarFileInspector ֥ȡ
     */
    public void configure(JAMFile jamContent, JarFileInspector jarInspector) {
        if (jamContent.useHttpNetwork()) {
            setValue(USE_HTTP_CONNECTION, true);
        } else {
            setValue(USE_HTTP_CONNECTION, false);
        }

        if (jamContent.getSPsize() > 0) {
            setValue(USE_SCRATCHPAD_CONNECTION, true);
        } else {
            setValue(USE_SCRATCHPAD_CONNECTION, false);
        }

        if (jarInspector.callsMethod("com.nttdocomo.ui.Canvas",
                                     "getGraphics",
                                     "()Lcom/nttdocomo/ui/Graphics;")) {
            setValue(DOUBLE_BUFFERING, true);
        }
    }

    /**
     * boolean ͤФ
     *
     * @param  id  ץID
     * @return б boolean ͡
     */
    public boolean getBoolean(String id) {
        if (!m_options.containsKey(id)) {
            throw new IllegalArgumentException("Undefined option id: " + id);
        }

        Object val = m_options.get(id);

        if (!(val instanceof Boolean)) {
            throw new IllegalArgumentException("Not boolean: " + val);
        }

        return ((Boolean)val).booleanValue();
    }

    /**
     * boolean ͤ򥻥åȤ롣
     *
     * @param  id     ץID
     * @param  value  åȤ͡
     * @exception  IllegalArgumentException
     *             б륪ץIDʤȤꤲ㳰
     */
    public void setValue(String id, boolean value) {
        if (!m_options.containsKey(id)) {
            throw new IllegalArgumentException("Undefined option id: " + id);
        }

        m_options.put(id, new Boolean(value));
    }

    /**
     * Ϳ줿 bool ͤ˥åȤƤ륪ץID "," Ƕڤ
     * ꥹȤ֤ʤȤ϶ʸ֤
     */
    public String getBooleanList(boolean testValue) {
        StringBuffer sb = new StringBuffer();

        Iterator itr = m_options.entrySet().iterator();
        while (itr.hasNext()) {
            Map.Entry entry = (Map.Entry)itr.next();
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            if (value instanceof Boolean &&
                ((Boolean)value).booleanValue() == testValue) {
                sb.append(key);
                sb.append(",");
            }
        }

        if (sb.length() == 0) {
            return "";
        } else {
            return sb.substring(0, sb.length() - 1);
        }
    }

    /**
     * ץIDΰ֤
     */
    public Set getOptionIDs() {
        return Collections.unmodifiableSet(m_options.keySet());
    }
}
