/*
 * $Id: JAMFile.java,v 1.2 2002/05/18 10:30:07 ymakise Exp $
 */

/*
 * Copyright (c) 2002, MAKISE Yoshitaro
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above
 *    copyright notice, this list of conditions and the following
 *    disclaimer in the documentation and/or other materials provided
 *    with the distribution.
 *
 * 3. Neither the name of the iModoki nor the names of its
 *    contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE
 * COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 */

package jp.sourceforge.imodoki.converter;

import java.io.*;
import java.util.Map;
import java.util.HashMap;

/**
 * iץ ADF(Application Descripter File) Ǥ .jam ե
 * 饹
 */
public class JAMFile {
    private Map entries;

    public JAMFile() {
        entries = new HashMap();
    }

    public JAMFile(InputStream is) throws IOException {
        this();
        read(is);
    }

    public JAMFile(File file) throws IOException {
        this();
        InputStream is = new FileInputStream(file);
        try {
            read(is);
        } finally {
            is.close();
        }
    }

    public void read(InputStream is) throws IOException {
        BufferedReader br =
            new BufferedReader(new InputStreamReader(is, "Shift_JIS"));
        try {
            String line;

            while ((line = br.readLine()) != null) {
                if (line.trim().length() == 0) {
                    continue;
                }
                int i = line.indexOf('=');
                if (i == -1) {
                    throw new IOException(".jam file syntax error: '" +
                                          line + "'");
                }
                String key = line.substring(0, i).trim();
                String value = line.substring(i + 1).trim();
                if (key.length() == 0) {
                    throw new IOException(".jam file syntax error: '" +
                                          line + "'");
                }

                entries.put(key, value);
            }

        } finally {
            br.close();
        }
    }

    /**
     * ꤷͤФ
     *
     * @param  key  
     * @return б͡
     *         бͤ¸ߤʤȤ null
     */
    public String getValue(String key) {
        return (String)entries.get(key);
    }

    public String getAppName() {
        String val = getValue("AppName");

        if (val == null)
            throw new RuntimeException("AppName is mandatory");

        return val;
    }

    public String getPackageURL() {
        String val = getValue("PackageURL");

        if (val == null)
            throw new RuntimeException("PackageURL is mandatory");

        return val;
    }

    public String getAppClass() {
        String val = getValue("AppClass");

        if (val == null)
            throw new RuntimeException("AppClass is mandatory");

        return val;
    }

    public String getAppParam() {
        return getValue("AppParam");
    }

    public int getSPsize() {
        String val = getValue("SPsize");

        if (val == null || val.length() == 0)
            return 0;
        else
            return Integer.parseInt(val);
    }

    public boolean useHttpNetwork() {
        String val = getValue("UseNetwork");

        if (val != null && val.indexOf("http") != -1)
            return true;
        else
            return false;
    }

    /** ƥ main */
    public static void main(String[] args) throws IOException {
        JAMFile jamFile = null;

        InputStream is = new FileInputStream(args[0]);
        try {
            jamFile = new JAMFile(is);
        } finally {
            is.close();
        }

        System.out.println("AppName: " + jamFile.getAppName());
        System.out.println("PackageURL: " + jamFile.getPackageURL());
        System.out.println("AppClass: " + jamFile.getAppClass());
        System.out.println("AppParam: " + jamFile.getAppParam());
        System.out.println("SPsize: " + jamFile.getSPsize());
        System.out.println("UseHttpNetwork: " + (jamFile.useHttpNetwork() ?
                                                 "yes" : "no"));
    }
}
