/*
 * $Id: ClassNameReplaceTask.java,v 1.2 2002/05/03 14:33:24 ymakise Exp $
 */

/*
 * Copyright (c) 2002, MAKISE Yoshitaro
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above
 *    copyright notice, this list of conditions and the following
 *    disclaimer in the documentation and/or other materials provided
 *    with the distribution.
 *
 * 3. Neither the name of the iModoki nor the names of its
 *    contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE
 * COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 */

package jp.sourceforge.imodoki.ant;

import java.io.File;
import java.io.IOException;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;

/*
  : ȴǰ٤1ȤΥ饹ִ̾ˤбƤʤ
 */

public class ClassNameReplaceTask extends FileConvertTask {
    private String fromName;
    private String toName;

    public void setFrom(String fromName) {
        this.fromName = fromName;
    }

    public void setTo(String toName) {
        this.toName = toName;
    }

    protected void convert(File srcFile, File destFile) {
        if (fromName == null || toName == null) {
            throw new BuildException("from and to attribute required");
        }

        if (srcFile.equals(destFile)) {
            throw new BuildException("file " + srcFile 
                                     + " would overwrite its self");
        }

        log("replacing class " + fromName + " to " + toName +
            " from file " + srcFile + " to " + destFile, Project.MSG_VERBOSE);

        try {
            ClassNameReplacer replacer = new ClassNameReplacer(srcFile.toString());
            replacer.replace(fromName, toName);
            replacer.dump(destFile.toString());
        } catch (IOException ioe) {
            throw new BuildException("conversion failed: " + ioe);
        }
    }
}
