#/*
# *  Copyright 2007-2010 hkrn <hikarin@users.sourceforge.jp>
# *
# *  Licensed under the Apache License, Version 2.0 (the "License");
# *  you may not use this file except in compliance with the License.
# *  You may obtain a copy of the License at
# *
# *      http://www.apache.org/licenses/LICENSE-2.0
# *
# *  Unless required by applicable law or agreed to in writing, software
# *  distributed under the License is distributed on an "AS IS" BASIS,
# *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# *  See the License for the specific language governing permissions and
# *  limitations under the License.
# */
#
# $Id: DNSBL.pm 1901 2009-12-31 02:40:20Z hikarin $
#

package Img0ch::Plugin::Filter::DNSBL;

use strict;
use Img0ch::Plugin::Module::DNSBL qw();

sub check_by_bbq {
    _check_proxy( 'bbq', @_ );
}

sub check_by_bbx {
    _check_proxy( 'bbx', @_ );
}

sub check_by_dsbl {1}

sub by_rbl {
    _check_proxy( 'rbl', @_ );
}

sub by_spamcop {
    _check_proxy( 'spamcop', @_ );
}

sub by_spamhaus {
    _check_proxy( 'spamhaus', @_ );
}

sub by_blitzed {1}

sub by_empty {
    _check_proxy( 'empty', @_ );
}

sub by_spamlookup {
    _check_proxy( 'spamlookup', @_ );
}

sub by_livedoor {
    _check_proxy( 'livedoor', @_ );
}

sub _check_proxy {
    my ( $base, $iApp ) = @_;
    my $ip = $iApp->get_ip_int();

    if ( Img0ch::Plugin::Module::DNSBL->is_in_dnsbl( $base, $ip ) ) {
        if ( $iApp->setting()->is_checked('BBS_OVERSEA_PROXY') ) {
            $iApp->cap()->can_pass_proxy_access() and return 1;
            $iApp->set_error('DENY_FROM_DNSBL_LISTED_HOST');
            $iApp->set_error_argument(
                {   DNSBL =>
                        Img0ch::Plugin::Module::DNSBL->get_hostname($base)
                }
            );
            return 0;
        }
        else {
            my $name = $iApp->get_name();
            if ( $name !~ /<\/b>\[-{}\@{}\@{}-\]<b>/xms ) {
                $name = '</b>[-{}@{}@{}-]<b> ' . $name;
                $iApp->set_name($name);
            }
        }
    }

    return 1;
}

1;
__END__
