#/*
# *  Copyright 2007 hkrn <hikarin@users.sourceforge.jp>
# *
# *  Licensed under the Apache License, Version 2.0 (the "License");
# *  you may not use this file except in compliance with the License.
# *  You may obtain a copy of the License at
# *
# *      http://www.apache.org/licenses/LICENSE-2.0
# *
# *  Unless required by applicable law or agreed to in writing, software
# *  distributed under the License is distributed on an "AS IS" BASIS,
# *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# *  See the License for the specific language governing permissions and
# *  limitations under the License.
# */
#
# $Id: Supporter.pm 1137 2007-09-15 13:15:41Z hikarin $
#

package Zeromin2::Translate::JBBS::Supporter;

use strict;
use Zeromin2::Translate::JBBS::Parser qw();

my $SUPPORTER_GROUP_NAME = 'JBBS Supporter Group';

sub work {
    my ( $zClass, $iKernel, $argument ) = @_;
    my $zTJP = Zeromin2::Translate::JBBS::Parser->new();
    my $tree;

    $zTJP->set_url( $argument->{-url} );
    $zTJP->set_password( $argument->{-pass} || $argument->{-password} );
    if ( $zTJP->try_post_form( \$tree, 'supporter' ) ) {
        my $zUser = $argument->{user};
        my $gid   = $zUser->get_group_id($SUPPORTER_GROUP_NAME);
        if ( !$gid ) {
            $zUser->add_group(
                {   name      => $SUPPORTER_GROUP_NAME,
                    bbs       => $argument->{-bbs},
                    privilege => {
                        user     => 0,
                        cap      => 0,
                        bbs      => 0,
                        subject  => 0,
                        setting  => 0,
                        thread   => 0,
                        pool     => 0,
                        archive  => 0,
                        res      => 1,
                        meta     => 0,
                        control  => 0,
                        category => 0,
                        view     => 0,
                        plugin   => 0,
                    },
                }
            );
            $zUser->save();
            $gid = $zUser->get_group_id($SUPPORTER_GROUP_NAME);
        }

        my @rows = $tree->find('table')->look_down( '_tag' => 'tr' );
        shift @rows;
        for my $tr (@rows) {
            my @data = $tr->look_down( '_tag' => 'td' );
            my $content = [];
            for my $td (@data) {
                my $text = $td->as_text();
                $text =~ /\A\s*\z/ and next;
                push @$content,
                    $iKernel->get_encoded_str( $text, 'utf8', 'euc' );
            }
            my $name = $content->[0];
            my $pass = $content->[1];
            $zUser->get_user_id($name) and next;
            $zUser->add(
                {   name => $name,
                    mail => 'dev@slash.null',
                    pass => $pass,
                    gid  => $gid
                }
            );
        }

        $zUser->save();
        return 1;
    }

    return 0;
}

sub get_group_name { return $SUPPORTER_GROUP_NAME }

1;
__END__
