#/*
# *  Copyright 2007 hkrn <hikarin@users.sourceforge.jp>
# *
# *  Licensed under the Apache License, Version 2.0 (the "License");
# *  you may not use this file except in compliance with the License.
# *  You may obtain a copy of the License at
# *
# *      http://www.apache.org/licenses/LICENSE-2.0
# *
# *  Unless required by applicable law or agreed to in writing, software
# *  distributed under the License is distributed on an "AS IS" BASIS,
# *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# *  See the License for the specific language governing permissions and
# *  limitations under the License.
# */
#
# $Id: log.pm 107 2007-01-20 12:48:46Z hikarin $
#

package Zeromin::App::log;

use strict;

sub load {
    my ($zApp) = @_;
    my $zUser    = $zApp->user() || return { code => 1 };
    my $iBBS     = $zApp->bbs();
    my $iRequest = $zApp->request();
    my $type     = $iRequest->param('type');

    my ( undef, undef, undef,
        $current_day, $current_month, $current_year ) = localtime(time());
    $current_year  += 1900;
    $current_month += 1;

    if ( $type eq 'action' ) {
        $zUser->can_enter_log_section() or return { code => 1 };
        require Zeromin::Log::Action;
        my $zLogAct = Zeromin::Log::Action->new( $zApp->kernel() );
        my $by      = $iRequest->param('by');
        my ( $year, $month, $day, $content );
        if ( $by eq 'all' ) {
            $content = $zLogAct->all($zUser);
        }
        elsif ( $by eq 'month' ) {
            $year = $iRequest->param_int('year') || $current_year;
            $month = $iRequest->param_int('month') || $current_month;
            $content
                = $zLogAct->retrive_by_month( $year, $month, $zUser );
        }
        else {
            $year = $iRequest->param_int('year') || $current_year;
            $month = $iRequest->param_int('month') || $current_month;
            $day = $iRequest->param_int('day') || $current_day;
            $content
                = $zLogAct->retrive_by_day( $year, $month, $day, $zUser );
        }
        return {
            code    => 0,
            content => $content,
        };
    }
    if ( $type eq 'error' ) {
        $zUser->can_view_error_log() or return { code => 1 };
        require Zeromin::Log::Error;
        my $zLogErr = Zeromin::Log::Error->new( $iBBS || $zApp->kernel() );
        my $by      = $iRequest->param('by');
        my $key     = $iRequest->param('key');
        my ( $year, $month, $day, $content );
        $zLogErr->load();
        if ( $by eq 'all' ) {
            # Img0ch::BBS => bbs_dir | Img0ch::Kernel => undef
            $content = $zLogErr->all_in( undef, $key );
        }
        elsif ( $by eq 'month' ) {
            $year = $iRequest->param_int('year') || $current_year;
            $month = $iRequest->param_int('month') || $current_month;
            # Img0ch::BBS => bbs_dir | Img0ch::Kernel => undef
            $content = $zLogErr->retrive_by_month_in(
                $year, $month, undef, $key );
        }
        else {
            $year = $iRequest->param_int('year') || $current_year;
            $month = $iRequest->param_int('month') || $current_month;
            $day = $iRequest->param_int('day') || $current_day;
            # Img0ch::BBS => bbs_dir | Img0ch::Kernel => undef
            $content = $zLogErr->retrive_by_day_in(
                $year, $month, $day, undef, $key );
        }
        return {
            code    => 0,
            content => $content,
        };
    }
    if ( $type eq 'thread' and $iBBS ) {
        $zUser->can_view_thread_log() or return { code => 1 };
        require Zeromin::Log::Thread;
        my $zLogThr = Zeromin::Log::Thread->new($iBBS);
        $zLogThr->load();
        return { code => 0, content => $zLogThr->all() };
    }
    return { code => 0, content => [] };
}

sub lookup {
    my ($zApp) = @_;
    my $zUser    = $zApp->user() || return { code => 1 };
    $zUser->can_view_thread_log()
        or $zUser->can_view_error_log()
        or $zUser->can_enter_log_section()
        or return { code => 1 };

    my $ip = $zApp->request()->param('ip');
    $ip =~ /\A(\d+)\.(\d+)\.(\d+)\.(\d+)\z/xms or return { code => 2 };
    my @ipaddr = ( $1, $2, $3, $4 );

    require Img0ch::Plugin::Module::RACC;
    my $cc = eval {
        return Img0ch::Plugin::Module::RACC->get(
            $ip, $zApp->kernel()->get_config() );
        } || '--';

    my %dnsbl = (
        'niku.2ch.net'         => '%d.%d.%d.%d.niku.2ch.net',
        'bbx.2ch.net'          => '%d.%d.%d.%d.bbx.2ch.net',
        'list.dsbl.org'        => '%d.%d.%d.%d.list.dbsl.org',
        'all.rbl.jp'           => '%d.%d.%d.%d.all.rbl.jp',
#        'bl.spamcop.net'       => '%d.%d.%d.%d.bl.spamcop.net',
#        'sbl-xbl.spamhaus.org' => '%d.%d.%d.%d.sbl-xbl.spamhaus.org',
#        'opm.blized.org'       => '%d.%d.%d.%d.opm.blitzed.org',
#        'bsb.empty.us'         => '%d.%d.%d.%d.bsb.empty.us',
#        'bsb.spamlookup.net'   => '%d.%d.%d.%d.bsb.spamlookup.net',
    );
    my $ret = {};
    my $host = gethostbyaddr( pack('C*', @ipaddr ), 2 ) || $ip;
    for my $dnsbl_name ( sort keys %dnsbl ) {
        my $dnsbl_addr = $dnsbl{$dnsbl_name};
        my $addr = sprintf $dnsbl_addr, reverse(@ipaddr);
        $ret->{$dnsbl_name} = gethostbyname($addr) ? 1 : 0;
    }
    return { code => 0, content => {
        resolved => $host, country => $cc, listed => $ret
        }
        };
}

1;
__END__
