/*
 *  Copyright 2007 hkrn <hikarin@users.sourceforge.jp>
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *
 * Img0ch.App.Search
 * $Id: search.js 156 2007-01-31 14:04:13Z hikarin $
 *
 * @require jquery.js
 * @require domLib.js
 * @require domTT.js
 * @require img0ch/template/*.js
 * @require img0ch/util.js
 */

var Img0ch;
if ( typeof Img0ch == "undefined" ) Img0ch = {};
if ( typeof Img0ch.App == "undefined" ) Img0ch.App = {};

Img0ch.App.Search = function(option) {
    var baseURL  = option.URL;
    var bbs      = option.bbs;
    var cushion  = option.cushion || "http://nun.nu/";
    var opt      = option.option;
    var rootNode = option.rootNode || "threadRoot";
    var bbsURL   = baseURL + '/'    + bbs + '/';

    this.baseURL       = baseURL;
    this.bbsURL        = bbsURL;
    this.bbs           = bbs;
/*
    this.imageLink     = new RegExp(
        "<a[^>]*>(.+/" + bbs + "/img/" + key
        + "/(\\d+)\\.([\\w\\.]+))</a>", "g" );
    this.imageLinkTo   = "<a href='$1' rel='imagebox_" + bbs + "_"
        + key + "' title='$2.$3'><b>[$3]</b></a>";
*/
    this.lastUpdate    = new Date();
    this.linkRegex     = new RegExp(
        "(https?://[A-Za-z0-9~/._\\?&=\\-%#\\+:;,@']+)", "g" );
    this.linkReplaceTo = "<a href='" + cushion + "$1'>$1</a>";
    this.option        = opt;
    this.popRegex      = new RegExp(
        "(<a[^>]*>)?(&gt;|&gt;&gt;|＞|＞＞)([\\d\\-]+)(</a[^>]*>)?", "g" );
    this.popReplaceTo  = "<a href='javascript:void(0)' "
        + "onmouseover='" + ( option.varName || "app" )
        + ".popup( this, event, \"$3\" )'>&gt;&gt;$3</a>";
    this.renderCB      = option.renderCallback;
    this.res           = [ [ "", "", "", "", "" ] ];
    this.rootNode      = rootNode;
    this.subjectTxtURL = this.bbsURL + "subject.txt";
    this.subjectCache  = {};
    this.template      =
        Img0ch.Template[option.template] || Img0ch.Template.Default;
    this.threadCaches  = {};
    this.lastModified  = {};
}

Img0ch.App.Search.prototype = {
    "getAll": function(key) {
        return this.threadCaches[key + ".dat"];
    },
    "sendQuery": function(word) {
        jQuery("div#searchResult").empty();
        this.loadSubject(word);
        return;
    },
    "loadSubject": function(word) {
        var img0chSearch = this;
        jQuery("span#process").html("(subject.txtを読み込み中...)");
        jQuery.getIfModified( this.subjectTxtURL, function(content) {
            var cache = img0chSearch.subjectCache;
            if (content) {
                var line  = content.split("\n");
                for ( i in line ) {
                    var subject = String(line[i]).split("<>");
                    var thread  = String(subject[0]);
                    if (thread) cache[thread] = true;
                }
            }
            var i = 1;
            for ( var thread in cache ) {
               img0chSearch.loadThread( thread, word, i );
               i++;
            }
            });
    },
    "loadThread": function( thread, word, offset ) {
        var img0chSearch = this;
        var request = this.bbsURL + "dat/" + thread + ".utf8";
        var key = String(thread).split(".")[0];
        var process = jQuery(
            "span#process").html("(" + thread + "を読み込み中...)");
        jQuery.getIfModified( request, function(content) {
            var cache = img0chSearch.threadCaches;
            var dat;
            if (content) {
                var line = content.split("\n");
                dat = [];
                for ( var i in line ) {
                    dat.push(String(line[i]).split("<>"));
                }
                cache[thread] = dat;
            }
            else {
                dat = cache[thread];
            }
            if (word)
                img0chSearch.executeFromThread( dat, key, word, offset );
            process.html("");
            });
    },
    "executeFromThread": function( thread, key, word, offset ) {
        var found = 0;
        var divThread = jQuery(document.createElement("div")
            ).addClass("body").addClass("thread_body"
            ).attr({ "id": "t_" + key }).get(0);
        var template  = this.template;
        var type   = Img0ch.Util.intval(jQuery("select#searchType").val());
        var words  = Img0ch.Util.escapeHTMLEntities(word).split(/\s+/);
        var wlen   = words.length;
        if (type > 3) type = 3;
        for ( var i in thread ) {
            var res = thread[i];
            if ( typeof res[3] == "undefined" ) continue;
            var hit    = 0;
            var result = [ res[0], res[1], res[2], res[3] ];
            var src    = res[type];
            for ( var j in words ) {
                var w = words[j];
                if ( src.indexOf(w) >= 0 ) {
                    var regex   = new RegExp(w, 'g');
                    var colored = "<b class='yellow'>" + w + "</b>";
                    src = src.replace( regex, colored );
                    hit++;
                }
            }
            if ( hit === wlen ) {
                found++;
                result[type] = src;
                template.renderRes( this, divThread, Number(i) + 1, result );
            }
        }

        if (found) {
            var threadSubject = String(thread[0][4]);
            var h2ThreadHeader = jQuery(document.createElement("h2")
                ).addClass("thread_header");
            var spanThreadInfo = jQuery(document.createElement("span")
                ).addClass("thread_info").html(
               "【" + String(offset) + ":" + thread.length + "】");
            var spanThreadSubject = jQuery(document.createElement("span")
                ).addClass("thread_subject").html(threadSubject);
            var spanDate = jQuery(document.createElement("span")
                ).addClass("date");
            spanThreadInfo.appendTo(spanDate);
            spanThreadSubject.appendTo(spanDate);
            spanDate.appendTo(h2ThreadHeader);
            var divDay = jQuery(document.createElement("div")
                ).addClass("day").attr({ "id": "t_" + key });
            h2ThreadHeader.appendTo(divDay);
            jQuery(divThread).appendTo(divDay);
            var root = document.getElementById("searchResult");
            root.appendChild(divDay.get(0));
        }
        return found;
    },
    "popup": function( element, event, readRange ) {
        var domTT_styleClass = "domTTClassic";
        element.parentNode.parentNode.id.match(/t_(\d+)/);
        var reses            = this.getAll(RegExp.$1);
        var len              = reses.length;
        var content          = "<dl class='popup'>";
        var range_array      = Img0ch.Util.parseReadRange(readRange, len);
        var from             = range_array[0];
        var to               = range_array[1];
        var util             = Img0ch.Util;
        for ( var i = from; i <= to; i++ ) {
            content += util.popupRes( this, reses, i );
        }
        content += "</dl>";
        domTT_activate(element, event, "content", content, "type", "velcro");
    },
    "rewrite": function(comment) {
        return String(comment).replace(
                this.popRegex,
                this.popReplaceTo
            ).replace(
                this.linkRegex,
                this.linkReplaceTo
            ).replace(
                this.imageLink,
                this.imageLinkTo
            );
    }
}
