/*
 *  Copyright 2007 hkrn <hikarin@users.sourceforge.jp>
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *
 * Img0ch.App
 * $Id: app.js 189 2007-02-06 12:37:22Z hikarin $
 *
 */

var Img0ch;
if ( typeof Img0ch == "undefined" ) Img0ch = {};

Img0ch.App = {
    "bbsURI": null,
    "cgiURI": null,
    "disableRedirectRenderer": function() {
        this.isEnabledRedirectRenderer = false;
        return;
    },
    "enableRedirectRenderer": function() {
        this.isEnabledRedirectRenderer = true;
        return;
    },
    "getBBSURI": function() { return this.bbsURI },
    "getCGIURI": function() { return this.cgiURI },
    "getRendererURI": function() { return this.rendererURI },
    "isEnabledRedirectRenderer": false,
    "initForm": function( cookiePath, formClass ) {
        if ( !formClass ) formClass = "form.comment";
        jQuery(function () {
            jQuery("//input[@name='FROM']").val(jQuery.cookie("img0ch_name"));
            jQuery("//input[@name='mail']").val(jQuery.cookie("img0ch_mail"));
            jQuery(formClass).submit(function () {
                if ( !jQuery("textarea[@name='MESSAGE']",
                    this).val() && jQuery("input[@type='submit']",
                    this).val() == "書き込む" ) {
                    if ( confirm(
                        "本文がありません。それでも投稿しますか？") == false ) {
                        return false;
                    }
                }
                var option = { "expires": 30,
                    "path": cookiePath };
                jQuery.cookie( "img0ch_name", jQuery(
                    "input[@name='FROM']", this ).val(), option );
                jQuery.cookie( "img0ch_mail", jQuery(
                    "input[@name='mail']", this ).val(), option );
                jQuery("//input[@type='submit']").attr({ "disabled": true });
                return true;
            });
        });
    },
    "redirectRenderer": function( linkElement, query ) {
        var linkTo  = linkElement.href;
        var content = linkElement.innerHTML;
        if ( this.isEnabledRedirectRenderer
            && !this.rewritten[content + linkTo] ) {
            var qstring = "";
            if ( query ) {
                var qarray  = [];
                for ( var i in query ) {
                    qarray.push(encodeURIComponent(i)
                        + '=' + encodeURIComponent(query[i]));
                }
                qstring += '?' + qarray.join('&');
            }
            linkTo.match(/(.+)\/test\/read\.cgi\/(.+)/);
            var rewrittenURI = RegExp.$1 + "/test/"
                + this.rendererPath + qstring
                + this.rendererSeparator + RegExp.$2;
            linkElement.href = rewrittenURI;
            this.rewritten[content + rewrittenURI] = true;
        }
        return true;
    },
    "rendererPath": "read.html",
    "rendererSeparator": "#",
    "rendererURI": null,
    "rewritten": {},
    "setBBSURI": function(bbsURI) {
        this.bbsURI = bbsURI;
        return;
    },
    "setCGIURI": function(cgiURI) {
        this.cgiURI = cgiURI;
        return;
    },
    "setRendererURI": function(rendererURI) {
        this.rendererURI = rendererURI;
        return;
    },
    "setRenderer": function( path, separator ) {
        this.rendererPath = path;
        this.rendererSeparator = separator;
        return;
    }
}
