package org.arefgard.icerya.container.core.def;

import java.util.Map;

import org.arefgard.icerya.container.core.IceryaContainer;
import org.arefgard.icerya.container.strategy.cache.CacheStrategy;
import org.arefgard.icerya.container.strategy.cache.impl.NoneCacheStrategy;
import org.arefgard.icerya.container.strategy.injection.InjectionStrategy;
import org.arefgard.icerya.container.strategy.injection.impl.SetterInjectionStrategy;

/**
 * Bean`t@Cp[XʓBean
 * ێGeBeBB
 * 
 * @author Takashi Yamashina
 * @since 1.0.0
 */
public class BeanDef {
	/** Bean ID */
	private String beanId;
	/** BeañNX̊SC */
	private Class beanClass;
	/** CX^X쐬Ɏs郁\bh */
	private String initMethod;
	/** DIReiIɎs郁\bh */
	private String destroyMethod;
	
	/** vpeB */
	private Map<String, PropertyDef> properties = new java.util.HashMap<String, PropertyDef>();
	/** ReLXg(Strinĝ) */
	private String context;
	/** BeanDefǗĂRei̎Q */
	private IceryaContainer container;
	
	/** LbV헪 */
	private CacheStrategy cache;
	/** CWFNV헪 */
	private InjectionStrategy injection;
	
	public BeanDef() {
		this.cache = new NoneCacheStrategy();
		this.injection = new SetterInjectionStrategy();
	}
	
	/**
	 * Bean IDݒ肷B
	 * 
	 * @param beanId Bean ID
	 */
	public void setBeanId(String beanId) {
		this.beanId = beanId;
	}
	
	/**
	 * Bean ID擾B
	 * 
	 * @return Bean ID
	 */
	public String getBeanId() {
		return this.beanId;
	}
	
	/**
	 * BeañNXݒ肷B
	 * 
	 * @param beanClass BeañNX
	 */
	public void setBeanClass(Class beanClass) {
		this.beanClass = beanClass;
	}
	
	/**
	 * BeañNX擾B
	 * 
	 * @return BeañNX
	 */
	public Class getBeanClass() {
		return beanClass;
	}

	public String getDestroyMethod() {
		return destroyMethod;
	}

	public void setDestroyMethod(String destroyMethod) {
		this.destroyMethod = destroyMethod;
	}

	public String getInitMethod() {
		return initMethod;
	}

	public void setInitMethod(String initMethod) {
		this.initMethod = initMethod;
	}

	/**
	 * vpeBǉB
	 * 
	 * @param name vpeB
	 * @param value l
	 */
	public void addProperty(String name, PropertyDef propertyDef) {
		this.properties.put(name, propertyDef);
	}
	
	/**
	 * vpeB擾B
	 * 
	 * @param name vpeB
	 * @return l
	 */
	public PropertyDef getProperty(String name) {
		return this.properties.get(name);
	}
	
	/**
	 * SvpeB̃}bv擾B
	 * 
	 * @return SvpeB̃}bv
	 */
	public Map<String, PropertyDef> getProperties() {
		return this.properties;
	}

	public String getContext() {
		return context;
	}

	public void setContext(String context) {
		this.context = context;
	}

	public IceryaContainer getContainer() {
		return container;
	}

	public void setContainer(IceryaContainer container) {
		this.container = container;
	}

	public CacheStrategy getCacheStrategy() {
		return cache;
	}

	public void setCacheStrategy(CacheStrategy cache) {
		this.cache = cache;
	}

	public InjectionStrategy getInjectionStrategy() {
		return injection;
	}

	public void setInjectionStrategy(InjectionStrategy injection) {
		this.injection = injection;
	}
	
}
