package org.arefgard.icerya.container.core;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.arefgard.icerya.container.core.def.BeanDef;
import org.arefgard.icerya.container.strategy.cache.CacheStrategy;
import org.arefgard.icerya.container.strategy.injection.InjectionStrategy;
import org.arefgard.icerya.container.util.ReflectionUtil;

/**
 * DIReiB
 * 
 * @author Takashi Yamashina
 * @since 1.0.0
 */
public class IceryaContainer {

	/** K[ */
	private static final Log log = LogFactory.getLog(IceryaContainer.class);
	
	/** Rei */
	private Map<String, BeanDef> internal = new java.util.HashMap<String, BeanDef>();
	
	/** CN[hRei */
	private List<IceryaContainer> includeContainer = new java.util.ArrayList<IceryaContainer>();
	
	/**
	 * ftHgRXgN^B<br/>
	 * <br/>
	 * pbP[Ŵݎg悤ɂB
	 */
	IceryaContainer() {
		
	}
	
	public void addBeanDef(String beanId, String cls) {
		BeanDef beanDef = new BeanDef();
		beanDef.setBeanId(beanId);
		beanDef.setContainer(this);
		this.internal.put(beanId, beanDef);
	}
	
	/**
	 * BeanEntityIuWFNgReiɒǉB
	 * @param entity BeanEntityIuWFNg
	 */
	public void addBeanDef(BeanDef entity) {
		entity.setContainer(this);
		this.internal.put(entity.getBeanId(), entity);
	}
	
	/**
	 * BeanEntityIuWFNgReioB
	 * @param id bean id
	 * @return BeanEntityIuWFNg
	 */
	public BeanDef getBeanDef(String id) {
		return this.internal.get(id);
	}
	
	public Map<String, BeanDef> getAllBeanDef() {
		return this.internal;
	}
	
	/**
	 * Bean擾B
	 * 
	 * @param id Bean ID
	 * @return IuWFNg
	 * @throws ContainerException Bean̐Ɏs
	 */
	public Object getBean(String id) throws ContainerException {
		if(log.isDebugEnabled()) {
			log.debug("---[get bean]---");
		}
		if(id == null || id.equals("")) {
			log.error("Illegal Argument[id=" + id + "].");
			throw new ContainerException("Illegal Argument[id=" + id + "].");
		}
		BeanDef beanDef = this.internal.get(id);
		if(beanDef == null) {
			// CN[hꂽReiT
			int length = this.includeContainer.size();
			
			for(int i = 0; i < length; i++) {
				IceryaContainer container = this.includeContainer.get(i);
				beanDef = container.getBeanDef(id);
				if(beanDef != null) {
					break;
				}
			}
		}
		
		if(beanDef == null) {
			log.error("ID[" + id + "] is not exitst.");
			throw new ContainerException("ID[" + id + "] is not exist.");
		}
		
		Object result = null;
		// LbV헪(LbV̎擾)s
		CacheStrategy cache = beanDef.getCacheStrategy();
		result = cache.getCache();
		
		// 헪s
		if(result == null) {
			// CWFNV헪s
			InjectionStrategy injection = beanDef.getInjectionStrategy();
			if(injection != null) {
				injection.inject(beanDef);
				result = injection.getInjectObject();
			}

			// ēxALbV헪(LbV̕ۑ)s
			cache.save(result);

			return result;
		}else {
			return result;
		}
	}
	
	public void injectDependency(Object obj) throws ContainerException {
		
	}
	
	public boolean containsBean(Object key) {
		return this.internal.containsKey(key);
	}
	
	/**
	 * Rei̔jɎs郁\bhB
	 * <br/>
	 * <br/>
	 * DIReiŊǗĂ邷ׂĂdestroyMethodsB
	 * 
	 * @throws Throwable
	 */
	protected void finalize() throws Throwable {
		
		Set<String> keys = this.internal.keySet();
		
		for(Iterator<String> itr = keys.iterator(); itr.hasNext();) {
			String key = itr.next();
			BeanDef beanDef = this.internal.get(key);
			String destroyMethod = beanDef.getDestroyMethod();
			Object obj = beanDef.getCacheStrategy().getCache();
			if(destroyMethod != null && !destroyMethod.equals("")) {
				// destroyMethods
				ReflectionUtil.execute(obj, destroyMethod, null);
			}
		}
		super.finalize();
	}
	
	public void addContainer(IceryaContainer includeContainer) {
		this.includeContainer.add(includeContainer);
	}
}
