/*
 * Decompiled with CFR 0.152.
 */
package org.arefgard.icerya.container.strategy.injection.impl;

import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.arefgard.icerya.container.core.BeanCreateException;
import org.arefgard.icerya.container.core.ContainerException;
import org.arefgard.icerya.container.core.IceryaContainer;
import org.arefgard.icerya.container.core.def.BeanDef;
import org.arefgard.icerya.container.core.def.PropertyDef;
import org.arefgard.icerya.container.core.def.ReferenceResourceDef;
import org.arefgard.icerya.container.core.def.ResourceDef;
import org.arefgard.icerya.container.core.def.ValueResourceDef;
import org.arefgard.icerya.container.strategy.injection.InjectionStrategy;
import org.arefgard.icerya.container.util.ReflectionUtil;

public class SetterInjectionStrategy
extends InjectionStrategy {
    private static final Log log = LogFactory.getLog(SetterInjectionStrategy.class);

    public void inject(BeanDef beanDef) throws ContainerException {
        Map<String, PropertyDef> prop = beanDef.getProperties();
        IceryaContainer container = beanDef.getContainer();
        if (this.injectObject == null) {
            if (beanDef == null) {
                log.error((Object)"Illegal BeanDef.");
                throw new ContainerException("Illegal Argument.");
            }
            String id = beanDef.getBeanId();
            Class cls = beanDef.getBeanClass();
            if (log.isDebugEnabled()) {
                log.debug((Object)("  id = " + id + ", className = " + cls.getName()));
            }
            String context = beanDef.getContext();
            try {
                this.injectObject = ReflectionUtil.generate(cls);
                if (context != null) {
                    this.injectObject = ReflectionUtil.convertObject(this.injectObject, context);
                }
            }
            catch (Exception e) {
                log.error((Object)"Bean creation failed.", (Throwable)e);
                throw new BeanCreateException("Bean creation failed.", e);
            }
        }
        try {
            if (prop.size() > 0) {
                for (String key : prop.keySet()) {
                    Object value = null;
                    PropertyDef propertyDef = prop.get(key);
                    ResourceDef resourceDef = propertyDef.getResourceDef();
                    if (resourceDef instanceof ValueResourceDef) {
                        ValueResourceDef valueDef = (ValueResourceDef)resourceDef;
                        value = valueDef.getValue();
                    } else if (resourceDef instanceof ReferenceResourceDef) {
                        ReferenceResourceDef refDef = (ReferenceResourceDef)resourceDef;
                        value = container.getBean(refDef.getRef());
                    }
                    ReflectionUtil.setProperty(this.injectObject, key, value);
                }
            }
        }
        catch (Exception e) {
            log.error((Object)"Bean creation failed.", (Throwable)e);
            throw new BeanCreateException("Bean creation failed.", e);
        }
        try {
            String initMethod = beanDef.getInitMethod();
            if (initMethod != null && !initMethod.equals("")) {
                ReflectionUtil.execute(this.injectObject, initMethod, null);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ContainerException("", e);
        }
    }
}

