/*
 * Decompiled with CFR 0.152.
 */
package org.arefgard.icerya.container.core;

import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.Set;
import org.arefgard.icerya.container.core.BeanDefinitionParseException;
import org.arefgard.icerya.container.core.BeanHandler;
import org.arefgard.icerya.container.core.ContainerException;
import org.arefgard.icerya.container.core.IceryaContainer;
import org.arefgard.icerya.container.core.def.BeanDef;
import org.arefgard.icerya.container.core.def.PropertyDef;
import org.arefgard.icerya.container.core.def.ReferenceResourceDef;
import org.arefgard.icerya.container.core.def.ValueResourceDef;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class XmlBeanDefinitionReader {
    private IceryaContainer container;

    public XmlBeanDefinitionReader(IceryaContainer container) {
        this.container = container;
    }

    public void parse(String path) throws ContainerException {
        InputStream is = null;
        ByteArrayOutputStream os = null;
        String head = null;
        try {
            try {
                is = ClassLoader.getSystemResourceAsStream(path);
                if (is == null) {
                    path.getClass().getClassLoader().getResourceAsStream(path);
                }
                os = new ByteArrayOutputStream();
                int len = 0;
                byte[] buf = new byte[4096];
                len = is.read(buf);
                os.write(buf, 0, len);
                head = os.toString();
            }
            catch (Exception e) {
                throw new BeanDefinitionParseException(e);
            }
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (Exception exception) {}
            }
            if (os != null) {
                try {
                    os.close();
                }
                catch (Exception exception) {}
            }
        }
        if (head == null) {
            throw new BeanDefinitionParseException();
        }
        if (head.indexOf("<container") <= 0) {
            throw new BeanDefinitionParseException();
        }
        XMLReader reader = null;
        try {
            reader = XMLReaderFactory.createXMLReader();
        }
        catch (SAXException e) {
            throw new BeanDefinitionParseException("Creation XMLReader failed.", e);
        }
        reader.setContentHandler(new BeanHandler(this.container));
        is = ClassLoader.getSystemResourceAsStream(path);
        if (is == null) {
            is = this.getClass().getClassLoader().getResourceAsStream(path);
        }
        try {
            try {
                reader.parse(new InputSource(is));
            }
            catch (FileNotFoundException e) {
                throw new BeanDefinitionParseException("Bean Definition File Parsing failed.", e);
            }
            catch (IOException e) {
                throw new BeanDefinitionParseException("Bean Definition File Parsing failed.", e);
            }
            catch (SAXException e) {
                throw new BeanDefinitionParseException("Bean Definition File Parsing failed.", e);
            }
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (Exception exception) {}
        }
        Map<String, BeanDef> beanMap = this.container.getAllBeanDef();
        Set<String> keys1 = beanMap.keySet();
        for (String key1 : keys1) {
            BeanDef beanDef = beanMap.get(key1);
            Map<String, PropertyDef> properties = beanDef.getProperties();
            Set<String> keys2 = properties.keySet();
            for (String key2 : keys2) {
                PropertyDef propertyDef = beanDef.getProperty(key2);
                if (beanMap.containsKey(key2)) {
                    ReferenceResourceDef refDef = new ReferenceResourceDef((String)((ValueResourceDef)propertyDef.getResourceDef()).getValue());
                    propertyDef.setResourceDef(refDef);
                    propertyDef.setType(this.container.getBean(refDef.getRef()).getClass());
                    continue;
                }
                ValueResourceDef resourceDef = (ValueResourceDef)propertyDef.getResourceDef();
                Class cls = beanDef.getBeanClass();
                String type = null;
                Field[] fields = cls.getDeclaredFields();
                int len = fields.length;
                int i = 0;
                while (i < len) {
                    if (fields[i].getName().equals(key2)) {
                        propertyDef.setType(fields[i].getType());
                        type = fields[i].getType().getName();
                        break;
                    }
                    ++i;
                }
                String value = (String)resourceDef.getValue();
                if (value.startsWith("\"") && value.endsWith("\"")) {
                    resourceDef.setValue(value.substring(1, value.length() - 1));
                    continue;
                }
                if (type.equals("byte") || type.equals("java.lang.Byte")) {
                    resourceDef.setValue(new Byte(value));
                    continue;
                }
                if (type.equals("short") || type.equals("java.lang.Short")) {
                    resourceDef.setValue(new Short(value));
                    continue;
                }
                if (type.equals("int") || type.equals("java.lang.Integer")) {
                    resourceDef.setValue(new Integer(value));
                    continue;
                }
                if (type.equals("long") || type.equals("java.lang.Long")) {
                    resourceDef.setValue(new Long(value));
                    continue;
                }
                if (type.equals("float") || type.equals("java.lang.Float")) {
                    resourceDef.setValue(new Float(value));
                    continue;
                }
                if (type.equals("double") || type.equals("java.lang.Double")) {
                    resourceDef.setValue(new Double(value));
                    continue;
                }
                if (!type.equals("char") && !type.equals("java.lang.Character")) continue;
                resourceDef.setValue(new Character(value.toCharArray()[0]));
            }
        }
    }
}

