package org.arefgard.icerya.flow.core;

import static org.junit.Assert.assertEquals;

import org.arefgard.icerya.flow.core.UsecaseExpression;
import org.junit.Test;


public class UsecaseExpressionTest {
	@Test
	public void evaluateBooleanStringEqual() {
		UsecaseExpression expression1 = new UsecaseExpression("expr=\"+\"");
		expression1.addArg("expr", "+");
		boolean result1 = expression1.evaluateBoolean();
		assertEquals(true, result1);
		UsecaseExpression expression2 = new UsecaseExpression("expr=\"+\"");
		expression2.addArg("expr", "-");
		boolean result2 = expression2.evaluateBoolean();
		assertEquals(false, result2);
	}
	
	@Test
	public void evaluateBooleanStringNotEqual() {
		UsecaseExpression expression1 = new UsecaseExpression("expr!=\"-\"");
		expression1.addArg("expr", "+");
		boolean result1 = expression1.evaluateBoolean();
		assertEquals(true, result1);
		UsecaseExpression expression2 = new UsecaseExpression("expr!=\"-\"");
		expression2.addArg("expr", "-");
		boolean result2 = expression2.evaluateBoolean();
		assertEquals(false, result2);
	}

	@Test
	public void evaluateBooleanIntEquals() {
		UsecaseExpression expression1 = new UsecaseExpression("value=10");
		expression1.addArg("value", 10);
		boolean result1 = expression1.evaluateBoolean();
		assertEquals(true, result1);
		UsecaseExpression expression2 = new UsecaseExpression("value=10");
		expression2.addArg("value", 50);
		boolean result2 = expression2.evaluateBoolean();
		assertEquals(false, result2);
		UsecaseExpression expression3 = new UsecaseExpression("value1=value2");
		expression3.addArg("value1", 35);
		expression3.addArg("value2", 35);
		boolean result3 = expression3.evaluateBoolean();
		assertEquals(true, result3);
		UsecaseExpression expression4 = new UsecaseExpression("value1=value2");
		expression4.addArg("value1", 35);
		expression4.addArg("value2", 30);
		boolean result4 = expression4.evaluateBoolean();
		assertEquals(false, result4);
	}
	
	@Test
	public void evaluateBooleanIntNotEquals() {
		UsecaseExpression expression1 = new UsecaseExpression("value!=10");
		expression1.addArg("value", 50);
		boolean result1 = expression1.evaluateBoolean();
		assertEquals(true, result1);
		UsecaseExpression expression2 = new UsecaseExpression("value!=10");
		expression2.addArg("value", 10);
		boolean result2 = expression2.evaluateBoolean();
		assertEquals(false, result2);
		UsecaseExpression expression3 = new UsecaseExpression("value1!=value2");
		expression3.addArg("value1", 20);
		expression3.addArg("value2", 28);
		boolean result3 = expression3.evaluateBoolean();
		assertEquals(true, result3);
		UsecaseExpression expression4 = new UsecaseExpression("value1!=value2");
		expression4.addArg("value1", 55);
		expression4.addArg("value2", 55);
		boolean result4 = expression4.evaluateBoolean();
		assertEquals(false, result4);
	}
	
	@Test
	public void evaluateBooleanIntLessThan() {
		UsecaseExpression expression1 = new UsecaseExpression("value<10");
		expression1.addArg("value", 5);
		boolean result1 = expression1.evaluateBoolean();
		assertEquals(true, result1);
		UsecaseExpression expression2 = new UsecaseExpression("value<10");
		expression2.addArg("value", 11);
		boolean result2 = expression2.evaluateBoolean();
		assertEquals(false, result2);
		UsecaseExpression expression3 = new UsecaseExpression("value<10");
		expression3.addArg("value", 10);
		boolean result3 = expression3.evaluateBoolean();
		assertEquals(false, result3);
		UsecaseExpression expression4 = new UsecaseExpression("value1<value2");
		expression4.addArg("value1", 100);
		expression4.addArg("value2", 250);
		boolean result4 = expression4.evaluateBoolean();
		assertEquals(true, result4);
		UsecaseExpression expression5 = new UsecaseExpression("value1<value2");
		expression5.addArg("value1", 350);
		expression5.addArg("value2", 11);
		boolean result5 = expression5.evaluateBoolean();
		assertEquals(false, result5);
		UsecaseExpression expression6 = new UsecaseExpression("value1<value2");
		expression6.addArg("value1", 48);
		expression6.addArg("value2", 48);
		boolean result6 = expression6.evaluateBoolean();
		assertEquals(false, result6);
	}
	
	@Test
	public void evaluateBooleanIntLessThanEqual() {
		UsecaseExpression expression1 = new UsecaseExpression("value<=10");
		expression1.addArg("value", 5);
		boolean result1 = expression1.evaluateBoolean();
		assertEquals(true, result1);
		UsecaseExpression expression2 = new UsecaseExpression("value<=10");
		expression2.addArg("value", 11);
		boolean result2 = expression2.evaluateBoolean();
		assertEquals(false, result2);
		UsecaseExpression expression3 = new UsecaseExpression("value<=10");
		expression3.addArg("value", 10);
		boolean result3 = expression3.evaluateBoolean();
		assertEquals(true, result3);
		UsecaseExpression expression4 = new UsecaseExpression("value1<=value2");
		expression4.addArg("value1", 100);
		expression4.addArg("value2", 250);
		boolean result4 = expression4.evaluateBoolean();
		assertEquals(true, result4);
		UsecaseExpression expression5 = new UsecaseExpression("value1<=value2");
		expression5.addArg("value1", 350);
		expression5.addArg("value2", 11);
		boolean result5 = expression5.evaluateBoolean();
		assertEquals(false, result5);
		UsecaseExpression expression6 = new UsecaseExpression("value1<=value2");
		expression6.addArg("value1", 48);
		expression6.addArg("value2", 48);
		boolean result6 = expression6.evaluateBoolean();
		assertEquals(true, result6);
	}
	
	@Test
	public void evaluateBooleanIntGreaterThan() {
		UsecaseExpression expression1 = new UsecaseExpression("value>10");
		expression1.addArg("value", 15);
		boolean result1 = expression1.evaluateBoolean();
		assertEquals(true, result1);
		UsecaseExpression expression2 = new UsecaseExpression("value>10");
		expression2.addArg("value", 4);
		boolean result2 = expression2.evaluateBoolean();
		assertEquals(false, result2);
		UsecaseExpression expression3 = new UsecaseExpression("value>10");
		expression3.addArg("value", 10);
		boolean result3 = expression3.evaluateBoolean();
		assertEquals(false, result3);
		UsecaseExpression expression4 = new UsecaseExpression("value1>value2");
		expression4.addArg("value1", 250);
		expression4.addArg("value2", 100);
		boolean result4 = expression4.evaluateBoolean();
		assertEquals(true, result4);
		UsecaseExpression expression5 = new UsecaseExpression("value1>value2");
		expression5.addArg("value1", 11);
		expression5.addArg("value2", 350);
		boolean result5 = expression5.evaluateBoolean();
		assertEquals(false, result5);
		UsecaseExpression expression6 = new UsecaseExpression("value1>value2");
		expression6.addArg("value1", 48);
		expression6.addArg("value2", 48);
		boolean result6 = expression6.evaluateBoolean();
		assertEquals(false, result6);
	}
	
	@Test
	public void evaluateBooleanIntGreaterThanEqual() {
		UsecaseExpression expression1 = new UsecaseExpression("value>=10");
		expression1.addArg("value", 15);
		boolean result1 = expression1.evaluateBoolean();
		assertEquals(true, result1);
		UsecaseExpression expression2 = new UsecaseExpression("value>=10");
		expression2.addArg("value", 4);
		boolean result2 = expression2.evaluateBoolean();
		assertEquals(false, result2);
		UsecaseExpression expression3 = new UsecaseExpression("value>=10");
		expression3.addArg("value", 10);
		boolean result3 = expression3.evaluateBoolean();
		assertEquals(true, result3);
		UsecaseExpression expression4 = new UsecaseExpression("value1>=value2");
		expression4.addArg("value1", 250);
		expression4.addArg("value2", 100);
		boolean result4 = expression4.evaluateBoolean();
		assertEquals(true, result4);
		UsecaseExpression expression5 = new UsecaseExpression("value1>=value2");
		expression5.addArg("value1", 11);
		expression5.addArg("value2", 350);
		boolean result5 = expression5.evaluateBoolean();
		assertEquals(false, result5);
		UsecaseExpression expression6 = new UsecaseExpression("value1>=value2");
		expression6.addArg("value1", 48);
		expression6.addArg("value2", 48);
		boolean result6 = expression6.evaluateBoolean();
		assertEquals(true, result6);
	}
	
	@Test
	public void evaluateBooleanLongEquals() {
		UsecaseExpression expression1 = new UsecaseExpression("value=10");
		expression1.addArg("value", 10L);
		boolean result1 = expression1.evaluateBoolean();
		assertEquals(true, result1);
		UsecaseExpression expression2 = new UsecaseExpression("value=10");
		expression2.addArg("value", 50L);
		boolean result2 = expression2.evaluateBoolean();
		assertEquals(false, result2);
		UsecaseExpression expression3 = new UsecaseExpression("value1=value2");
		expression3.addArg("value1", 35L);
		expression3.addArg("value2", 35L);
		boolean result3 = expression3.evaluateBoolean();
		assertEquals(true, result3);
		UsecaseExpression expression4 = new UsecaseExpression("value1=value2");
		expression4.addArg("value1", 35L);
		expression4.addArg("value2", 30L);
		boolean result4 = expression4.evaluateBoolean();
		assertEquals(false, result4);
	}
	
	@Test
	public void evaluateBooleanLongNotEquals() {
		UsecaseExpression expression1 = new UsecaseExpression("value!=10");
		expression1.addArg("value", 50L);
		boolean result1 = expression1.evaluateBoolean();
		assertEquals(true, result1);
		UsecaseExpression expression2 = new UsecaseExpression("value!=10");
		expression2.addArg("value", 10L);
		boolean result2 = expression2.evaluateBoolean();
		assertEquals(false, result2);
		UsecaseExpression expression3 = new UsecaseExpression("value1!=value2");
		expression3.addArg("value1", 20L);
		expression3.addArg("value2", 28L);
		boolean result3 = expression3.evaluateBoolean();
		assertEquals(true, result3);
		UsecaseExpression expression4 = new UsecaseExpression("value1!=value2");
		expression4.addArg("value1", 55L);
		expression4.addArg("value2", 55L);
		boolean result4 = expression4.evaluateBoolean();
		assertEquals(false, result4);
	}
	
	@Test
	public void evaluateBooleanLongLessThan() {
		UsecaseExpression expression1 = new UsecaseExpression("value<10");
		expression1.addArg("value", 5L);
		boolean result1 = expression1.evaluateBoolean();
		assertEquals(true, result1);
		UsecaseExpression expression2 = new UsecaseExpression("value<10");
		expression2.addArg("value", 11L);
		boolean result2 = expression2.evaluateBoolean();
		assertEquals(false, result2);
		UsecaseExpression expression3 = new UsecaseExpression("value<10");
		expression3.addArg("value", 10L);
		boolean result3 = expression3.evaluateBoolean();
		assertEquals(false, result3);
		UsecaseExpression expression4 = new UsecaseExpression("value1<value2");
		expression4.addArg("value1", 100L);
		expression4.addArg("value2", 250L);
		boolean result4 = expression4.evaluateBoolean();
		assertEquals(true, result4);
		UsecaseExpression expression5 = new UsecaseExpression("value1<value2");
		expression5.addArg("value1", 350L);
		expression5.addArg("value2", 11L);
		boolean result5 = expression5.evaluateBoolean();
		assertEquals(false, result5);
		UsecaseExpression expression6 = new UsecaseExpression("value1<value2");
		expression6.addArg("value1", 48L);
		expression6.addArg("value2", 48L);
		boolean result6 = expression6.evaluateBoolean();
		assertEquals(false, result6);
	}
	
	@Test
	public void evaluateBooleanLongLessThanEqual() {
		UsecaseExpression expression1 = new UsecaseExpression("value<=10");
		expression1.addArg("value", 5L);
		boolean result1 = expression1.evaluateBoolean();
		assertEquals(true, result1);
		UsecaseExpression expression2 = new UsecaseExpression("value<=10");
		expression2.addArg("value", 11L);
		boolean result2 = expression2.evaluateBoolean();
		assertEquals(false, result2);
		UsecaseExpression expression3 = new UsecaseExpression("value<=10");
		expression3.addArg("value", 10L);
		boolean result3 = expression3.evaluateBoolean();
		assertEquals(true, result3);
		UsecaseExpression expression4 = new UsecaseExpression("value1<=value2");
		expression4.addArg("value1", 100L);
		expression4.addArg("value2", 250L);
		boolean result4 = expression4.evaluateBoolean();
		assertEquals(true, result4);
		UsecaseExpression expression5 = new UsecaseExpression("value1<=value2");
		expression5.addArg("value1", 350L);
		expression5.addArg("value2", 11L);
		boolean result5 = expression5.evaluateBoolean();
		assertEquals(false, result5);
		UsecaseExpression expression6 = new UsecaseExpression("value1<=value2");
		expression6.addArg("value1", 48L);
		expression6.addArg("value2", 48L);
		boolean result6 = expression6.evaluateBoolean();
		assertEquals(true, result6);
	}
	
	@Test
	public void evaluateBooleanLongGreaterThan() {
		UsecaseExpression expression1 = new UsecaseExpression("value>10");
		expression1.addArg("value", 13L);
		boolean result1 = expression1.evaluateBoolean();
		assertEquals(true, result1);
		UsecaseExpression expression2 = new UsecaseExpression("value>10");
		expression2.addArg("value", 4L);
		boolean result2 = expression2.evaluateBoolean();
		assertEquals(false, result2);
		UsecaseExpression expression3 = new UsecaseExpression("value>10");
		expression3.addArg("value", 10L);
		boolean result3 = expression3.evaluateBoolean();
		assertEquals(false, result3);
		UsecaseExpression expression4 = new UsecaseExpression("value1>value2");
		expression4.addArg("value1", 250L);
		expression4.addArg("value2", 100L);
		boolean result4 = expression4.evaluateBoolean();
		assertEquals(true, result4);
		UsecaseExpression expression5 = new UsecaseExpression("value1>value2");
		expression5.addArg("value1", 11L);
		expression5.addArg("value2", 350L);
		boolean result5 = expression5.evaluateBoolean();
		assertEquals(false, result5);
		UsecaseExpression expression6 = new UsecaseExpression("value1>value2");
		expression6.addArg("value1", 48L);
		expression6.addArg("value2", 48L);
		boolean result6 = expression6.evaluateBoolean();
		assertEquals(false, result6);
	}
	
	@Test
	public void evaluateBooleanLongGreaterThanEqual() {
		UsecaseExpression expression1 = new UsecaseExpression("value>=10");
		expression1.addArg("value", 15L);
		boolean result1 = expression1.evaluateBoolean();
		assertEquals(true, result1);
		UsecaseExpression expression2 = new UsecaseExpression("value>=10");
		expression2.addArg("value", 4L);
		boolean result2 = expression2.evaluateBoolean();
		assertEquals(false, result2);
		UsecaseExpression expression3 = new UsecaseExpression("value>=10");
		expression3.addArg("value", 10L);
		boolean result3 = expression3.evaluateBoolean();
		assertEquals(true, result3);
		UsecaseExpression expression4 = new UsecaseExpression("value1>=value2");
		expression4.addArg("value1", 250L);
		expression4.addArg("value2", 100L);
		boolean result4 = expression4.evaluateBoolean();
		assertEquals(true, result4);
		UsecaseExpression expression5 = new UsecaseExpression("value1>=value2");
		expression5.addArg("value1", 11L);
		expression5.addArg("value2", 350L);
		boolean result5 = expression5.evaluateBoolean();
		assertEquals(false, result5);
		UsecaseExpression expression6 = new UsecaseExpression("value1>=value2");
		expression6.addArg("value1", 48L);
		expression6.addArg("value2", 48L);
		boolean result6 = expression6.evaluateBoolean();
		assertEquals(true, result6);
	}
	
	@Test
	public void evaluateBooleanLongGreaterThanEqualEqual() {
		UsecaseExpression expression1 = new UsecaseExpression("value>=10");
		expression1.addArg("value", 15L);
		boolean result1 = expression1.evaluateBoolean();
		assertEquals(true, result1);
		UsecaseExpression expression2 = new UsecaseExpression("value>=10");
		expression2.addArg("value", 4L);
		boolean result2 = expression2.evaluateBoolean();
		assertEquals(false, result2);
		UsecaseExpression expression3 = new UsecaseExpression("value>=10");
		expression3.addArg("value", 10L);
		boolean result3 = expression3.evaluateBoolean();
		assertEquals(true, result3);
		UsecaseExpression expression4 = new UsecaseExpression("value1>=value2");
		expression4.addArg("value1", 250L);
		expression4.addArg("value2", 100L);
		boolean result4 = expression4.evaluateBoolean();
		assertEquals(true, result4);
		UsecaseExpression expression5 = new UsecaseExpression("value1>=value2");
		expression5.addArg("value1", 11L);
		expression5.addArg("value2", 350L);
		boolean result5 = expression5.evaluateBoolean();
		assertEquals(false, result5);
		UsecaseExpression expression6 = new UsecaseExpression("value1>=value2");
		expression6.addArg("value1", 48L);
		expression6.addArg("value2", 48L);
		boolean result6 = expression6.evaluateBoolean();
		assertEquals(true, result6);
	}
}
