package org.arefgard.icerya.flow.node;

import java.util.Map;

import org.arefgard.icerya.flow.core.UsecaseExpression;

/**
 * <while>m[hB
 * 
 * @author Takashi Yamashina
 * @since 1.0.0
 *
 */
public class WhileNode extends Node {
	private String flow;
	private String nextTo;
	private String expr;
	
	public String getFlow() {
		return flow;
	}

	public void setFlow(String flow) {
		this.flow = flow;
	}

	public String getNextTo() {
		return nextTo;
	}

	public void setNextTo(String nextTo) {
		this.nextTo = nextTo;
	}

	public String getExpr() {
		return expr;
	}

	public void setExpr(String expr) {
		this.expr = expr;
	}
	
	/**
	 * whilesB
	 * 
	 * @param params ̓p[^
	 * @return Jڐ
	 * @throws Exception whilesɗOꍇ
	 */
	public String doWhile(Map<String, Object> params) throws Exception {
		Flow flow = this.getParent().getParent().getFlow(this.flow);
		UsecaseExpression expression = new UsecaseExpression(expr);
		expression.setArgs(params);
		while(expression.evaluateBoolean()) {
			flow.execute(params);
		}
		return this.nextTo;
	}
	
}
