package org.arefgard.icerya.flow.node;

import java.util.Date;
import java.util.List;
import java.util.Random;

/**
 * <sync>m[hB
 * 
 * @author Takashi Yamashina
 * @since 1.0.0
 *
 */
public class SyncNode extends Node {
	private List<String> flows = new java.util.ArrayList<String>();
	private String nextTo;
	public void addFlow(String flow) {
		this.flows.add(flow);
	}
	
	public String getFlow(int index) {
		return this.flows.get(index);
	}

	public String getNextTo() {
		return nextTo;
	}

	public void setNextTo(String nextTo) {
		this.nextTo = nextTo;
	}
	
	/**
	 * ꂽTu[XP[XsB
	 * <br/>
	 * <br/>
	 * ꂼ̃Tu[XP[X͈قȂXbhœ̃XbhO[vŎsB
	 * 
	 * @return Jڐ
	 */
	public String execute() {
		// create thread
		Random random = new Random(new Date().getTime());
		ThreadGroup group = new ThreadGroup("Usecase Flow Thread Group:" + this.getName() + random.nextLong());
		Thread[] threads = new Thread[flows.size()];
		for(int i = 0, n = flows.size();i < n; i++) {
			threads[i] = new Thread(group, this.getParent().getParent().getFlow(flows.get(i)));
			threads[i].start();
		}
		
		// ׂĂ̏I܂ő҂
		while(true) {
			if(group.activeCount() == 0) {
				break;
			}
		}
		return this.nextTo;
	}
}

