/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.util;

import java.lang.reflect.Method;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.seasar.framework.exception.ParserConfigurationRuntimeException;
import org.seasar.framework.exception.SAXRuntimeException;
import org.xml.sax.SAXException;

public final class SAXParserFactoryUtil {
    public static final String XERCES_XINCLUDE_FUTURE = "http://apache.org/xml/features/xinclude";

    private SAXParserFactoryUtil() {
    }

    public static SAXParserFactory newInstance() {
        return SAXParserFactory.newInstance();
    }

    public static SAXParser newSAXParser() {
        return SAXParserFactoryUtil.newSAXParser(SAXParserFactoryUtil.newInstance());
    }

    public static SAXParser newSAXParser(SAXParserFactory factory) {
        try {
            return factory.newSAXParser();
        }
        catch (ParserConfigurationException e) {
            throw new ParserConfigurationRuntimeException(e);
        }
        catch (SAXException e) {
            throw new SAXRuntimeException(e);
        }
    }

    public static boolean setXIncludeAware(SAXParserFactory spf, boolean state) {
        try {
            Method method = spf.getClass().getMethod("setXIncludeAware", Boolean.TYPE);
            method.invoke((Object)spf, state);
            return true;
        }
        catch (Exception ignore) {
            try {
                spf.setFeature(XERCES_XINCLUDE_FUTURE, state);
                return true;
            }
            catch (Exception exception) {
                return false;
            }
        }
    }
}

