/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.util;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class ResourceBundleUtil {
    private ResourceBundleUtil() {
    }

    public static final ResourceBundle getBundle(String name, Locale locale) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        try {
            return ResourceBundle.getBundle(name, locale);
        }
        catch (MissingResourceException ignore) {
            return null;
        }
    }

    public static final ResourceBundle getBundle(String name, Locale locale, ClassLoader classLoader) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        try {
            return ResourceBundle.getBundle(name, locale, classLoader);
        }
        catch (MissingResourceException ignore) {
            return null;
        }
    }

    public static final Map convertMap(ResourceBundle bundle) {
        HashMap<String, String> ret = new HashMap<String, String>();
        Enumeration<String> e = bundle.getKeys();
        while (e.hasMoreElements()) {
            String key = e.nextElement();
            String value = bundle.getString(key);
            ret.put(key, value);
        }
        return ret;
    }

    public static final Map convertMap(String name, Locale locale) {
        ResourceBundle bundle = ResourceBundleUtil.getBundle(name, locale);
        return ResourceBundleUtil.convertMap(bundle);
    }
}

