/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.container.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.seasar.framework.container.MetaDef;
import org.seasar.framework.container.S2Container;

public final class MetaDefSupport {
    private List metaDefs = Collections.synchronizedList(new ArrayList());
    private S2Container container;

    public MetaDefSupport() {
    }

    public MetaDefSupport(S2Container container) {
        this.setContainer(container);
    }

    public void addMetaDef(MetaDef metaDef) {
        if (this.container != null) {
            metaDef.setContainer(this.container);
        }
        this.metaDefs.add(metaDef);
    }

    public int getMetaDefSize() {
        return this.metaDefs.size();
    }

    public MetaDef getMetaDef(int index) {
        return (MetaDef)this.metaDefs.get(index);
    }

    public MetaDef getMetaDef(String name) {
        for (int i = 0; i < this.getMetaDefSize(); ++i) {
            MetaDef metaDef = this.getMetaDef(i);
            if ((name != null || metaDef.getName() != null) && (name == null || !name.equalsIgnoreCase(metaDef.getName()))) continue;
            return metaDef;
        }
        return null;
    }

    public MetaDef[] getMetaDefs(String name) {
        ArrayList<MetaDef> defs = new ArrayList<MetaDef>();
        for (int i = 0; i < this.getMetaDefSize(); ++i) {
            MetaDef metaDef = this.getMetaDef(i);
            if ((name != null || metaDef.getName() != null) && (name == null || !name.equalsIgnoreCase(metaDef.getName()))) continue;
            defs.add(metaDef);
        }
        return defs.toArray(new MetaDef[defs.size()]);
    }

    public void setContainer(S2Container container) {
        this.container = container;
        for (int i = 0; i < this.getMetaDefSize(); ++i) {
            this.getMetaDef(i).setContainer(container);
        }
    }
}

