/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.container.util;

import java.util.HashMap;
import org.seasar.framework.aop.Aspect;
import org.seasar.framework.aop.InterType;
import org.seasar.framework.aop.proxy.AopProxy;
import org.seasar.framework.container.ComponentDef;

public class AopProxyUtil {
    protected AopProxyUtil() {
    }

    public static Class getConcreteClass(ComponentDef componentDef) {
        if (componentDef.getAspectDefSize() == 0 && componentDef.getInterTypeDefSize() == 0) {
            return componentDef.getComponentClass();
        }
        HashMap<String, ComponentDef> parameters = new HashMap<String, ComponentDef>();
        parameters.put("componentDef", componentDef);
        AopProxy proxy = new AopProxy(componentDef.getComponentClass(), AopProxyUtil.getAspects(componentDef), AopProxyUtil.getInterTypes(componentDef), parameters);
        return proxy.getEnhancedClass();
    }

    protected static Aspect[] getAspects(ComponentDef componentDef) {
        int size = componentDef.getAspectDefSize();
        Aspect[] aspects = new Aspect[size];
        for (int i = 0; i < size; ++i) {
            aspects[i] = componentDef.getAspectDef(i).getAspect();
        }
        return aspects;
    }

    protected static InterType[] getInterTypes(ComponentDef componentDef) {
        int size = componentDef.getInterTypeDefSize();
        InterType[] interTypes = new InterType[size];
        for (int i = 0; i < size; ++i) {
            interTypes[i] = componentDef.getInterTypeDef(i).getInterType();
        }
        return interTypes;
    }
}

