/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.container.ognl;

import java.util.Map;
import org.seasar.framework.container.Expression;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.util.OgnlUtil;

public class OgnlExpression
implements Expression {
    protected String sourceName;
    protected int lineNumber;
    protected String source;
    protected Object parsedExpression;

    public OgnlExpression(String source) {
        this(null, 0, source);
    }

    public OgnlExpression(String sourceName, int lineNumber, String source) {
        this.sourceName = sourceName;
        this.lineNumber = lineNumber;
        this.source = source;
        this.parsedExpression = OgnlUtil.parseExpression(source, sourceName, lineNumber);
    }

    public Object evaluate(S2Container container, Map context) {
        return OgnlUtil.getValue(this.parsedExpression, context, container, this.sourceName, this.lineNumber);
    }

    public String getSource() {
        return this.source;
    }

    public String getSourceName() {
        return this.sourceName;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }
}

