/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.container.cooldeploy;

import java.io.File;
import java.io.FilenameFilter;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarFile;
import org.seasar.framework.container.ComponentCreator;
import org.seasar.framework.container.ComponentDef;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.util.S2ContainerUtil;
import org.seasar.framework.convention.NamingConvention;
import org.seasar.framework.util.ClassLoaderUtil;
import org.seasar.framework.util.ClassTraversal;
import org.seasar.framework.util.ClassUtil;
import org.seasar.framework.util.JarFileUtil;
import org.seasar.framework.util.ResourceUtil;
import org.seasar.framework.util.StringUtil;
import org.seasar.framework.util.URLUtil;
import org.seasar.framework.util.ZipFileUtil;

public class CoolComponentAutoRegister
implements ClassTraversal.ClassHandler {
    public static final String INIT_METHOD = "registerAll";
    public static final String container_BINDING = "bindingType=must";
    private S2Container container;
    private Map strategies = new HashMap();
    private ComponentCreator[] creators;
    private NamingConvention namingConvention;
    private Set registerdClasses = new HashSet();

    public CoolComponentAutoRegister() {
        this.addStrategy("file", new FileSystemStrategy());
        this.addStrategy("jar", new JarFileStrategy());
        this.addStrategy("zip", new ZipFileStrategy());
    }

    public S2Container getContainer() {
        return this.container;
    }

    public void setContainer(S2Container container) {
        this.container = container;
    }

    public Map getStrategies() {
        return this.strategies;
    }

    protected Strategy getStrategy(String protocol) {
        return (Strategy)this.strategies.get(URLUtil.toCanonicalProtocol(protocol));
    }

    protected void addStrategy(String protocol, Strategy strategy) {
        this.strategies.put(protocol, strategy);
    }

    public ComponentCreator[] getCreators() {
        return this.creators;
    }

    public void setCreators(ComponentCreator[] creators) {
        this.creators = creators;
    }

    public NamingConvention getNamingConvention() {
        return this.namingConvention;
    }

    public void setNamingConvention(NamingConvention namingConvention) {
        this.namingConvention = namingConvention;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerAll() {
        try {
            String[] rootPackageNames = this.namingConvention.getRootPackageNames();
            if (rootPackageNames != null) {
                for (int i = 0; i < rootPackageNames.length; ++i) {
                    String rootDir = rootPackageNames[i].replace('.', '/');
                    Iterator it = ClassLoaderUtil.getResources(rootDir);
                    while (it.hasNext()) {
                        URL url = (URL)it.next();
                        Strategy strategy = this.getStrategy(URLUtil.toCanonicalProtocol(url.getProtocol()));
                        strategy.registerAll(rootDir, url);
                    }
                }
                this.webSphereClassLoaderFix();
            }
        }
        finally {
            this.registerdClasses.clear();
        }
    }

    protected void webSphereClassLoaderFix() {
        URL url = ResourceUtil.getResourceNoException(this.getClass().getName().replace('.', '/') + ".class");
        if ("wsjar".equals(url.getProtocol())) {
            File s2JarFile = new File(JarFileUtil.toJarFile(url).getName());
            File libDir = s2JarFile.getParentFile();
            File[] jarFiles = libDir.listFiles(new FilenameFilter(){

                public boolean accept(File dir, String name) {
                    return name.endsWith(".jar");
                }
            });
            for (int i = 0; i < jarFiles.length; ++i) {
                JarFile jarFile = JarFileUtil.create(jarFiles[i]);
                ClassTraversal.forEach(jarFile, (ClassTraversal.ClassHandler)this);
            }
        }
    }

    public void processClass(String packageName, String shortClassName) {
        if (shortClassName.indexOf(36) != -1) {
            return;
        }
        String className = ClassUtil.concatName(packageName, shortClassName);
        if (!this.namingConvention.isTargetClassName(className)) {
            return;
        }
        Class clazz = ClassUtil.forName(className);
        if (this.container.getRoot().hasComponentDef(clazz)) {
            return;
        }
        ComponentDef cd = this.createComponentDef(clazz);
        if (cd == null) {
            return;
        }
        if (this.registerdClasses.contains(cd.getComponentClass())) {
            return;
        }
        this.container.getRoot().register(cd);
        this.registerdClasses.add(cd.getComponentClass());
        S2ContainerUtil.putRegisterLog(cd);
    }

    protected ComponentDef createComponentDef(Class componentClass) {
        for (int i = 0; i < this.creators.length; ++i) {
            ComponentCreator creator = this.creators[i];
            ComponentDef cd = creator.createComponentDef(componentClass);
            if (cd == null) continue;
            return cd;
        }
        return null;
    }

    protected class ZipFileStrategy
    implements Strategy {
        protected ZipFileStrategy() {
        }

        public void registerAll(String path, URL url) {
            JarFile jarFile = this.createJarFile(url);
            ClassTraversal.forEach(jarFile, (ClassTraversal.ClassHandler)CoolComponentAutoRegister.this);
        }

        protected JarFile createJarFile(URL url) {
            String jarFileName = ZipFileUtil.toZipFilePath(url);
            return JarFileUtil.create(new File(jarFileName));
        }
    }

    protected class JarFileStrategy
    implements Strategy {
        protected JarFileStrategy() {
        }

        public void registerAll(String path, URL url) {
            JarFile jarFile = this.createJarFile(url);
            ClassTraversal.forEach(jarFile, (ClassTraversal.ClassHandler)CoolComponentAutoRegister.this);
        }

        protected JarFile createJarFile(URL url) {
            return JarFileUtil.toJarFile(url);
        }
    }

    protected class FileSystemStrategy
    implements Strategy {
        protected FileSystemStrategy() {
        }

        public void registerAll(String path, URL url) {
            File rootDir = this.getRootDir(path, url);
            String[] rootPackageNames = CoolComponentAutoRegister.this.namingConvention.getRootPackageNames();
            for (int i = 0; i < rootPackageNames.length; ++i) {
                ClassTraversal.forEach(rootDir, rootPackageNames[i], CoolComponentAutoRegister.this);
            }
        }

        protected File getRootDir(String path, URL url) {
            File file = URLUtil.toFile(url);
            String[] names = StringUtil.split(path, "/");
            for (int i = 0; i < names.length; ++i) {
                file = file.getParentFile();
            }
            return file;
        }
    }

    protected static interface Strategy {
        public void registerAll(String var1, URL var2);
    }
}

