/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.autodetector.impl;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.JarFile;
import org.seasar.framework.autodetector.ClassAutoDetector;
import org.seasar.framework.util.ClassTraversal;
import org.seasar.framework.util.FileUtil;
import org.seasar.framework.util.JarFileUtil;
import org.seasar.framework.util.ResourceUtil;
import org.seasar.framework.util.StringUtil;
import org.seasar.framework.util.URLUtil;
import org.seasar.framework.util.ZipFileUtil;

public abstract class AbstractClassAutoDetector
implements ClassAutoDetector {
    private Map strategies = new HashMap();
    private List targetPackageNames = new ArrayList();

    public AbstractClassAutoDetector() {
        this.strategies.put("file", new FileSystemStrategy());
        this.strategies.put("jar", new JarFileStrategy());
        this.strategies.put("zip", new ZipFileStrategy());
    }

    public void addStrategy(String protocol, Strategy strategy) {
        this.strategies.put(protocol, strategy);
    }

    public Strategy getStrategy(String protocol) {
        return (Strategy)this.strategies.get(URLUtil.toCanonicalProtocol(protocol));
    }

    public void addTargetPackageName(String targetPackageName) {
        this.targetPackageNames.add(targetPackageName);
    }

    public int getTargetPackageNameSize() {
        return this.targetPackageNames.size();
    }

    public String getTargetPackageName(int index) {
        return (String)this.targetPackageNames.get(index);
    }

    protected class ZipFileStrategy
    implements Strategy {
        protected ZipFileStrategy() {
        }

        public String getBaseName(String packageName, URL url) {
            return this.createJarFile(url).getName();
        }

        public void detect(String packageName, URL url, ClassTraversal.ClassHandler handler) {
            JarFile jarFile = this.createJarFile(url);
            ClassTraversal.forEach(jarFile, handler);
        }

        protected JarFile createJarFile(URL url) {
            String jarFileName = ZipFileUtil.toZipFilePath(url);
            return JarFileUtil.create(new File(jarFileName));
        }
    }

    protected class JarFileStrategy
    implements Strategy {
        protected JarFileStrategy() {
        }

        public String getBaseName(String packageName, URL url) {
            return this.createJarFile(url).getName();
        }

        public void detect(String packageName, URL url, ClassTraversal.ClassHandler handler) {
            JarFile jarFile = this.createJarFile(url);
            ClassTraversal.forEach(jarFile, handler);
        }

        protected JarFile createJarFile(URL url) {
            return JarFileUtil.toJarFile(url);
        }
    }

    protected class FileSystemStrategy
    implements Strategy {
        protected FileSystemStrategy() {
        }

        public String getBaseName(String packageName, URL url) {
            File rootDir = this.getRootDir(packageName, url);
            return FileUtil.getCanonicalPath(rootDir);
        }

        public void detect(String packageName, URL url, ClassTraversal.ClassHandler handler) {
            File rootDir = this.getRootDir(packageName, url);
            ClassTraversal.forEach(rootDir, packageName, handler);
        }

        protected File getRootDir(String path, URL url) {
            File file = ResourceUtil.getFile(url);
            String[] names = StringUtil.split(path, ".");
            for (int i = 0; i < names.length; ++i) {
                file = file.getParentFile();
            }
            return file;
        }
    }

    protected static interface Strategy {
        public String getBaseName(String var1, URL var2);

        public void detect(String var1, URL var2, ClassTraversal.ClassHandler var3);
    }
}

