/*
 * Decompiled with CFR 0.152.
 */
package org.arefgard.icerya.container.util;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReflectionUtil {
    private static final String PREFIX_GET = "get";
    private static final String PREFIX_SET = "set";

    public static Object generate(String className) throws ClassNotFoundException {
        try {
            Class<?> clazz = Class.forName(className);
            if (clazz.getName().equals("byte") || clazz.getName().equals("java.lang.Byte")) {
                return new Byte(0);
            }
            if (clazz.getName().equals("short") || clazz.getName().equals("java.lang.Short")) {
                return new Short(0);
            }
            if (clazz.getName().equals("int") || clazz.getName().equals("java.lang.Integer")) {
                return new Integer(0);
            }
            if (clazz.getName().equals("long") || clazz.getName().equals("java.lang.Long")) {
                return new Long(0L);
            }
            if (clazz.getName().equals("float") || clazz.getName().equals("java.lang.Float")) {
                return new Float(0.0f);
            }
            if (clazz.getName().equals("double") || clazz.getName().equals("java.lang.Double")) {
                return new Double(0.0);
            }
            if (clazz.getName().equals("char") || clazz.getName().equals("java.lang.Character")) {
                return new Character('\u0000');
            }
            return clazz.newInstance();
        }
        catch (Exception e) {
            throw new ClassNotFoundException("Class[" + className + "] is not found.", e);
        }
    }

    public static void setProperty(Object obj, String property, Object value) throws Exception {
        Class<?> clazz = obj.getClass();
        StringBuffer methodName = new StringBuffer(PREFIX_SET);
        methodName.append(property.substring(0, 1).toUpperCase());
        methodName.append(property.substring(1));
        Method method = null;
        Method[] methods = clazz.getDeclaredMethods();
        int i = 0;
        int n = methods.length;
        while (i < n) {
            if (methods[i].getName().equals(methodName.toString())) {
                method = methods[i];
                break;
            }
            ++i;
        }
        method.invoke(obj, value);
    }

    public static Object getProperty(Object obj, String property) throws Exception {
        Class<?> clazz = obj.getClass();
        StringBuffer methodName = new StringBuffer(PREFIX_GET);
        methodName.append(property.substring(0, 1).toUpperCase());
        methodName.append(property.substring(1));
        Method method = clazz.getDeclaredMethod(methodName.toString(), new Class[0]);
        return method.invoke(obj, new Object[0]);
    }

    public static Object execute(Object obj, String methodName, List<Object> parameter) throws Exception {
        Class<?> clazz = obj.getClass();
        Method method = null;
        if (parameter == null) {
            method = clazz.getDeclaredMethod(methodName, null);
            method.setAccessible(true);
            return method.invoke(obj, null);
        }
        Object[] objList = parameter.toArray();
        Class[] classList = new Class[objList.length];
        int i = 0;
        while (i < objList.length) {
            classList[i] = objList[i].getClass();
            ++i;
        }
        method = clazz.getDeclaredMethod(methodName, classList);
        return method.invoke(obj, objList);
    }

    public static Object convertObject(Object obj, String fieldName, String value) throws Exception {
        Class<?> clazz = obj.getClass();
        Field field = clazz.getDeclaredField(fieldName);
        field.setAccessible(true);
        Class<?> type = field.getType();
        if (value.startsWith("\"") && value.endsWith("\"")) {
            return value.substring(1, value.length() - 1);
        }
        if (type.getName().equals("byte") || type.getName().equals("java.lang.Byte")) {
            return new Byte(value);
        }
        if (type.getName().equals("short") || type.getName().equals("java.lang.Short")) {
            return new Short(value);
        }
        if (type.getName().equals("int") || type.getName().equals("java.lang.Integer")) {
            return new Integer(value);
        }
        if (type.getName().equals("long") || type.getName().equals("java.lang.Long")) {
            return new Long(value);
        }
        if (type.getName().equals("float") || type.getName().equals("java.lang.Float")) {
            return new Float(value);
        }
        if (type.getName().equals("double") || type.getName().equals("java.lang.Double")) {
            return new Double(value);
        }
        if (type.getName().equals("char") || type.getName().equals("java.lang.Character")) {
            return new Character(value.toCharArray()[0]);
        }
        return value;
    }

    public static Object convertObject(Object obj, String value) throws Exception {
        Class<?> clazz = obj.getClass();
        if (value.startsWith("\"") && value.endsWith("\"")) {
            return value.substring(1, value.length() - 1);
        }
        if (clazz.getName().equals("byte") || clazz.getName().equals("java.lang.Byte")) {
            return new Byte(value);
        }
        if (clazz.getName().equals("short") || clazz.getName().equals("java.lang.Short")) {
            return new Short(value);
        }
        if (clazz.getName().equals("int") || clazz.getName().equals("java.lang.Integer")) {
            return new Integer(value);
        }
        if (clazz.getName().equals("long") || clazz.getName().equals("java.lang.Long")) {
            return new Long(value);
        }
        if (clazz.getName().equals("float") || clazz.getName().equals("java.lang.Float")) {
            return new Float(value);
        }
        if (clazz.getName().equals("double") || clazz.getName().equals("java.lang.Double")) {
            return new Double(value);
        }
        if (clazz.getName().equals("char") || clazz.getName().equals("java.lang.Character")) {
            return new Character(value.toCharArray()[0]);
        }
        return value;
    }
}

