/*
 * Decompiled with CFR 0.152.
 */
package org.arefgard.icerya.container.core;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.arefgard.icerya.container.core.BeanDefinitionParseException;
import org.arefgard.icerya.container.core.BeanHandler;
import org.arefgard.icerya.container.core.ContainerException;
import org.arefgard.icerya.container.core.IceryaContainer;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class XmlBeanDefinitionReader {
    private IceryaContainer container;

    public XmlBeanDefinitionReader(IceryaContainer container) {
        this.container = container;
    }

    public void parse(String path) throws ContainerException {
        XMLReader reader = null;
        try {
            reader = XMLReaderFactory.createXMLReader();
        }
        catch (SAXException e) {
            throw new BeanDefinitionParseException("Creation XMLReader failed.", e);
        }
        reader.setContentHandler(new BeanHandler(this.container));
        InputStream is = ClassLoader.getSystemResourceAsStream(path);
        if (is == null) {
            is = this.getClass().getClassLoader().getResourceAsStream(path);
        }
        try {
            try {
                reader.parse(new InputSource(is));
            }
            catch (FileNotFoundException e) {
                throw new BeanDefinitionParseException("Bean Definition File Parsing failed.", e);
            }
            catch (IOException e) {
                throw new BeanDefinitionParseException("Bean Definition File Parsing failed.", e);
            }
            catch (SAXException e) {
                throw new BeanDefinitionParseException("Bean Definition File Parsing failed.", e);
            }
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (Exception exception) {}
        }
    }
}

