#ifndef __STRING_H__
#define __STRING_H__

#include <types.h>
#include <vector.h>

class String : public Object {
public:
    String(void);
    String(const char* text);
    String(const char* text, uint32 len);
    String(const String& text);
    ~String(void);

    uint32  getLength(void) const {return Length;}
    char    operator[](uint32 i) const {return Text[i];}
    bool    operator==(const char* text) const;
    bool    operator==(const String& text) const;
    void    operator+=(const char c);
    String& operator=(const String& src);
    String  substring(uint32 start, uint32 len);
    void    trim(void);
    void    split(char seperator, Vector<String>& strings) const;

    operator char*(void) const {return Text;}

private:
    char*  Text;
    uint32 Length;

    uint32 calcLength(const char* text) const;
    void   copyFrom(const char* src, uint32 len);
    void   copyTo(char* dst, uint32 offset = 0);
    int    compare(const char* text) const;
};

#endif /* __STRING_H__ */
