#ifndef __SCREEN_H__
#define __SCREEN_H__

class Screen {
public:
    Screen(void);
    void clear(void);
    void putChar(int c);
    void printf(const char* format, ...);
    void moveBackward(void);
    void deleteChar(void);

    uint32 getCursorX(void) {return XPos;}
    uint32 getCursorY(void) {return YPos;}

private:
    enum {
        VIDEO     = 0xB8000,
        COLUMNS   = 80,
        LINES     = 24,
        ATTRIBUTE = 7,
    };
    volatile uint8* VRam;
    uint32 XPos, YPos;

    void scroll(void);
    void moveCursor(void);
};

extern Screen Console;

#endif /* __SCREEN_H__ */
