#include "memmgr.h"
#include "list.h"

void List::add(Object& object) {
    Node* node = new Node;
    if (node != 0) {
        node->Value = &object;
        node->Next = 0;
        node->Prev = Bottom;
        if (Bottom == 0) {
            Top = node;
        } else {
            Bottom->Next = node;
        }
        Bottom = node;
    }
}

void List::insert(uint32 i, Object& object) {
    Node* node = getNode(i);
    if (node == 0) {
        add(object);
    } else {
        Node* new_node = new Node;
        if (new_node != 0) {
            new_node->Value = &object;
            if (node->Prev != 0) {
                node->Prev->Next = new_node;
                new_node->Prev = node->Prev;
            } else {
                new_node->Prev = 0;
                Top = new_node;
            }
            new_node->Next  = node;
            node->Prev      = new_node;
        }
    }
}

void List::remove(Object& object) {
    Node* node = getNode(object);
    if (node != 0) {
        if (node->Prev == 0) {
            Top = node->Next;
        } else {
            node->Prev->Next = node->Next;
        }
        if (node->Next == 0) {
            Bottom = node->Prev;
        } else {
            node->Next->Prev = node->Prev;
        }
        delete node;
    }
}

Object* List::get(uint32 i) {
    Node* node = getNode(i);
    return (node != 0) ? node->Value : 0;
}

List::Node* List::getNode(Object& object) {
    Node* node = 0;
    for (node = Top; node != 0; node = node->Next) {
        if (&object == node->Value) break; 
    }
    return (node != 0) ? node : 0;
}

List::Node* List::getNode(uint32 i) {
    Node* node = Top;
    for (uint32 j = 0; j < i; j++) {
        if (node == 0) break;
        node = node->Next;
    }
    return node;
}

