#include "gdt.h"

Gdt* Gdt::Instance = 0;

Gdt* Gdt::getInstance(void) {
    if (Instance == 0) Instance = new Gdt();
    return Instance;
}

Gdt::Gdt(void) {
    Table.Limit  = Gdt::NUM * sizeof(GdtEntry) - 1;
    Table.Offset = (uint32)Entry;
    for (int i = 0; i < Gdt::NUM; i++) {
        set(i, 0, 0, 0);
    }

    set(NULL_S, 0, 0, 0);                       // for Null seg
    set(KERNEL_CS, 0, 0xFFFFF, KERNEL_CS_FLAG); // for Kernel code 
    set(KERNEL_DS, 0, 0xFFFFF, KERNEL_DS_FLAG); // for Kernel data 

    load();

    /* Change segments */
    asm("ljmp  %0, $1f; 1:" : : "i" (KERNEL_CS * sizeof(GdtEntry)));
    asm("mov  %0, %%ax" : : "i" (KERNEL_DS * sizeof(GdtEntry)));
    asm("mov  %ax, %ds");
    asm("mov  %ax, %es");
    asm("mov  %ax, %fs");
    asm("mov  %ax, %gs");
    asm("mov  %ax, %ss");
}

void Gdt::set(int index, uint32 segbase, uint32 limit, uint16 type) {
    GdtEntry& desc = Entry[index];

    desc.LimitLow   = limit & 0xFFFF;
    desc.LimitHi    = (limit >> 16) & 0xF;
    desc.SegBaseLow = segbase & 0xFFFF;
    desc.SegBaseMid = (segbase >> 16) & 0xFF;
    desc.SegBaseHi  = (segbase >> 24) & 0xFF;
    desc.TypeLow    = type & 0xFF;
    desc.TypeHi     = (type >> 8) & 0xF;
}

void Gdt::load(void) const {
    __asm__ __volatile__("lgdt %0" :: "m" (Table));
}
