var jInputObjs = null;
var jVdCdtnObjs = null;
var jRsObjs = null;
var jMustObjs = null;
var jWin = null;
var inInit = true;

$(function(){
	jWin = $(window);

	jInputObjs = $("input[type=text],input[type=radio],input[type=checkbox],textarea,select");

	var jOtherObjs = jInputObjs.filter(".other");
	$.each( jOtherObjs, function( idx ) {
		jWin.data( "other_" + $(this).attr("name"), $(this) );
	});
	$.each( jInputObjs.filter(".otherText"), function( idx ) {
		jWin.data( "otherText_" + $(this).attr("name"), $(this) );
	});

	// ラジオボックスを対象としたその他のイベント登録
	var jOtherIncObjs1 = jOtherObjs.parent().parent().find("input[type=radio]");
	jOtherIncObjs1.click( function(){
		checkOther( $(this) );
	});
	$.each( jOtherIncObjs1, function( idx ) {
		checkOther( $(this) );
	});

	// ラジオボックス以外を対象としたその他のイベント登録
	var jOtherIncObjs2 = jOtherObjs.filter("input[type=checkbox],select,input[type=text]");
	jOtherIncObjs2.click( function(){
		checkOther( $(this) );
	});
	$.each( jOtherIncObjs2, function( idx ) {
		checkOther( $(this) );
	});

	// 条件を発動する項目
	jRsObjs = jInputObjs.filter( "[class*=rscode_]" );
	// 条件を発動する項目のキー(RSCODE)毎のリストを登録する
	$.each( jRsObjs, function( idx ) {
		var cls = $(this).attr( "class" ).split(" ");
		var rscode = null;
		for( var i=0; i<cls.length; i++ ) {
			if( cls[i].indexOf( "rscode_" ) >= 0 ) {
				rscode = cls[i].substring("rscode_".length);
				break;
			}
		}

		if( this.tagName.match(/select/i) ) {
			var rscdList = [];
			$.each( $(this).find("option"), function( idx ) {
				rscdList.push(this);
			});
			jWin.data( "rscode_"+rscode , rscdList );
		}
		else {
			var rscdList = jWin.data( "rscode_"+rscode );
			if( rscdList == null )	{ rscdList = [this]; }
			else					{ rscdList.push(this); }
			jWin.data( "rscode_"+rscode , rscdList );
		}
	});

	if( jRsObjs && jRsObjs.length > 0 ) {
		jMustObjs = $("input[type=hidden][name=h_must_must]");
	}

	// 条件により有効/無効が切り替わる項目を、その条件を発動する項目に対して登録する
	var jPrtCache = {};
	$.each( jInputObjs.filter( ".vdcdtn" ), function( idx ) {

		var keyVal = $(this).attr( "vdcdtn" ).split("=");
		var rscode = keyVal[0];
		var rkcode = keyVal[1].split(",");
		for( var i=0; i<rkcode.length; i++ ) {
			// 親項目一覧(RSCODE)、親項目(RSCODE+RKCODE)で2段階キャッシュ
			var jPrt = jPrtCache[ "parent__" + rscode + "__" + rkcode[i] ];
			if( jPrt == null ) {
				var jPrtLst = jPrtCache[ "parent__" + rscode ];
				if( jPrtLst == null ) {
					jPrtLst = jRsObjs.filter(".rscode_"+rscode);
					jPrtCache[ "parent__" + rscode ] = jPrtLst;
				}

				if( jPrtLst.get(0).tagName.match(/select/i) )	{ jPrt = jPrtLst.find(".rkcode_"+rkcode[i]); }
				else											{ jPrt = jPrtLst.filter(".rkcode_"+rkcode[i]); }
				jPrtCache[ "parent__" + rscode + "__" + rkcode[i] ] = jPrt;
			}
			// 条件発動項目には、子項目のname属性を配列で登録する。
			var name = $(this).attr( "name" );
			var chldList = jPrt.data( "chldList" );
			if( chldList == null )	{ chldList = [name]; }
			else					{ chldList.push(name); }
			jPrt.data( "chldList", chldList );

			// windowsオブジェクトに、子項目のname属性をキーとした、子項目のオブジェクト一覧を登録する。
			var chldObj = jWin.data( name );
			if( chldObj == null ) {
				// 子要素単位の必須属性のhiddenオブジェクトもキャッシュする。
				jWin.data( name + "_h_must", jMustObjs.filter("[value="+name+"]") );
				chldObj = [this];
			}
			else {
				chldObj.push(this);
			}
			jWin.data( name, chldObj );
		}
	});

	jRsObjs.filter("input[type=radio],input[type=checkbox]").click( function(){
		checkVdcdtn( $(this) );
	});
	jRsObjs.filter("select").change( function(){
		checkVdcdtn( $(this) );
	});

	$.each( jRsObjs.filter("input[type=radio],input[type=checkbox],select"), function( idx ) {
		checkVdcdtn( $(this) );
	});

	inInit = false;
});

function checkOther( jThis ) {
	var nm = jThis.attr("name");

	// 初期化の際は、1項目辺り複数回処理されないようにする。
	if( inInit ) {
		if( jWin.data( "init_"+nm ) )		{ return; }
		else								{ jWin.data( "init_"+nm, true ); }
	}

	var jOther = jWin.data( "other_" + nm );
	var jOtherText = jWin.data( "otherText_" + nm );

	if( !jOtherText || jOtherText.length == 0 ) {
		return;
	}

	if( jOther.attr("checked") ) {
		jOtherText.removeAttr("disabled");
		jOtherText.css("background-color","");
	}
	else {
//		jOtherText.val("");
		jOtherText.attr("disabled","true");
		jOtherText.css("background-color","lightgrey");
	}
}

function checkVdcdtn( jThis, type ) {
	var cls = jThis.attr( "class" ).split(" ");
	var rscode = null;
	for( var i=0; i<cls.length; i++ ) {
		if( cls[i].indexOf( "rscode_" ) >= 0 ) {
			rscode = cls[i].substring("rscode_".length);
			break;
		}
	}

	var rscdList = jWin.data( "rscode_"+rscode );
	if( rscdList == null ) { return; }

	// 初期化の際は、1項目辺り複数回処理されないようにする。
	if( inInit ) {
		if( jWin.data( "init_"+rscode ) )	{ return; }
		else								{ jWin.data( "init_"+rscode, true ); }
	}

	var changeList = [];
	for( var i=0; i<rscdList.length; i++ ) {
		var jRsObj = $(rscdList[i]);
		// 子項目のname属性の配列
		var chldList = jRsObj.data( "chldList" );
		if( chldList != null ) {
			// 有効化/無効化する子要素のname属性の一覧(changeList)を作成する。
			// 複数の条件により有効化/無効化される場合は、1つでも有効条件が存在する場合は、有効化する。
			for( var j=0; j<chldList.length; j++ ) {
				if( jRsObj.get(0).tagName.match(/option/i) ) {
					if( jRsObj.filter("option:selected").length > 0 )	{ changeList[chldList[j]] = true; }
					else if( changeList[chldList[j]] == null )			{ changeList[chldList[j]] = false; }
				}
				else {
					if( jRsObj.attr("checked") )						{ changeList[chldList[j]] = true; }
					else if( changeList[chldList[j]] == null )			{ changeList[chldList[j]] = false; }
				}
			}
		}
	}

	for( var list in changeList ) {
		var isValid = changeList[list];
		var chldList = jWin.data( list );
		for( var i=0; i<chldList.length; i++ ) {
			jTs = $(chldList[i]);
			if( isValid && jTs.attr("disabled") ) {
				if( !jTs.hasClass("otherText") ) {
					jTs.removeAttr("disabled").css("background-color","");
					jWin.data( jTs.attr("name") + "_h_must" ).attr("name","h_must_must");
				}
			}
			else if( !isValid && !jTs.attr("disabled") ) {
				jTs.attr("disabled","true").css("background-color","lightgrey");
				jWin.data( jTs.attr("name") + "_h_must" ).attr("name","h_must_must_");
			}
		}
	}

}
