<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" />
<jsp:directive.include file="/jsp/custom/result_info.jsp" />

<!-- ワーニングメッセージです。ここでは、登録完了のメッセージを表示します。 -->
<og:errorMessage command="{@command}" clear="{@clear}" displayMsg="{@displayMsg}" />

<og:columnCheck
	command   = "{@command}"
/>

<!-- 取り消しボタンが押された時に必要です。 -->
<og:entry command = "{@command}" />

<og:value command="SQL">
	select A.UNIQ,A.CRYPTKEY,A.FGSHUBETSU
	from AN01 A
	where A.CDANK = '{@CDANK}'
	and A.FGJ = '1'
</og:value>

<og:query command="{@command}" debug="{@debug}" maxRowCount="{@maxRowCount}">
	<jsp:text>
		select A.CDANK,A.CDSITSU,A.SEQNO,A.NAIYO,A.KAISETSU,A.SUPTRITSU,A.SUPOINT,A.SITSUGRP,A.SITSUSGRP,A.IMGNAI,A.FGKEY,A.FGMUST,A.KBUNRUI,A.KLENGTH,A.KNOTE,A.SUONELINE,A.RSCODE,A.INIVAL,A.CSKEY,A.CSWAY,A.SUCS,A.VDCDTN,A.BIKO,A.FGJ,A.DYSET,A.DYUPD,A.UNIQ
				,case
					when A.IMGNAI is null or A.IMGNAI = '' then '0'
					when A.IMGNAI like '%.png' or A.IMGNAI like '%.PNG'
						or A.IMGNAI like '%.jpg' or A.IMGNAI like '%.JPG'
						or A.IMGNAI like '%.jpeg' or A.IMGNAI like '%.JPEG'
						or A.IMGNAI like '%.gif' or A.IMGNAI like '%.GIF'
						or A.IMGNAI like '%.bmp' or A.IMGNAI like '%.BMP' then '1'
					else '2' end FGIMG
		from AN02 A
		where A.USERID = '{@USER.ID}'
	</jsp:text>
	<og:where startKey="and">
		<og:and value = "A.CDANK		=		'{@CDANK}'" />
		<og:and value = "A.NAIYO		like	'%{@NAIYO}%'" />
		<og:and value = "A.FGJ			=		'{@FGJ}'" />
	</og:where>
	<og:appear startKey = "order by" value = "{@ORDER_BY}"
				defaultVal = "A.SEQNO" />
</og:query>

<og:columnEditor columns="SEQNO,NAIYO,FGMUST,KBUNRUI,KLENGTH,SUPTRITSU" must="true" />

<og:viewLink command="{@command}">
	<og:link column="NAIYO" gamenId="AN0004" href="index.jsp" target="_top" onLink="[KBUNRUI]" markList="RADIO|CHBOX|MENU|SCALE"
		keys="command,CDANK,CDSITSU,FGJ"
		vals="NEW,[CDANK],[CDSITSU],1" />
</og:viewLink>

<og:viewMarker command="{@command}">
	<og:columnMarker column="IMGNAI" onMark="[FGIMG]" markList="1" >
		<a href="/{@SYS.CONTEXT_NAME}/ankimages/[IMGNAI]" target="IMAGE">
			<img src="/{@SYS.CONTEXT_NAME}/ankimages/[IMGNAI]" width="50px" height="50px" />
		</a>
		<a href="{@SYS.JSP}/customan/upload.jsp?action=DELETE&amp;FILE_PATH=ankimages/[IMGNAI]&amp;TBLNAME=AN02&amp;CLMNAME=IMGNAI&amp;CLMSNAME=IMGSNAI&amp;UNIQ=[UNIQ]&amp;GAMENID={@GUI.KEY}">
			<img src="/{@SYS.CONTEXT_NAME}/jsp/image/DeleteFile.gif" />
		</a>
		<a href="{@SYS.JSP}/customan/filePopup.jsp?BASE_DIR=ankimages&amp;NEWPATH=[CDANK]&amp;NEWNAME=[CDANK]/[CDSITSU]&amp;TBLNAME=AN02&amp;CLMNAME=IMGNAI&amp;CLMSNAME=IMGSNAI&amp;UNIQ=[UNIQ]&amp;GAMENID={@GUI.KEY}">
			<img src="/{@SYS.CONTEXT_NAME}/jsp/image/search_18x16.gif" />
		</a>
	</og:columnMarker>
	<og:columnMarker column="IMGNAI" onMark="[FGIMG]" markList="2" >
		<a href="/{@SYS.CONTEXT_NAME}/ankimages/[IMGNAI]" target="IMAGE">
			<img src="/{@SYS.CONTEXT_NAME}/jsp/image/text.gif" width="30px" height="30px" />
		</a>
		<a href="{@SYS.JSP}/customan/upload.jsp?action=DELETE&amp;FILE_PATH=ankimages/[IMGNAI]&amp;TBLNAME=AN02&amp;CLMNAME=IMGNAI&amp;CLMSNAME=IMGSNAI&amp;UNIQ=[UNIQ]&amp;GAMENID={@GUI.KEY}">
			<img src="/{@SYS.CONTEXT_NAME}/jsp/image/DeleteFile.gif" />
		</a>
		<a href="{@SYS.JSP}/customan/filePopup.jsp?BASE_DIR=ankimages&amp;NEWPATH=[CDANK]&amp;NEWNAME=[CDANK]/[CDSITSU]&amp;TBLNAME=AN02&amp;CLMNAME=IMGNAI&amp;CLMSNAME=IMGSNAI&amp;UNIQ=[UNIQ]&amp;GAMENID={@GUI.KEY}">
			<img src="/{@SYS.CONTEXT_NAME}/jsp/image/search_18x16.gif" />
		</a>
	</og:columnMarker>
	<og:columnMarker column="IMGNAI" onMark="[FGIMG]" markList="0" >
		<a href="{@SYS.JSP}/customan/filePopup.jsp?BASE_DIR=ankimages&amp;NEWPATH=[CDANK]&amp;NEWNAME=[CDANK]/[CDSITSU]&amp;TBLNAME=AN02&amp;CLMNAME=IMGNAI&amp;CLMSNAME=IMGSNAI&amp;UNIQ=[UNIQ]&amp;GAMENID={@GUI.KEY}">
			<img src="/{@SYS.CONTEXT_NAME}/jsp/image/search_18x16.gif" />
		</a>
	</og:columnMarker>
</og:viewMarker>

<form onSubmit="return oneClick();" method="POST" action="forward.jsp" target="RESULT">
<og:writeCheck>
	<og:input name="repeatCount" value="1" lbl="" td="false" size="2"/>
	<og:submit  value="update"   lbl="COPY"      command="COPY"   accesskey="C"
		keys="noWritable" vals='"CDANK,CDSITSU,IMGNAI,SUPOINT,FGJ,DYSET,DYUPD"' />
	<og:submit  value="update"   lbl="MODIFY"    command="MODIFY" accesskey="M"
		keys="noWritable" vals='"CDANK,CDSITSU,IMGNAI,SUPOINT,FGJ,DYSET,DYUPD"' />
	<og:submit  value="update"   lbl="DELETE"    command="DELETE" accesskey="D"
		keys="columnWritable" vals="null" />
	&amp;nbsp;
	<og:link gamenId="AN0008" href="index.jsp"
		keys="command,KEY" vals="NEW,{@CRYPTKEY}" lbl="ANKPREV" target="_top" />
<br />
</og:writeCheck>

<og:equals val1="{@FGSHUBETSU}" val2="2" notEquals="true">
	<og:value command="SET" key="NO_DISP" value=",SUPTRITSU,SUPOINT,KAISETSU" />
</og:equals>
<og:hidden name="FGSHUBETSU" value="{@FGSHUBETSU}" />

<og:view
	viewFormType = "HTMLTable"
	command		= "{@command}"
	noDisplay	= "CDANK,CDSITSU,UNIQ,FGIMG,FGKEY{@NO_DISP}"
	checked		= "{@checked}"
	startNo		= "{@startNo}"
	pageSize	= "{@pageSize}" />
</form>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
