/**************************************************************************/
/* AN11 ( アンケート回答ヘッダ )                                          */
/*                                                                        */
/* Created : 2011/11/04 13:00:49                                          */
/**************************************************************************/
CREATE TABLE AN11 (
   NOKAITO  VARCHAR2(10)                NOT NULL      /* 1  回答番号         */
 , USERID   VARCHAR2(10)                NOT NULL      /* 2  ユーザーID       */
 , CDANK    VARCHAR2(10)                NOT NULL      /* 3  アンケートC      */
 , KIPADDR  VARCHAR2(15)                NOT NULL      /* 4  回答者IPアドレス */
 , KLIPADDR VARCHAR2(15)                NOT NULL      /* 5  回答者ローカルIP */
 , DYKAITO  VARCHAR2(14)                NOT NULL      /* 6  回答日時         */
 , KUID     VARCHAR2(10)                NOT NULL      /* 7  回答者ID         */
 , SUSPOINT NUMBER(3)       DEFAULT 0   NOT NULL      /* 8  合計得点         */
 , UNIQ     NUMBER(9)       DEFAULT 0   NOT NULL      /* 9  ユニークキー     */
 , FGJ      VARCHAR2(1)     DEFAULT '1' NOT NULL      /* 10 状態フラグ       */
 , DYSET    VARCHAR2(14)                              /* 11 登録日時         */
 , PGSET    VARCHAR2(10)                              /* 12 作成PG           */
 , PGPSET   VARCHAR2(10)                              /* 13 作成親PG         */
 , USRSET   VARCHAR2(10)                              /* 14 作成社員         */
 , DYUPD    VARCHAR2(14)                              /* 15 更新日時         */
 , PGUPD    VARCHAR2(10)                              /* 16 更新PG           */
 , PGPUPD   VARCHAR2(10)                              /* 17 更新親PG         */
 , USRUPD   VARCHAR2(10)                              /* 18 更新者           */
)
TABLESPACE GMIS01
STORAGE( INITIAL 16K NEXT 16K PCTINCREASE 0 );


CREATE SEQUENCE AN11S00 
INCREMENT BY 1 START WITH 1 MAXVALUE 999999999 CYCLE NOCACHE;


CREATE OR REPLACE TRIGGER AN11T00 
BEFORE INSERT ON AN11
FOR EACH ROW 
BEGIN 
SELECT AN11S00.NEXTVAL INTO :NEW.UNIQ FROM DUAL; 
END; 
/

