/**************************************************************************/
/* AN03 ( アンケート項目詳細マスタ )                                      */
/*                                                                        */
/* Created : 2011/11/04 13:00:49                                          */
/**************************************************************************/
CREATE TABLE AN03 (
   USERID    VARCHAR2(10)                  NOT NULL      /* 10  ユーザーID         */
 , CDANK     VARCHAR2(10)                  NOT NULL      /* 20  アンケートC        */
 , CDSITSU   VARCHAR2(10)                  NOT NULL      /* 30  質問C              */
 , KVAL      VARCHAR2(4000)                NOT NULL      /* 40  回答値             */
 , SEQNO     NUMBER(7)         DEFAULT 0   NOT NULL      /* 50  表示順             */
 , KNAME     VARCHAR2(4000)                NOT NULL      /* 60  回答名称           */
 , KSCALE    NUMBER(1)         DEFAULT 5   NOT NULL      /* 70  回答スケール       */
 , IMGKVAL   VARCHAR2(200)                               /* 80  回答値画像         */
 , IMGSKVAL  VARCHAR2(10)                                /* 90  回答値画像(拡張子) */
 , FGOTHER   VARCHAR2(1)       DEFAULT '0' NOT NULL      /* 100 その他             */
 , RKCODE    VARCHAR2(20)                                /* 110 連携用回答C        */
 , FGCORRECT VARCHAR2(1)                                 /* 120 正解               */
 , BIKO      VARCHAR2(4000)                              /* 130 備考               */
 , UNIQ      NUMBER(9)         DEFAULT 0   NOT NULL      /* 140 ユニークキー       */
 , FGJ       VARCHAR2(1)       DEFAULT '1' NOT NULL      /* 150 状態フラグ         */
 , DYSET     VARCHAR2(14)                                /* 160 登録日時           */
 , PGSET     VARCHAR2(10)                                /* 170 作成PG             */
 , PGPSET    VARCHAR2(10)                                /* 180 作成親PG           */
 , USRSET    VARCHAR2(10)                                /* 190 作成社員           */
 , DYUPD     VARCHAR2(14)                                /* 200 更新日時           */
 , PGUPD     VARCHAR2(10)                                /* 210 更新PG             */
 , PGPUPD    VARCHAR2(10)                                /* 220 更新親PG           */
 , USRUPD    VARCHAR2(10)                                /* 230 更新者             */
)
TABLESPACE GMIS01
STORAGE( INITIAL 16K NEXT 16K PCTINCREASE 0 );


CREATE SEQUENCE AN03S00 
INCREMENT BY 1 START WITH 1 MAXVALUE 999999999 CYCLE NOCACHE;


CREATE OR REPLACE TRIGGER AN03T00 
BEFORE INSERT ON AN03
FOR EACH ROW 
BEGIN 
SELECT AN03S00.NEXTVAL INTO :NEW.UNIQ FROM DUAL; 
END; 
/

