/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.io;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.jfree.data.DefaultKeyedValues;
import org.jfree.data.KeyedValues;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.data.general.Dataset;
import org.jfree.data.general.DefaultPieDataset;
import org.jfree.data.general.DefaultValueDataset;
import org.jfree.data.jdbc.JDBCPieDataset;
import org.jfree.data.jdbc.JDBCXYDataset;
import org.jfree.data.xy.CategoryTableXYDataset;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.hayabusa.common.HybsSystem;
import org.opengion.hayabusa.common.HybsSystemException;
import org.opengion.hayabusa.db.DBTableModel;
import org.opengion.hayabusa.io.ChartPlot;
import org.opengion.hayabusa.io.HybsJDBCCategoryDataset2;
import org.opengion.hayabusa.io.TypeRenderer;

public class ChartFactory {
    private static final String PLOT_SUB = "org.opengion.hayabusa.io.ChartPlot_";
    private static volatile ChartPlot plot_cat = null;
    private static volatile ChartPlot plot_xy = null;
    private static volatile ChartPlot plot_pie = null;
    private static final Object lock = new Object();
    private static final Map<String, TypeRenderer> TYPE_RENDERER_MAP = new HashMap<String, TypeRenderer>();

    private ChartFactory() {
    }

    public static final Dataset newDataset(Connection connection, String string, String string2) throws SQLException {
        HybsJDBCCategoryDataset2 hybsJDBCCategoryDataset2;
        TypeRenderer typeRenderer = ChartFactory.getTypeRenderer(string2);
        String string3 = typeRenderer.getDatasetType();
        if ("Category".equalsIgnoreCase(string3)) {
            hybsJDBCCategoryDataset2 = new HybsJDBCCategoryDataset2(connection, string);
        } else if ("XY".equalsIgnoreCase(string3)) {
            hybsJDBCCategoryDataset2 = new JDBCXYDataset(connection, string);
        } else if ("Pie".equalsIgnoreCase(string3)) {
            hybsJDBCCategoryDataset2 = new JDBCPieDataset(connection, string);
        } else if ("Value".equalsIgnoreCase(string3)) {
            hybsJDBCCategoryDataset2 = new DefaultValueDataset();
        } else if ("GanttCategory".equalsIgnoreCase(string3)) {
            hybsJDBCCategoryDataset2 = new HybsJDBCCategoryDataset2(connection, string);
        } else if ("IntervalCategory".equalsIgnoreCase(string3)) {
            hybsJDBCCategoryDataset2 = new HybsJDBCCategoryDataset2(connection, string);
        } else if ("StatisticalCategory".equalsIgnoreCase(string3)) {
            hybsJDBCCategoryDataset2 = new HybsJDBCCategoryDataset2(connection, string);
        } else {
            String string4 = "Category,Pie,XY,Value \u4ee5\u5916\u306eDataset \u306f\u30b5\u30dd\u30fc\u30c8\u3057\u3066\u3044\u307e\u305b\u3093\u3002[" + string3 + "]";
            throw new HybsSystemException(string4);
        }
        return hybsJDBCCategoryDataset2;
    }

    public static final Dataset newDataset(DBTableModel dBTableModel, String string) {
        DefaultCategoryDataset defaultCategoryDataset;
        TypeRenderer typeRenderer = ChartFactory.getTypeRenderer(string);
        int n = dBTableModel.getColumnCount();
        int n2 = dBTableModel.getRowCount();
        String string2 = typeRenderer.getDatasetType();
        if ("Category".equalsIgnoreCase(string2)) {
            DefaultCategoryDataset defaultCategoryDataset2 = new DefaultCategoryDataset();
            String[] stringArray = dBTableModel.getNames();
            for (int i = 0; i < n2; ++i) {
                String string3 = (String)dBTableModel.getValue(i, 0);
                String[] stringArray2 = (String[])dBTableModel.getValues(i);
                for (int j = 1; j < n; ++j) {
                    String string4 = stringArray2[j];
                    double d = string4 == null || string4.length() == 0 ? 0.0 : Double.parseDouble(string4);
                    defaultCategoryDataset2.addValue(d, (Comparable)((Object)stringArray[j]), (Comparable)((Object)string3));
                }
            }
            defaultCategoryDataset = defaultCategoryDataset2;
        } else if ("XY".equalsIgnoreCase(string2)) {
            CategoryTableXYDataset categoryTableXYDataset = new CategoryTableXYDataset();
            String[] stringArray = dBTableModel.getNames();
            for (int i = 0; i < n2; ++i) {
                String[] stringArray3 = (String[])dBTableModel.getValues(i);
                double d = stringArray3[0] == null || stringArray3[0].length() == 0 ? 0.0 : Double.parseDouble(stringArray3[0]);
                for (int j = 1; j < n; ++j) {
                    String string5 = stringArray3[j];
                    double d2 = string5 == null || string5.length() == 0 ? 0.0 : Double.parseDouble(string5);
                    categoryTableXYDataset.add(d, d2, stringArray[j]);
                }
            }
            defaultCategoryDataset = categoryTableXYDataset;
        } else if ("Pie".equalsIgnoreCase(string2)) {
            DefaultKeyedValues defaultKeyedValues = new DefaultKeyedValues();
            for (int i = 0; i < n2; ++i) {
                String[] stringArray = (String[])dBTableModel.getValues(i);
                String string6 = stringArray[0];
                String string7 = stringArray[1];
                double d = string7 == null || string7.length() == 0 ? 0.0 : Double.parseDouble(string7);
                defaultKeyedValues.addValue((Comparable)((Object)string6), d);
            }
            defaultCategoryDataset = new DefaultPieDataset((KeyedValues)defaultKeyedValues);
        } else if ("Value".equalsIgnoreCase(string2)) {
            defaultCategoryDataset = new DefaultValueDataset();
        } else {
            String string8 = "Category,Pie,XY,Value \u4ee5\u5916\u306eDataset \u306f\u30b5\u30dd\u30fc\u30c8\u3057\u3066\u3044\u307e\u305b\u3093\u3002[" + string2 + "]";
            throw new HybsSystemException(string8);
        }
        return defaultCategoryDataset;
    }

    public static final TypeRenderer getTypeRenderer(String string) {
        TypeRenderer typeRenderer = TYPE_RENDERER_MAP.get(string);
        if (typeRenderer == null) {
            String string2 = "\u6307\u5b9a\u306e\u30bf\u30a4\u30d7\u306b\u8a72\u5f53\u3059\u308b Renderer \u306f\u30b5\u30dd\u30fc\u30c8\u3057\u3066\u3044\u307e\u305b\u3093\u3002[" + string + "]" + HybsSystem.CR + "Key=" + Arrays.toString(TYPE_RENDERER_MAP.keySet().toArray(new String[TYPE_RENDERER_MAP.size()]));
            throw new HybsSystemException(string2);
        }
        return typeRenderer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final ChartPlot newChartPlot(String string) {
        ChartPlot chartPlot;
        TypeRenderer typeRenderer = TYPE_RENDERER_MAP.get(string);
        String string2 = typeRenderer.getPlotType();
        if ("Category".equalsIgnoreCase(string2)) {
            Object object = lock;
            synchronized (object) {
                if (plot_cat == null) {
                    plot_cat = (ChartPlot)StringUtil.newInstance((String)(PLOT_SUB + string2));
                }
            }
            chartPlot = plot_cat;
        } else if ("XY".equalsIgnoreCase(string2)) {
            Object object = lock;
            synchronized (object) {
                if (plot_xy == null) {
                    plot_xy = (ChartPlot)StringUtil.newInstance((String)(PLOT_SUB + string2));
                }
            }
            chartPlot = plot_xy;
        } else {
            Object object = lock;
            synchronized (object) {
                if (plot_pie == null) {
                    plot_pie = (ChartPlot)StringUtil.newInstance((String)"org.opengion.hayabusa.io.ChartPlot_Pie");
                }
            }
            chartPlot = plot_pie;
        }
        return chartPlot;
    }

    static {
        String[][] stringArrayArray = new String[][]{{"HybsLine", "HybsLineRenderer", "Category", "Category"}, {"HybsBar", "HybsBarRenderer", "Category", "Category"}, {"HybsStackedBar", "HybsStackedBarRenderer", "Category", "Category"}, {"Area", "category.AreaRenderer", "Category", "Category"}, {"Bar", "category.BarRenderer", "Category", "Category"}, {"Bar3D", "category.BarRenderer3D", "Category", "Category"}, {"CategoryStep", "category.CategoryStepRenderer", "Category", "Category"}, {"GroupedStackedBar", "category.GroupedStackedBarRenderer", "Category", "Category"}, {"LayeredBar", "category.LayeredBarRenderer", "Category", "Category"}, {"Level", "category.LevelRenderer", "Category", "Category"}, {"LineAndShape", "category.LineAndShapeRenderer", "Category", "Category"}, {"Line3D", "category.LineRenderer3D", "Category", "Category"}, {"MinMax", "category.MinMaxCategoryRenderer", "Category", "Category"}, {"StackedArea", "category.StackedAreaRenderer", "Category", "Category"}, {"StackedBar", "category.StackedBarRenderer", "Category", "Category"}, {"StackedBar3D", "category.StackedBarRenderer3D", "Category", "Category"}, {"StatisticalLineAndShape", "category.StatisticalLineAndShapeRenderer", "Category", "Category"}, {"WaterfallBar", "category.WaterfallBarRenderer", "Category", "Category"}, {"ClusteredXYBar", "xy.ClusteredXYBarRenderer", "XY", "XY"}, {"CyclicXYItem", "xy.CyclicXYItemRenderer", "XY", "XY"}, {"Deviation", "xy.DeviationRenderer", "XY", "XY"}, {"StackedXYArea", "xy.StackedXYAreaRenderer", "XY", "XY"}, {"StackedXYArea2", "xy.StackedXYAreaRenderer2", "XY", "XY"}, {"StackedXYBar", "xy.StackedXYBarRenderer", "XY", "XY"}, {"StandardXYItem", "xy.StandardXYItemRenderer", "XY", "XY"}, {"XYArea", "xy.XYAreaRenderer", "XY", "XY"}, {"XYArea2", "xy.XYAreaRenderer2", "XY", "XY"}, {"XYBar", "xy.XYBarRenderer", "XY", "XY"}, {"XYBlock", "xy.XYBlockRenderer", "XY", "XY"}, {"XYBubble", "xy.XYBubbleRenderer", "XY", "XY"}, {"XYDifference", "xy.XYDifferenceRenderer", "XY", "XY"}, {"XYDot", "xy.XYDotRenderer", "XY", "XY"}, {"XYError", "xy.XYErrorRenderer", "XY", "XY"}, {"XYLine3D", "xy.XYLine3DRenderer", "XY", "XY"}, {"XYLineAndShape", "xy.XYLineAndShapeRenderer", "XY", "XY"}, {"XYStepArea", "xy.XYStepAreaRenderer", "XY", "XY"}, {"XYStep", "xy.XYStepRenderer", "XY", "XY"}, {"YInterval", "xy.YIntervalRenderer", "XY", "XY"}, {"Compass", null, "Value", "Compass"}, {"Meter", null, "Value", "Meter"}, {"MultiplePie", null, "Category", "MultiplePie"}, {"Pie", null, "Pie", "Pie"}, {"Pie3D", null, "Pie", "Pie"}, {"Ring", null, "Pie", "Ring"}, {"SpiderWeb", null, "Category", "SpiderWeb"}, {"Thermometer", null, "Value", "Thermometer"}};
        for (int i = 0; i < stringArrayArray.length; ++i) {
            TYPE_RENDERER_MAP.put(stringArrayArray[i][0], new TypeRenderer(stringArrayArray[i][0], stringArrayArray[i][1], stringArrayArray[i][2], stringArrayArray[i][3]));
        }
    }
}

