/*
 * Copyright (c) 2009 The openGion Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package an;

import org.opengion.fukurou.business.BizLogic_TABLE;
import org.opengion.fukurou.util.StringUtil;

/**
 * アンケート回答  (OP1003A) の 業務ロジックです。
 *
 * @og.rev 2010/06/18 新規作成
 * 
 * @version 5.0
 * @author Hiroki Nakamura
 * @since JDK1.6,
 */
public class OP1003A extends BizLogic_TABLE {

	private int	mcnt	= 1;
	private int suspoint = 0;

	/**
	 * メインカーソルの一番初めで呼ばれるチェックロジックを定義します。
	 * 
	 * @return 処理が正常終了したか
	 */
	protected boolean fstchk() {
		// 1.0 (2010/12/01) 戻るボタン対策
//		GregorianCalendar cal = new GregorianCalendar(
//		Integer.valueOf( var( "DYKAITO" ).substring( 0, 4 ) )
//			, Integer.valueOf( var( "DYKAITO" ).substring( 4, 6 ) ) - 1
//			, Integer.valueOf( var( "DYKAITO" ).substring( 6, 8 ) )
//			, Integer.valueOf( var( "DYKAITO" ).substring( 8, 10 ) )
//			, Integer.valueOf( var( "DYKAITO" ).substring( 10, 12 ) )
//			, Integer.valueOf( var( "DYKAITO" ).substring( 12, 14 ) )
//			);
//
//		if( System.currentTimeMillis() - cal.getTimeInMillis() <= 10 * 60 * 1000 ) {
//			error( 2, "ANE0034" );
//			return false;
//		}
		String cnt = "select count(*) CNT from AN11 A where A.NOKAITO='{@T_NOKAITO}' and A.FGJ='1'";
		sql( cnt );
		if( vari( "CNT" ) > 0 ) {
			error( 2, "ANE0035" );
			return false;
		}
		else {
			set( "NOKAITO", var( "T_NOKAITO" ) );
		}

		// 0.2 (2010/09/01) 複数回答禁止機能対応・回答者指定機能対応
		String chk = "select A.FGNODPL, A.FGKOKAI "
			+ "from AN01 A "
			+ "where A.CDANK = [CDANK] "
			+ "and A.FGJ = '1'";
		sql( chk );

		if( "1".equals( var( "FGNODPL" ) ) ) {
			String cnt2 = "select count(*) CNT2, max( DYKAITO ) DYKAITO from AN11 A "
							+ "where A.USERID = [USERID] and A.CDANK = [CDANK] and A.FGJ = '1'";

			if( "3".indexOf( var( "FGKOKAI" ) ) >= 0 ) {
				cnt2 += "and A.KUID = '{@KUID}' ";
			}
			else if( "4".indexOf( var( "FGKOKAI" ) ) >= 0 ) {
				cnt2 += "and A.KUID = '{@CON.USERID}' ";
			}
			else {
				if( "GUEST".equals( var( "CON.USERID" ) ) ) {
					cnt2 += "and A.KIPADDR = '{@IPADDRESS}' ";				
				}
				else {
					cnt2 += "and A.KUID = '{@CON.USERID}' ";
				}
			}
			sql( cnt2 );

			if( vari( "CNT2" ) > 0 ) {
				error( 2, "ANE0006" );
				return false;
			}
		}

		return true;
	}

	/**
	 * メインカーソルの各行(変更区分の各処理の後)で呼ばれるチェックロジックを定義します。
	 * 
	 * @param row 行番号
	 * @return 処理が正常終了したか
	 */
	@Override
	protected boolean allchk( final int row ) {
		return true;
	}

	/**
	 * メインカーソルの一番初めで呼ばれるロジックを定義します。
	 * ここでは何も実装されていません。
	 * 
	 * @return 処理が正常終了したか
	 */
	@Override
	protected boolean first() {
		// 0.1 Oracle、MySQL、HSQLDB対応
//		sql( "select nextval('AN11S01') PGSEQ" );
//		set( "NOKAITO", "K" + StringUtil.intFill( var( "PGSEQ" ), 9 ) );
		// 1.0 (2010/12/01) 戻るボタン対策(回答番号は事前に採番する)
//		String seq = StringUtil.valueOf( seq( "AN11S01" ) );
//		set( "NOKAITO", "K" + StringUtil.intFill( seq, 9 ) );

		set( "KUID_TMP", ( "3".equals( var( "FGKOKAI" ) ) ? var( "KUID" ) :  var( "CON.USERID" ) ) );

		// [暫定対応] 回答者のローカルIPもグローバルIPと同じ値をセットしています。
		String insAN11 = "insert into AN11("
			+ "NOKAITO,USERID,CDANK,KIPADDR,KLIPADDR,DYKAITO,KUID,SUSPOINT"
			+ ",FGJ,DYSET,PGSET,PGPSET,USRSET,DYUPD,PGUPD,PGPUPD,USRUPD"
			+ ") values ("
			+ "'{@NOKAITO}',[USERID],[CDANK],'{@IPADDRESS}','{@IPADDRESS}','{@CON.YMDH}','{@KUID_TMP}',0"
			+ ",'1','{@CON.YMDH}','{@CON.PGID}','{@CON.PGPID}','{@CON.USERID}','{@CON.YMDH}','{@CON.PGID}','{@CON.PGPID}','{@CON.USERID}'"
			+ ")";

		sql( insAN11 );

		return true;
	}

	/**
	 * メインカーソルの各行(変更区分の各処理の後)で呼ばれるロジックを定義します。
	 * 
	 * @param row 行番号
	 * @return 処理が正常終了したか
	 */
	@Override
	protected boolean allrow( final int row ) {
		// 登録直前にも必須入力チェックを行う。
		String kvalPrm = var( "AN_" + line( "CDANK" ) + "_" + line( "CDSITSU" ) );
		// 条件分岐項目については必須チェックを行わない。
		if( "1".equals( line( "FGMUST" ) ) && ( line( "VDCDTN" ) == null || line( "VDCDTN" ).length() == 0 )
			&& ( kvalPrm == null || kvalPrm.length() == 0 ) ) {
			error( 2, "ERR0012", "{#" + "AN_" + line( "CDANK" ) + "_" + line( "CDSITSU" ) + "}" );
			return false;
		}

		// 自由入力項目は、分割しない。
		String[] kvalArr = null;
		if( "TEXT".equals( line( "KBUNRUI" ) ) || "XTEXT".equals( line( "KBUNRUI" ) )
			|| "YMD".equals( line( "KBUNRUI" ) )  || "YM".equals( line( "KBUNRUI" ) ) || "TEXTAREA".equals( line( "KBUNRUI" ) ) ) {
			kvalArr = new String[1];
			kvalArr[0] = kvalPrm;
		}
		else {
			kvalArr = StringUtil.csv2Array( kvalPrm );
		}

		for( String kval : kvalArr ) {
			if( kval == null || kval.length() == 0 ) { continue; }

			set( "KVAL", kval );
			set( "KNAME", null );
			set( "KVALSCL", null );
			set( "IMGKVAL", null );
			set( "FGOTHER", "0" );

			set( "KVAL_TMP", null );

			// その他で、自由入力された回答の処理
			String sql = "select count(*) CNT from AN03"
				+ " where USERID = [USERID]"
				+ " and CDANK = [CDANK]"
				+ " and CDSITSU = [CDSITSU]"
				+ " and FGJ = '1'";
			sql( sql );

			sql = "select KVAL KVAL_TMP,KNAME,IMGKVAL,FGCORRECT from AN03"
				+ " where USERID = [USERID]"
				+ " and CDANK = [CDANK]"
				+ " and CDSITSU = [CDSITSU]"
				+ " and KVAL = '{@KVAL}'"
				+ " and FGJ = '1'";
			sql( sql );

			// 選択項目で定義されている質問 かつ 回答内容の値が選択項目として定義されていない場合は、その他とみなす
			if( vari( "CNT" ) > 0 && ( var( "KVAL_TMP" ) == null || var( "KVAL_TMP" ).length() == 0 ) ) {
				set( "FGOTHER", "1" );
			}

			// テストアンケート対応
			set( "SUPOINT", "1".equals( var( "FGCORRECT" ) ) ? linei( "SUPOINT" ) : 0 );
			suspoint += vari( "SUPOINT" );

			// スケールによる回答の対応
			if( "SCALE".equals( line( "KBUNRUI" ) ) ) {
				// 登録直前にも必須入力チェックを行う。
				String kvalSclPrm = var( "AN_" + line( "CDANK" ) + "_" + kval );
				if( "1".equals( line( "FGMUST") ) && ( kvalSclPrm == null || kvalSclPrm.length() == 0 ) ) {
					error( 2, "ERR0012", "{#" + "AN_" + line( "CDANK" ) + "_" + kval );
					return false;
				}
				set( "KVALSCL", kvalSclPrm ); 
			}
			if( var( "KVALSCL" ) == null || var( "KVALSCL" ).length() == 0 ) {
				set( "KVALSCL", 0 );
			}

			set( "NOMEISAI", mcnt );
			String insAN12 = "insert into AN12("
				+ "NOKAITO,NOMEISAI,USERID,CDANK,CDSITSU,KVAL,KNAME,FGOTHER,SUPOINT,FGCORRECT,KVALSCL"
				+ ",FGJ,DYSET,PGSET,PGPSET,USRSET,DYUPD,PGUPD,PGPUPD,USRUPD"
				+ ") values ("
				+ "'{@NOKAITO}','{@NOMEISAI}',[USERID],[CDANK],[CDSITSU],'{@KVAL}','{@KNAME}','{@FGOTHER}',{@SUPOINT},'{@FGCORRECT}',{@KVALSCL}"
				+ ",'1','{@CON.YMDH}','{@CON.PGID}','{@CON.PGPID}','{@CON.USERID}','{@CON.YMDH}','{@CON.PGID}','{@CON.PGPID}','{@CON.USERID}'"
				+ ")";
			sql( insAN12 );
			mcnt++;
		}

		return true;
	}

	/**
	 * メインカーソルの一番最後で呼ばれるロジックを定義します。
	 * 
	 * @return 処理が正常終了したか
	 */
	@Override
	protected boolean last() {
		if( suspoint > 0 ) {
			set( "SUSPOINT", suspoint );
			String sql = "update AN11 set SUSPOINT = {@SUSPOINT} where NOKAITO = '{@NOKAITO}'";
			sql( sql );
		}
		rtn( var( "NOKAITO" ) );
		return true;
	}
}
