/**************************************************************************/
/* AN12 ( アンケート回答明細 )                                            */
/*                                                                        */
/* Created : 2011/01/15 13:28:54                                          */
/**************************************************************************/
CREATE TABLE AN12 (
   NOKAITO   VARCHAR2(10)                  NOT NULL      /* 1  回答番号       */
 , NOMEISAI  NUMBER(9)         DEFAULT 0   NOT NULL      /* 2  回答明細番号   */
 , USERID    VARCHAR2(10)                  NOT NULL      /* 3  ユーザーID     */
 , CDANK     VARCHAR2(10)                  NOT NULL      /* 4  アンケートC    */
 , CDSITSU   VARCHAR2(10)                  NOT NULL      /* 5  質問C          */
 , KVAL      VARCHAR2(4000)                NOT NULL      /* 6  回答値         */
 , KVALSCL   NUMBER(1)         DEFAULT 0   NOT NULL      /* 7  回答スケール値 */
 , KNAME     VARCHAR2(4000)                              /* 8  回答名称       */
 , FGOTHER   VARCHAR2(1)       DEFAULT '0' NOT NULL      /* 9  その他         */
 , SUPOINT   NUMBER(3)         DEFAULT 0   NOT NULL      /* 10 得点           */
 , FGCORRECT VARCHAR2(1)                                 /* 11 正解           */
 , UNIQ      NUMBER(9)         DEFAULT 0   NOT NULL      /* 12 ユニークキー   */
 , FGJ       VARCHAR2(1)       DEFAULT '1' NOT NULL      /* 13 状態フラグ     */
 , DYSET     VARCHAR2(14)                                /* 14 登録日時       */
 , PGSET     VARCHAR2(10)                                /* 15 作成PG         */
 , PGPSET    VARCHAR2(10)                                /* 16 作成親PG       */
 , USRSET    VARCHAR2(10)                                /* 17 作成社員       */
 , DYUPD     VARCHAR2(14)                                /* 18 更新日時       */
 , PGUPD     VARCHAR2(10)                                /* 19 更新PG         */
 , PGPUPD    VARCHAR2(10)                                /* 20 更新親PG       */
 , USRUPD    VARCHAR2(10)                                /* 21 更新者         */
)
TABLESPACE GMIS01
STORAGE( INITIAL 16K NEXT 16K PCTINCREASE 0 );


CREATE SEQUENCE AN12S00 
INCREMENT BY 1 START WITH 1 MAXVALUE 999999999 CYCLE NOCACHE;


CREATE OR REPLACE TRIGGER AN12T00 
BEFORE INSERT ON AN12
FOR EACH ROW 
BEGIN 
SELECT AN12S00.NEXTVAL INTO :NEW.UNIQ FROM DUAL; 
END; 
/

