/*
 * Copyright (c) 2009 The openGion Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package an;

import org.opengion.fukurou.business.BizLogic_TABLE;

/**
 * アンケート登録  (AN0002) の 業務ロジックです。
 * 
 * ここでは、アンケートマスタ(AN01)の変更・削除を行っています。
 *
 * @og.rev 2010/06/18 新規作成
 * 
 * @version 5.0
 * @author Hiroki Nakamura
 * @since JDK1.6,
 */
public class AN0002A extends BizLogic_TABLE {

	/**
	 * メインカーソルの各行(変更区分="A")で呼ばれるチェックロジックを定義します。
	 * ここでは何も実装されていません。
	 * 
	 * @param row 行番号
	 * @return 処理が正常終了したか
	 */
	@Override
	protected boolean inschk( final int row ) {
		return true;
	}

	/**
	 * メインカーソルの各行(変更区分="C")で呼ばれるチェックロジックを定義します。
	 * 
	 * @param row 行番号
	 * @return 処理が正常終了したか
	 */
	@Override
	protected boolean modchk( final int row ) {
		// ANE0008:一旦公開したアンケートを、未公開にすることはできません。早期終了する場合は、終了日時を変更を再設定して下さい。
		if( "0".equals( line( "FGKOKAI") ) ) {
//			String sql = "select A.FGKOKAI from AN01 A where A.UNIQ = [UNIQ]";
//			sql( sql );
//			if( !"0".equals( var( "FGKOKAI" ) ) ) {
//				error( 2, "ANE0008", "[NMANK]" );
//			}
		}
		else {
			// 公開する場合は、公開直前にアンケート設定の整合性をチェック
			call( "an.AnkCheck","CDANK","[CDANK]");
		}

		return true;
	}

	/**
	 * メインカーソルの各行(変更区分="D")で呼ばれるチェックロジックを定義します。
	 * ここでは何も実装されていません。
	 * 
	 * @param row 行番号
	 * @return 処理が正常終了したか
	 */
	@Override
	protected boolean delchk( final int row ) {
		return true;
	}

	/**
	 * メインカーソルの各行(変更区分="A")で呼ばれるロジックを定義します。
	 * ここでは何も実装されていません。
	 * 
	 * @param row 行番号
	 * @return 処理が正常終了したか
	 */
	@Override
	protected boolean insert( final int row ) {
		return true;
	}

	/**
	 * メインカーソルの各行(変更区分="C")で呼ばれるロジックを定義します。
	 * 
	 * @param row 行番号
	 * @return 処理が正常終了したか
	 */
	@Override
	protected boolean modify( final int row ) {
		String sql = "update AN01 set"
			+ " NMANK = [NMANK]"
			+ ",SMANK = [SMANK]"
			+ ",FGKOKAI = [FGKOKAI]"
			+ ",DYKSTR = [DYKSTR]"
			+ ",DYKEND = [DYKEND]"
			+ ",FGNODPL = [FGNODPL]"
			+ ",FGRESDISP = [FGRESDISP]"
			+ ",FGTEMPLATE = [FGTEMPLATE]"
			+ ",FGSHUBETSU = [FGSHUBETSU]"
			+ ",KTSTAGS = [KTSTAGS]"
			+ ",IRAIADDRS = [IRAIADDRS]"
			+ ",BIKO = [BIKO]"
			+ ",DYUPD = '{@CON.YMDH}'"
			+ ",PGUPD = '{@CON.PGID}'"
			+ ",PGPUPD = '{@CON.PGID}'"
			+ ",USRUPD = '{@CON.USERID}'"
			+ "where UNIQ = [UNIQ]";
		sql( sql );
		return true;
	}

	/**
	 * メインカーソルの各行(変更区分="D")で呼ばれるロジックを定義します。
	 * 
	 * @param row 行番号
	 * @return 処理が正常終了したか
	 */
	@Override
	protected boolean delete( final int row ) {
		String sql = "update AN01 set"
			+ " FGJ = '9'"
			+ ",DYUPD = '{@CON.YMDH}'"
			+ ",PGUPD = '{@CON.PGID}'"
			+ ",PGPUPD = '{@CON.PGID}'"
			+ ",USRUPD = '{@CON.USERID}'"
			+ "where UNIQ = [UNIQ]";
		sql( sql );
		return true;
	}
}

