<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	xmlns:c="http://java.sun.com/jsp/jstl/core"
	xmlns:fn="http://java.sun.com/jsp/jstl/functions"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" />
<jsp:directive.include file="/jsp/custom/result_info.jsp" />

<!-- ワーニングメッセージです。ここでは、登録完了のメッセージを表示します。 -->
<og:errorMessage command="{@command}" clear="{@clear}" displayMsg="{@displayMsg}" />

<og:columnCheck
	command   = "{@command}"
/>

<!-- 取り消しボタンが押された時に必要です。 -->
<og:entry command = "{@command}" />

<!-- キーのチェック・復号化 -->
<og:bizLogic logics="an.OP0001S" keys="KEY" vals="{@CRYPTKEY}" />
<og:value command="SET" key="CDANK" value="{@RETURN}" />

<og:value command="SQL">
	select A.USERID, A.IRAIADDRS, A.IRAIMLDT, A.FGKOKAI, '{@KTSTAGS}' KTSTAGS, A.FGSHUBETSU
			,'{@SYS.CONTEXT_URL}jsp/index.jsp?k={@CRYPTKEY}' ANKURL
	from AN01 A
	where A.CDANK = '{@CDANK}'
	and A.FGJ = '1'
</og:value>

<og:dataCheck command="NEW" msg="ANE0026" beforeErrorJsp="/jsp/common/history_back.jsp">
	'{@FGKOKAI}' != '0'
</og:dataCheck>

<og:equals val1="34" val2="{@FGKOKAI}" contains="true">
	<og:query command="{@command}" debug="{@debug}" maxRowCount="{@maxRowCount}">
		<jsp:text>
			select '0' FGKAI, '' DYKAITO
					,A.KTSID,A.NMKTS
					,A.MAILAD,A.KTSTAGS
					<og:equals val1="{@FGKOKAI}" val2="3">
						,'{@SYS.CONTEXT_URL}jsp/index.jsp?k={@CRYPTKEY}&amp;u='||A.CRYPTID ANKURL
					</og:equals>
					<og:equals val1="{@FGKOKAI}" val2="3" notEquals="true">
						,'{@SYS.CONTEXT_URL}jsp/index.jsp?k={@CRYPTKEY}' ANKURL
					</og:equals>
					,0 SUSPOINT
			from AN05 A
			where A.USERID = '{@USER.ID}'
			<c:forTokens items="${KTSTAGS}" delims="," var="KTSTAG" varStatus="status">
				${status.first ? " and ( " : "" }
				<og:text>','||A.KTSTAGS||',' like '%,{@KTSTAG},%' {@status.count}</og:text>
				${status.last ? " ) " : " or " }
			</c:forTokens>
			and A.FGJ = '1'
			<og:equals val1="{@ISNOTKAI}" val2="1">
			and not exists( select 'x'
					from AN11 B
					where B.USERID = '{@USER.ID}'
					and B.CDANK = '{@CDANK}'
					and B.KUID = A.KTSID
					and B.FGJ = '1'
			)
			</og:equals>
			order by A.KTSID
		</jsp:text>
	</og:query>

	<og:tableFilter classId="DBSELECT" selectedAll="true">
		select FGJ FGKAI, DYKAITO, SUSPOINT
		from AN11 A
		where A.USERID = '{@USER.ID}'
		and A.CDANK = '{@CDANK}'
		and A.KUID = [KTSID]
		and A.FGJ = '1'
		order by NOKAITO desc
	</og:tableFilter>

	<og:equals val1="{@FGSHUBETSU}" val2="2">
		<og:viewMarker command="{@command}">
			<og:columnMarker column="FGKAI" onMark="[FGKAI]" markList="1">
				[FGKAI] ( [SUSPOINT] {@LBL.POINT} )
			</og:columnMarker>
		</og:viewMarker>
	</og:equals>
</og:equals>

<div style="margin:20px 0px 10px 20px;">

<form onSubmit="return oneClick();" method="POST" action="forward.jsp" target="RESULT">
<og:writeCheck>
	<og:submit  value="entry"   lbl="SEND"      command="ENTRY"   accesskey="S" keys="MAIL" vals="true" />
	<og:submit  value="entry"   lbl="SDCONF"    command="ENTRY"   accesskey="C" />
</og:writeCheck>

<og:equals val1="34" val2="{@FGKOKAI}" contains="true" notEquals="true">
	<table>
		<tr><og:column name="IRAIADDRS" must="true" size="100" /></tr>
		<tr><og:column name="IRAIMLDT" writable="false" /></tr>
		<tr><og:column name="ANKURL" writable="false" /></tr>
	</table>
</og:equals>

<og:equals val1="34" val2="{@FGKOKAI}" contains="true">
	&amp;nbsp;
	<og:link href="index.jsp" gamenId="AN0006" target="_top" keys="command,FGJ" vals="NEW,1" />

	<table>
		<tr><og:column name="KTSTAGS" writable="false" /></tr>
		<tr><og:column name="IRAIMLDT" writable="false" /></tr>
		<og:hidden name="KTSTAGS" value="{@KTSTAGS}" />
	</table>

	<og:view
		viewFormType = "HTMLTable"
		command		= "{@command}"
		noDisplay	= "SUSPOINT"
		checked		= "true"
		startNo		= "{@startNo}"
		pageSize	= "{@pageSize}" />
</og:equals>

<og:hidden name="CDANK" value="{@CDANK}" />
<og:hidden name="USERID" value="{@USERID}" />
<og:hidden name="FGKOKAI" value="{@FGKOKAI}" />
<og:hidden name="CRYPTKEY" value="{@CRYPTKEY}" />

</form>
</div>
<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
