/**************************************************************************/
/* AN05 ( 回答者マスタ )                                                  */
/*                                                                        */
/* Created : 2010/12/04 10:45:10                                          */
/**************************************************************************/
CREATE TABLE AN05 (
   USERID  VARCHAR2(10)                  NOT NULL      /* 1  ユーザーID       */
 , KTSID   VARCHAR2(50)                  NOT NULL      /* 2  回答者ID         */
 , NMKTS   VARCHAR2(500)                 NOT NULL      /* 3  回答者名         */
 , MAILAD  VARCHAR2(200)                               /* 4  メールアドレス   */
 , KTSTAGS VARCHAR2(4000)                              /* 5  回答者タグ       */
 , CRYPTID VARCHAR2(200)                               /* 6  暗号化ユーザーID */
 , UNIQ    NUMBER(9)         DEFAULT 0   NOT NULL      /* 7  ユニークキー     */
 , FGJ     VARCHAR2(1)       DEFAULT '1' NOT NULL      /* 8  状態フラグ       */
 , DYSET   VARCHAR2(14)                                /* 9  登録日時         */
 , PGSET   VARCHAR2(10)                                /* 10 作成PG           */
 , PGPSET  VARCHAR2(10)                                /* 11 作成親PG         */
 , USRSET  VARCHAR2(10)                                /* 12 作成社員         */
 , DYUPD   VARCHAR2(14)                                /* 13 更新日時         */
 , PGUPD   VARCHAR2(10)                                /* 14 更新PG           */
 , PGPUPD  VARCHAR2(10)                                /* 15 更新親PG         */
 , USRUPD  VARCHAR2(10)                                /* 16 更新者           */
)
TABLESPACE GMIS01
STORAGE( INITIAL 16K NEXT 16K PCTINCREASE 0 );


CREATE SEQUENCE AN05S00 
INCREMENT BY 1 START WITH 1 MAXVALUE 999999999 CYCLE NOCACHE;


CREATE OR REPLACE TRIGGER AN05T00 
BEFORE INSERT ON AN05
FOR EACH ROW 
BEGIN 
SELECT AN05S00.NEXTVAL INTO :NEW.UNIQ FROM DUAL; 
END; 
/

