/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.taglib;

import java.io.File;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.tagext.Tag;
import org.opengion.fukurou.db.Transaction;
import org.opengion.fukurou.db.TransactionReal;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.fukurou.util.ToString;
import org.opengion.hayabusa.common.HybsSystem;
import org.opengion.hayabusa.common.HybsSystemException;
import org.opengion.hayabusa.servlet.MultipartRequest;
import org.opengion.hayabusa.taglib.CommonTagSupport;
import org.opengion.hayabusa.taglib.TransactionTag;

public class FileManagerTag
extends CommonTagSupport {
    private static final String VERSION = "4.0.0 (2005/08/31)";
    private static final long serialVersionUID = 4000L;
    private static final String ENCODE = "UTF-8";
    private static final char FS = File.separatorChar;
    private static final String SYSTEM_ID = HybsSystem.sys("SYSTEM_ID");
    private static final String FILE_BASE_URL = HybsSystem.sys("FILE_URL") + "FileMdTemp/";
    private String syfiles = null;
    private String refKey = null;
    private int freeCount = 3;
    private String dbid = null;
    private String tableId = "h_tblmdl";
    private String syfileClm = "SYFILE";
    private String uniqIdClm = "UNIQ_ID";
    private int maxPostSize = 0xA00000;
    private Transaction tran = null;

    @Override
    public int doStartTag() {
        TransactionTag transactionTag = (TransactionTag)FileManagerTag.findAncestorWithClass((Tag)this, TransactionTag.class);
        this.tran = transactionTag == null ? new TransactionReal(this.dbid, this.getApplicationInfo()) : transactionTag.getTransaction();
        return 0;
    }

    @Override
    public int doEndTag() {
        this.debugPrint();
        boolean bl = true;
        try {
            this.tran.commit();
            bl = false;
        }
        catch (HybsSystemException hybsSystemException) {
            this.tran.rollback();
            String string = "\u30d5\u30a1\u30a4\u30eb\u7ba1\u7406\u30e2\u30b8\u30e5\u30fc\u30eb\u306e\u51e6\u7406\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002" + HybsSystem.CR + HybsSystem.CR;
            throw new HybsSystemException(string, hybsSystemException);
        }
        finally {
            this.tran.close(bl);
        }
        return 6;
    }

    @Override
    protected void release2() {
        super.release2();
        this.syfiles = null;
        this.refKey = null;
        this.freeCount = 3;
        this.dbid = null;
        this.tableId = "h_tblmdl";
        this.maxPostSize = 0xA00000;
    }

    private MultipartRequest upload(String string) {
        String[] stringArray;
        HttpServletRequest httpServletRequest = (HttpServletRequest)this.getRequest();
        MultipartRequest multipartRequest = null;
        try {
            stringArray = new File(string);
            if (!stringArray.exists() && !stringArray.mkdirs()) {
                String string2 = "\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u306e\u4f5c\u6210\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002[" + string + "]";
                throw new HybsSystemException(string2);
            }
            multipartRequest = new MultipartRequest(httpServletRequest, string, this.maxPostSize, ENCODE, null);
        }
        catch (IOException iOException) {
            String string3 = "\u30d5\u30a1\u30a4\u30eb\u306e\u53d6\u308a\u6271\u3044\u4e2d\u306b\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002" + this.toString() + HybsSystem.CR + "TempFileDir=" + string + HybsSystem.CR + iOException.getMessage();
            throw new HybsSystemException(string3, iOException);
        }
        for (String string4 : stringArray = multipartRequest.getParameterNames()) {
            this.setRequestAttribute(string4, multipartRequest.getParameter(string4));
        }
        return multipartRequest;
    }

    public void setAction(String string) {
        String string2 = StringUtil.nval((String)this.getRequestParameter(string), null);
    }

    public void setSyfiles(String string) {
        this.syfiles = StringUtil.nval((String)this.getRequestParameter(string), (String)this.syfiles);
    }

    public void setRefKey(String string) {
        this.refKey = StringUtil.nval((String)this.getRequestParameter(string), (String)this.refKey);
    }

    public void setFreeCount(String string) {
        this.freeCount = StringUtil.nval((String)this.getRequestParameter(string), (int)this.freeCount);
    }

    public void setSearchKeys(String string) {
    }

    public void setTableId(String string) {
        this.tableId = StringUtil.nval((String)this.getRequestParameter(string), (String)this.tableId);
    }

    public void setDbid(String string) {
        this.dbid = StringUtil.nval((String)this.getRequestParameter(string), (String)this.dbid);
    }

    public void setMaxPostSize(String string) {
        this.maxPostSize = StringUtil.nval((String)this.getRequestParameter(string), (int)this.maxPostSize);
    }

    @Override
    protected String getTagName() {
        return "fileManager";
    }

    @Override
    public String toString() {
        return ToString.title((String)((Object)((Object)this)).getClass().getName()).println("VERSION", (Object)VERSION).println("ENCODE", (Object)ENCODE).println("maxPostSize", (Object)this.maxPostSize).println("tableId", (Object)this.tableId).println("Other...", (Object)this.getAttributes().getAttribute()).fixForm().toString();
    }
}

